   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 6.00  05/12/93            */
   /*                                                     */
   /*             FUZZY COMMANDS HEADER FILE              */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*      Brian L. Donnell                                     */
/*      Bob Orchard (NRCC - Nat'l Research Council of Canada)*/
/*                  (Fuzzy reasoning extensions)             */
/*                  (certainty factors for facts and rules)  */
/*                  (extensions to run command)              */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/



#ifndef _H_fuzzycom
#define _H_fuzzycom




#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _FUZZYCOM_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ANSI_COMPILER
    LOCALE VOID           DeffuzzyCommands();
    LOCALE VOID          *getu();
    LOCALE double         getu_from();
    LOCALE double         getu_to();
    LOCALE VOID          *getu_units();
    LOCALE VOID          *get_fs();
    LOCALE int            get_fs_length(); 
    LOCALE double         get_fs_x();
    LOCALE double         get_fs_y();
    LOCALE double         moment_defuzzify();
    LOCALE double         maximum_defuzzify();

#else
    LOCALE VOID           DeffuzzyCommands();
    LOCALE VOID          *getu();
    LOCALE double         getu_from();
    LOCALE double         getu_to();
    LOCALE VOID          *getu_units();
    LOCALE VOID          *get_fs();
    LOCALE int            get_fs_length(); 
    LOCALE double         get_fs_x();
    LOCALE double         get_fs_y();
    LOCALE double         moment_defuzzify();
    LOCALE double         maximum_defuzzify();
#endif



#endif

