(deftemplate Tx	; Temperature of the water at shower head
   0 100 Celcius
  ((cold  (z 10  35))
   (OK  (pi 2 36))
   (hot  (s 37  60)) )
  ())

(deftemplate Fx	; Flow of the water at the shower head
   0 100 liters/minute
  ((low  (z 3  11.5))
   (OK  (pi 1 12))
   (strong (s 12.5  25)) )
  () )

(deftemplate change_vc	; change of valve position for cold water
   -1 1
  ((NB (-0.5 1) (-.25 0))
   (NM  (-.35 0) (-.3 1) (-.15 0))
   (NS (-.25 0) (-.15 1) (0 0))
   (Z (-.05 0) (0 1) (.05 0))
   (PS (0 0) (.15 1) (.25 0))
   (PM (.15 0) (.3 1) (.35 0))
   (PB (.25 0)(0.5 1)) )
  ( ; modifier definitions
        (very         sqr)
        (less         sqrt)
  )
)


(deftemplate change_vh	; change of valve position for hot water
   -1 1
  ((NB (-0.5 1) (-.25 0))
   (NM  (-.35 0) (-.3 1) (-.15 0))
   (NS (-.25 0) (-.15 1) (0 0))
   (Z (-.05 0) (0 1) (.05 0))
   (PS (0 0) (.15 1) (.25 0))
   (PM (.15 0) (.3 1) (.35 0))
   (PB (.25 0)(0.5 1)) )
  ( ; modifier definitions
        (very         sqr)
        (less         sqrt)
  )
)

(defrule start
   =>
     (initSimulation) 
    )



(defrule cold_low
   (Tx cold)
   (Fx low)
    =>
   (assert (change_vh PB))
   (assert (change_vc Z))
)

(defrule cold_OK
    (Tx cold)
    (Fx OK)
    =>
   (assert (change_vh  PM))
   (assert (change_vc Z))
)

(defrule cold_strong
    (Tx cold)
    (Fx strong)
     =>
  (assert (change_vh Z))
   (assert (change_vc NB))
)

(defrule OK_low
  (Tx OK)
  (Fx low)
   =>
   (assert (change_vh  PS))
   (assert (change_vc  PS))
)

(defrule OK_strong
  (Tx OK)
  (Fx strong)
   =>
   (assert (change_vh  NS))
   (assert (change_vc NS))
)


(defrule hot_low
  (Tx hot)
   (Fx low)
  =>
   (assert (change_vh Z))
   (assert (change_vc  PB))
)

(defrule hot_OK
  (Tx hot)
  (Fx OK)
   =>
   (assert (change_vh NM))
   (assert (change_vc Z))
)

(defrule hot_strong
   (Tx hot)
   (Fx strong)
   =>
   (assert (change_vh NB))
   (assert (change_vc Z))
)


(defrule defuzzification
   (declare (salience -1)) ; note1 -- must use -1 here so all rules can 
                           ;       -- contribute to the solution (could use
                           ;       -- the MODULE feature as well) 
   ?f1 <- (change_vc ?)    ; note2 -- must use wildcards in next four patterns
   ?f2 <- (change_vh ?)    ;       -- so that match will always occur when
   ?f5 <- (Tx ?)           ;       -- all patterns are available
   ?f6 <- (Fx ?)
 =>
   (bind ?c (moment-defuzzify ?f1))
   (bind ?h (moment-defuzzify ?f2))
   (retract ?f1 ?f2 ?f5 ?f6)
   (SetValvePositions ?h ?c)
)
