(deftemplate Tx
   0 100 Celcius
  ((cold  (z 18 25))
   (cool (15 0) (22 1) (27 1) (35 0))
   (OK  (pi 2 36))
   (warm (37 0) (40 1) (43 1) (46 0))
   (hot  (s 43 47)) )
  ())

(deftemplate Fx
   0 100 liters/minute
  ((little  (z 3 10))
   (low (pi 1.5 10))
   (OK  (pi 1 12))
   (high (pi 4.5 17))    ;??????????????
   (strong (s 15 30)) )
  () )

(deftemplate change_vc
   -1 1
  ((NB (-0.5 1) (-.25 0))
   (NM  (-.35 0) (-.3 1) (-.15 0))
   (NS (-.25 0) (-.15 1) (0 0))
   (Z (-.05 0) (0 1) (.05 0))
   (PS (0 0) (.15 1) (.25 0))
   (PM (.15 0) (.3 1) (.35 0))
   (PB (.25 0)(0.5 1)) )
  ( ; modifier definitions
        (very         sqr)
        (less         sqrt)
  )
)


(deftemplate change_vh
   -1 1
  ((NB (-0.5 1) (-.25 0))
   (NM  (-.35 0) (-.3 1) (-.15 0))
   (NS (-.25 0) (-.15 1) (0 0))
   (Z (-.05 0) (0 1) (.05 0))
   (PS (0 0) (.15 1) (.25 0))
   (PM (.15 0) (.3 1) (.35 0))
   (PB (.25 0)(0.5 1)) )
  ( ; modifier definitions
        (very         sqr)
        (less         sqrt)
  )
)

(defrule start
   =>
     (initSimulation) 
)


(defrule cold_little
   (Tx cold)
   (Fx little)
    =>
   (assert (change_vh PB))
   (assert (change_vc Z))
)

(defrule cold_low
   (Tx cold)
   (Fx low)
    =>
   (assert (change_vh PM))
   (assert (change_vc Z))
)

(defrule cold_OK
    (Tx cold)
    (Fx OK)
    =>
   (assert (change_vh  PM))
   (assert (change_vc NM))
)

(defrule cold_high
   (Tx cold)
   (Fx high)
    =>
   (assert (change_vh Z))
   (assert (change_vc NM))
)

(defrule cold_strong
    (Tx cold)
    (Fx strong)
     =>
  (assert (change_vh Z))
   (assert (change_vc NB))
)

(defrule cool_little
   (Tx cool)
   (Fx little)
    =>
   (assert (change_vh PM))
   (assert (change_vc PS))
)

(defrule cool_low
   (Tx cool)
   (Fx low)
    =>
   (assert (change_vh PS))
   (assert (change_vc Z))
)

(defrule cool_OK
    (Tx cool)
    (Fx OK)
    =>
   (assert (change_vh  PS))
   (assert (change_vc NS))
)

(defrule cool_high
   (Tx cool)
   (Fx high)
    =>
   (assert (change_vh Z))
   (assert (change_vc NS))
)

(defrule cool_strong
    (Tx cool)
    (Fx strong)
     =>
  (assert (change_vh NS))
   (assert (change_vc NM))
)

(defrule OK_little
  (Tx OK)
  (Fx little)
   =>
   (assert (change_vh  PM))
   (assert (change_vc  PM))
)

(defrule OK_low
  (Tx OK)
  (Fx low)
   =>
   (assert (change_vh  PS))
   (assert (change_vc  PS))
)

(defrule OK_high
  (Tx OK)
  (Fx high)
   =>
   (assert (change_vh  NS))
   (assert (change_vc NS))
)

(defrule OK_strong
  (Tx OK)
  (Fx strong)
   =>
   (assert (change_vh  NM))
   (assert (change_vc NM))
)

(defrule warm_little
   (Tx warm)
   (Fx little)
    =>
   (assert (change_vh PS))
   (assert (change_vc PM))
)

(defrule warm_low
   (Tx warm)
   (Fx low)
    =>
   (assert (change_vh Z))
   (assert (change_vc PS))
)

(defrule warm_OK
    (Tx warm)
    (Fx OK)
    =>
   (assert (change_vh  NS))
   (assert (change_vc PS))
)

(defrule warm_high
   (Tx warm)
   (Fx high)
    =>
   (assert (change_vh NS))
   (assert (change_vc Z))
)

(defrule warm_strong
    (Tx warm)
    (Fx strong)
     =>
  (assert (change_vh NM))
   (assert (change_vc NS))
)

(defrule hot_little
  (Tx hot)
   (Fx little)
  =>
   (assert (change_vh Z))
   (assert (change_vc  PB))
)

(defrule hot_low
  (Tx hot)
   (Fx low)
  =>
   (assert (change_vh Z))
   (assert (change_vc  PM))
)

(defrule hot_OK
  (Tx hot)
  (Fx OK)
   =>
   (assert (change_vh NM))
   (assert (change_vc PM))
)

(defrule hot_high
  (Tx hot)
   (Fx high)
  =>
   (assert (change_vh NM))
   (assert (change_vc  Z))
)

(defrule hot_strong
   (Tx hot)
   (Fx strong)
   =>
   (assert (change_vh NB))
   (assert (change_vc Z))
)
 


(defrule defuzzification-and-control
   (declare (salience -1)) ; note1 -- must use -1 here so all rules can 
                           ;       -- contribute to the solution (could use
                           ;       -- the MODULE feature as well) 
   ?f1 <- (change_vc ?)    ; note2 -- must use wildcards in next four patterns
   ?f2 <- (change_vh ?)    ;       -- so that match will always occur when
   ?f5 <- (Tx ?)           ;       -- all patterns are available
   ?f6 <- (Fx ?)
 =>
   (bind ?c (moment-defuzzify ?f1))
   (bind ?h (moment-defuzzify ?f2))
   (retract ?f1 ?f2 ?f5 ?f6)
   (SetValvePositions ?h ?c)
)



 
