;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   sysdoc.cl
;;; Short Desc: Document the system version and features
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   29-04-91
;;; Author:     ThE
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;

;;; just to get some documentation
;;; this is done automatically at load time
(eval-when (load eval)
  (let ((sl (format nil "~%;;; ~73,1,0,'-a" "-")))
    (format t 
	    "~
	    ~&;;; ~a~30T~a~
	    ~&;;; ~a~30T~a~a~
	    ~&;;; ~a~{~%;~30T~a~}~a~
	    ~&;;; ~a~30T~a~a"
	    "Lisp Implementation Type   :" (lisp-implementation-type) 
	    "Lisp Implementation Version:" (lisp-implementation-version) sl
	    "Features:" *features* sl
	    "Current package:" *package* sl
	    )))

(defun sysdoc (&optional (filename "sysdoc.asc"))
  (with-open-file (out filename :direction :output
		   :if-exists :append
		   :if-does-not-exist :create)
    (let ((sl (format nil "~%;;; ~73,1,0,'-a" "-")))
      (format out 
	      "~
	    ~&;;; ~a~30T~a~
	    ~&;;; ~a~30T~a~a~
	    ~&;;; ~a~{~%;~30T~a~}~a~
	    ~&;;; ~a~30T~a~a"
	      "Lisp Implementation Type   :" (lisp-implementation-type) 
	      "Lisp Implementation Version:" (lisp-implementation-version) sl
	      "Features:" *features* sl
	      "Current package:" *package* sl
	      ))))

(eval-when (load eval)
  (format t "~%;;; Use the function (sysdoc)~
             to create the file sysdoc.asc with this information.~%"))