


(defun demo (nr menu-button other-exit-button)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (let* ((disp 
	  (make-instance 'display :title   (concatenate #'string "RPG:" (make-title nr))
			:width   800
			:height  300
			:borders 1
			:left    *rpg-left*
			:bottom  (abs (- *rpg-bottom* 220 ))))
	 
	 (exit-button  (make-instance 'push-button :label "Exit" :width 180))
	 (help-button  (make-instance 'push-button :label "Help" :width 180))
	 (start-button (make-instance 'push-button :label "Start" :width 180))
	 (cont-button  (make-instance 'push-button :label "Continue" :width 180))
	 (verb-button  (make-instance 'radio-button 
			 :label "Verbose Mode"
			 :status *verbose*
			 :action 
			 #'(lambda ()
			   (if *verbose*
			       (progn
				 (setf *verbose* nil)
				 (deactivate-display *verbose-disp*))
			     (progn
			       (setf *verbose* (window *verbose-disp*))
			       (activate-display *verbose-disp*))))))
	 (list-button nil)
	 (demo-comment-disp nil)	)

    (setf demo-comment-disp (make-instance
			      'scroll-display
			     :title "RPG:Comment Window"
			     :active nil
			     :parent disp
			     :font (open-font-named "fixed")
			     :width 300
			     :height 100
			     :borders 1
			     :left 400
			     :bottom 60))
    
    (comment demo-comment-disp "Preparing Demo...")

    (setf (font disp) (open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (font-ascent (font disp))))
    (setf (font disp) *default-font*)

    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (setf *quit* t)
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)
			   (close-display ,*verbose-disp*)
			   (close-display ,disp)))

    (set-button help-button disp 
		:left 15 
		:bottom 15
		:action `(lambda nil 
			   (make-instance 'help-stream
			     :help-filename 
			     (add-path
			      (concatenate 'string
				"demo" (write-to-string ,nr) "-desc.asc")
			      *rpgpath*)
			     :from-button ,help-button)))
    
    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(/ (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
		    (disable-button exit-button)
		    (dialog-handler nr disp 
				    start-button cont-button exit-button
				    *verbose-disp*
				    demo-comment-disp)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (/ (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    (set-button verb-button disp :left (/ (width disp) 4) :bottom 100)

    (when *listener*
      (setf list-button
	(make-instance 'radio-button 
	  :label "Listener Mode"
	  :status *listener*
	  :action 
	  '(lambda ()
	    (setf *listener* (not *listener*)) )))
      (set-button list-button disp :left (/ (width disp) 4) :bottom 120))
    (comment demo-comment-disp "~&~%[Click on <Start> Button]~%")
    ))
  

(defun dialog-handler (nr parent start-button cont-button exit-button 
		       verbose-disp comment-disp)
  (declare (ignore parent))
  (let ((data-disp  (make-instance 'scroll-display
				  :title "RPG:Element Window"
				  :active nil
				  :font (open-font-named "fixed")
				  :width 600
				  :height 200
				  :borders 1
				  :left 10
				  :bottom 125))
	)
    (labels ((clean-up ()
	       (close-display comment-disp)
	       (close-display data-disp)
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      

      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (comment comment-disp "~&~%[Click on <Continue> Button]~%")
	  (do () ((or *quit* *pause*)))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (format nil "dialog-~a" nr) :rpg)))
	(if fun-sym
	    (funcall fun-sym comment-disp data-disp verbose-disp)
	  (comment comment-disp "Demo not implemented.")))
      (wait)
      (clean-up))))
