;;; -*- Mode: LISP; Package: unify; Syntax: Common-lisp; -*-
;;;
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   unify.cl
;;; Short Desc: unification algorithm for PAIL
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   4.11.92 MR
;;; Author:     MR
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA)
;;;
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;;
;;; Modification history
;;;


(in-package :unify)

(defconstant fail 'fail)

(defparameter *occurs-check* nil)

;(defmacro is-int-var (x) `((isvar ,x)))

(defun is-int-var (x) (isvar x))

(defun isvar (x)
  (and (symbolp x)
       (eq (aref (symbol-name x) 0) #\?)))

(defun has-var (exp)
  (cond ((atom exp) (isvar exp))
	((consp exp) (or (has-var (car exp))
			 (has-var (rest exp))))
	(t (error "has-var: unknown thing: ~s" exp))))

;;; unify <term X term X environment> => 'fail if terms will not unify
;;;                                   => extended environment if they do


(defun unify (x y env)
  (catch 'failtag ($unify x y env)))
  
  
(defun $unify (x y env)
  (cond ((eq x y) env)
        ((isvar x)
	 (cond ((assoc x env)
		($unify (lookup x env) y env))
               (t (push (cons x y) env))))
	((isvar y)
	 ($unify y x env))
	((and (consp x) (consp y))
          ($unify (car x)
		  (car y)
		  ($unify (cdr x)(cdr y) env)))
        (t (throw 'failtag fail))))

	
(defun eq-sym ( x y)
  (and (member  x '(= ->))
       (member  y '(= ->))))

;;------------------------------------------------------
;; lookup      : VAR x ALIST ---> {'unbound} U VAR U VAL
;; Behaviour   : looks up value of VAR in ENV
;; returns the VAR itself if VAR not in environment

;; Example     : (lookup 'x '(( x . y)(y . 8)) = 8
;;

(defun lookup (var alist)
  (let ((val (assoc var alist)))
    (cond (val
           (setq val (cdr val))
           (cond
            ((isvar val)
             (lookup val alist))
            (t val)))
	   (t var))))


;;------------------------------------------------------
;; apply-sub   : S-EXPR x ALIST ---> S-EXPR
;; Behavior    : Applies the substitution 'alist' to 'exp'
;; Example     : (apply-sub '(p (f x)) '( ( x . 8))) = (p (f 8)) 

(defun apply-sub (exp alist)
  (cond
    ((isvar exp)(lookup exp alist))
    ((atom exp) exp)
    (t (cons (apply-sub (car exp) alist)
             (apply-sub (cdr exp) alist)))))
  


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================

