;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   planning-ex1.cl
;;; Short Desc: first planning demo
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   24.1.92 DTA
;;; Author:     DTA, after TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :planning)

(defun dialog-1 (text-disp table-disp problem-disp)
  (let (node top graph
	answer
	)
    (setf *animate* t)

    


    (format-display problem-disp " Initial State:")
    (loop for assertion in (assertions *a-b-c*)
	do (format-display problem-disp "   ~a" assertion))
    (format-display problem-disp (format nil " Operators:~%~a~%"  (dump-editable *blocks-world-ops*)))
    (format-display problem-disp " Final State:~%~a~%" (assertions *final*))

    
    (format-display-fill text-disp "Specification of a planning problem.
                                    The initial and final states are shown,
                                    as well as the operators which are
                                    available in the domain.")
    (when (wait)
      (use-planner strips::*strips-planner*)
      (use-ops *blocks-world-ops*)
      (multiple-value-bind (plan planning-tree) (b-test0)
	(draw-tree planning-tree )
	(setf answer plan)
	)
      (init-movie-window "blocks"
		       (assertions *a-b-c*))
      (activate-display *movie-window*)
      (format-display text-disp " Use STRIPS to solve the problem.")
      (format-display text-disp "~& In the Search Tree window is a graph of")
      (format-display text-disp "~& all the intermediate states that STRIPS")
      (format-display text-disp "~& went through to solve the problem. ")      
      
      (when (wait)
	(format-display text-disp " The solution to the problem found by")
	(format-display text-disp "~& STRIPS is shown symbolically in the Node")
	(format-display text-disp "~& Info window, and then is animated in the")
	(format-display text-disp "~& Blocks World window.  ")
	(setf *current-node* node)
	(setf graph (when (planner-graph-fn *current-planner*)
		      (funcall (planner-graph-fn *current-planner*)
			       answer *node-info-window* )))
	(setf top (loop for goal in (assertions *a-b-c*)
		      when (equal (string-upcase (symbol-name (car goal))) "ON") collect goal))
	(setf (start-state *movie-window*) top)
	(setf (init-plan *movie-window*) '((put dump::a dump::support-table)
					   (put dump::b dump::support-table)
					   (put dump::c dump::support-table)))
	(animate-plan *world* top
		      (reverse (strips::plan-steps-taken-stack answer))
		      *movie-window*)
	
	
	(when (wait)
	  
	  (format-display text-disp "~& STRIPS had no problems with this simple")
	  (format-display text-disp "~& task.  ")
	  (format-display text-disp "~& End of demo.")
	  ))))) 


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
