;;; -*- Mode:Lisp; Package:common-lisp-user; Syntax:Common-Lisp; Base:10;-*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   pail-load
;;; Short Desc: building and/or loading the portable ai lab 
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   31.5.91
;;; Author:     tw sk tr pc
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; ------------------------------------------------------------------------
;;; Change History: 
;;; ========================================================================
;;;
;;;
;;; ========================================================================
;;; DESCRIPTION
;;; ========================================================================
;;;
;;; This file builds the portable AI lab environment
;;; In this file only you have to edit for local sytem adaptations.
;;; Each user may edit his/her own pail-init.cl, that is found in the
;;; home directory.



;;; If you are using Common Lisp inside Emacs, you need a socket
;;; listener daemon to communicate with the editor.
(cond
 ((find "+ipc" (system:command-line-arguments) :test #'string=)
  (require :ipc)
  (require :emacs)
  (funcall (find-symbol (symbol-name :start-lisp-listener-daemon)
                        (find-package :ipc)))))

;;; To conform with the Common LISP standard case mode:
;;; do not change this.
;(set-case-mode :case-insensitive-upper)

;;; COMMON WINDOWS is designed to run with ICCCM-complaint window
;;; managers.  If you are using uwm as window manager, you should set
;;; the value of this variable to  nil.
(setq cw::*icccm-compliant-p* t)

;;; To keep common windows from adding a title-bar to the window. most
;;; window managers have their own titles.
(setq cw::*window-manager-titles-p* t)
(setq cw::*window-manager-notification-broken-p* t)

;;; Some window servers cause the problem, that a window is not
;;; completely ready even though the function that creates the window
;;; returns.  This causes sometimes missing buttons or the error
;;; undefined generic function font called with arguments nil.  A
;;; useful value for this might be between 0.5 and 1.3
;;; one way is also to use the fast MIT X11 server instead of the
;;; memory-intensive NeWS server.
(setq user::*server-delay* 0)

(setf excl::*redefinition-warnings* nil)

;;; ------------------------------------------------------------------------
;;; Define packages
;;; ------------------------------------------------------------------------

(defpackage :unify
	    (:nicknames mgu)
	    (:use lisp)
	    (:export unify fail apply-sub compose mgu1 is-int-var has-var))
;;(print (find-all-symbols :unify))

;;; This package holds loop macros (only used by database)
(defpackage :loop (:use :common-lisp))

;;; This package holds the permanent object stuff
(defpackage :database (:use :common-lisp :loop))

;;; package to hold all dumped symbols.  Symbols go back to home
;;; package when re-loaded.  
(defpackage :dump)

;;; This package holds the graphic stuff
(defpackage :gin        (:use :common-lisp) (:nicknames :gi))
(defpackage :cw-examples (:use :common-lisp :cw) (:nicknames :cwex))

;;; This package collects all pail internal stuff
(defpackage :pail-lib   (:use :common-lisp :gin :loop))


;;; Now define all packages for the modules.  Each definition of a
;;; package must be reflected in the :pail package definition below. 
(defpackage :id3        (:use :common-lisp :pail-lib :gin))
 
;;; Hopfield package
(defpackage :hopfield        (:use :common-lisp :pail-lib :gin) (:nicknames :hop))


;;; Package for AQ15 
(defpackage :aq15        (:use :common-lisp :pail-lib :gin))

;;;  Package for EBG
(defpackage :ebg        (:use :common-lisp :pail-lib :gin :unify))


;;;  Package for General Trivial Rule Engine
(defpackage :gtre       (:use :common-lisp :gin))
(defpackage :gtre-example       (:use :common-lisp :gtre))

;;;  Package for genetic algorithms
(defpackage :ga         (:use :common-lisp :pail-lib :gin :cwex))

;;;  Package for Repertory Grids
(defpackage :rpg        (:use :common-lisp :pail-lib :gin))

;;;  Package for ATP
(defpackage :atp        (:use :common-lisp :pail-lib :gin)
	    (:export "EN"))

;;;  Package for ATN
(defpackage :atn        (:use :common-lisp :pail-lib :gin))

;;;  Package for CHART PARSING
(defpackage :cky        (:use :common-lisp :pail-lib :gin))

;;;  Package for Neural Networks
(defpackage :np        (:use :common-lisp :pail-lib :gin))
(defpackage :nn        (:use :common-lisp :pail-lib :gin))

;;;  Packages for PLANNING


;(print (find-all-symbols :unify))

;;(print (find-all-symbols :unify))

(defpackage :search
	    (:use lisp)
	    (:export *depth-first-search*
		     *best-first-search*
		     *breadth-first-search*
		     quick-print-tree
		     search-tree-n-traverse
		     search-tree-children
		     search-tree-parent
		     search-tree-rank
		     search-tree-node
		     search-tree-x
		     search-tree-y))

(defpackage planning
	    (:shadowing-import-from unify :unify)
	    (:use common-lisp unify search pail-lib gin)
	    (:export  dup-op

		     solve *current-planner*
		     use-planner use-searcher make-planner
		     *known-rank-fns*
		     )
	    )

(defpackage snlp
	    (:use lisp planning)
	    (:export *tweak-planner*))

(defpackage strips
	    (:use lisp unify planning)
	    (:export *strips-planner* norank))

;;;  Package for rules
(defpackage :rules      (:use :common-lisp :pail-lib :gin :planning 
			      :unify :search :strips))


;;; This package combines all modules
(defpackage :pail       (:use :common-lisp :pail-lib :gin :id3 :aq15 :rules
			      :ebg :ga :rpg :planning :np :atn :hopfield))


;;; ------------------------------------------------------------------------
;;; SETUP PARAMETERS
;;; ------------------------------------------------------------------------

(setf excl::*redefinition-warnings* nil)

(in-package :pail-lib)

(eval-when (load eval compile)
  (export  '(*faslfile-type*
	     *gin-p*
	     *runtime*
	     *pail-path*
	     *sourcefile-type*
	     *verbose-default*
	     )))


;;; ***************************** INSTALLATION *****************************
;;; This is site specific. PLEASE EDIT.
;;;
(defparameter *pail-path*
    (make-pathname :directory "/home/pail"));DO NOT EDIT THIS COMMENT


;;; ************************************************************************


;;; System parameters
;;;
(defvar *gin-p* t "If T use graphical else ascii interface")
(defvar *runtime* nil "If T it is a runtime version")

(setf cw::*window-manager-titles-p* t) ;; since twm supplies its own titles

;;; ************************* END OF VARIABLE PART *************************


(defparameter *sourcefile-type* 
  "cl" 
  "file type for lisp source code")



(defparameter *faslfile-type* 
  "fasl" 
  "file type for lisp compiled code")



;;; ------------------------------------------------------------------------
;;; LOAD THE MODULES...
;;; ------------------------------------------------------------------------



;;; Load the initial library for loading...
;;; ensure-loaded is not yet available, so we do it by hand!
(load (merge-pathnames
       (make-pathname :directory "pail-lib" :name "pail-lib")
       *pail-path*))

;;; help-button has to be loaded before pail-dialog is compiled, since
;;; pail-dialog refers to a class that is defined here.  If you load
;;; this from pail-dialog (the obvious thing to do), it does not get
;;; loaded until pail-dialog is done compiling, and the (implicitly)
;;; defined symolb help-button conflict with the correct, explicit
;;; definition in help-button.cl.  Such are the intricacies of
;;; packages.


(defparameter *pail-lib-dir* (add-subdir *pail-path* "pail-lib"))

;;; GRAPHICS - Load the implementation specific graphical interface layer
(if *gin-p*
    (progn
      (load  (add-path 
	     "acl-gin"  *pail-lib-dir*))
	(setf gin::*default-display-border* 0)	      
;      (unless (cw::common-windows-initialized-p)
;	(gin::init-window-system))

      (setf gin::*use-new-version* t)
      (ensure-loaded (add-path "pailgc" *pail-lib-dir*))
      (ensure-loaded (add-path "help-button" *pail-lib-dir*))
;      (ensure-loaded (add-path "loop" *pail-lib-dir*))
      (ensure-loaded (add-path "save-object" *pail-lib-dir*))
      (ensure-loaded (add-path "pool" *pail-lib-dir*))
      (ensure-loaded (add-path "poolfile" *pail-lib-dir*))
      (ensure-loaded (add-path "pail-dialog" 
			       *pail-lib-dir*))
      ))







(format *standard-output* "Initial routines loaded.~%")


;;; All local parameters defined here.  These can be overridden in the
;;; user's pail-init.cl.

;;; All pool activity goes on in the current working directory.

(excl:chdir (add-subdir *pail-path* "pool"))

;;; An editor is called by the Edit option of pool buttons.  This
;;; command will have a filename concatenated at the end of it.  I
;;; recommend a screen editor, like X emacs.

(defparameter *edit-command* "emacs -geometry 60x35+250+25 ")


;;; For printing to a hardcopy  device.  This command will have a
;;; filename concatenated at the end of it. 

(defparameter *print-command* "lpr ")

;;; Whether verbose mode should be the default or not.  The default
;;; value for this is t (i.e., all modules begin in verbose mode).

(defparameter *verbose-default* t)

;;; Any of these can be overridden by the pail-init.cl in the user's
;;; home directory. 

(when (directory "~/.pail-init.cl") (load "~/.pail-init.cl") )


(in-package :pail-lib)
(start-pail-dialog)


;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================



