;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   spratt.cl
;;; Short Desc: class definition for use with the Spratt code
;;; Version:    0.1
;;; Status:     experimental
;;; Last Mod:   18.11.91 dta
;;; Author:     Dean Allemang
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;; 
;;; Supports a type for instances amenable as input to the Spratt
;;; algorithms.  Better would be to modify the Spratt algorithms to
;;; work directly with the tables the the current ID3 uses. 



(in-package :pail-lib)

(export '(spratt-table instances change-type update-instances))

(defclass spratt-table (table)
  ((instances  :initarg :instances
	       :initform nil
	       :accessor instances
	       :type list)))


(defmethod update-instances  ((data table))
  (setf (instances data) (read-instances-from-table data)))

(defmethod read-instances-from-table ((input-table table) &optional
				  (decision-location "l")
				  (skip-locations nil))
  (let ((record-format (list "l" (attributes input-table)))
	)
    (loop for row from 0 to (1- (length (rows input-table)))
     collect (loop for attribute in (reverse (attributes input-table))
	      collect (list attribute (get-nth-value  attribute row input-table))))))


(defmethod change-type ((a table) (b spratt-table))
  (make-instance 'spratt-table
		 :instances (read-instances-from-table a)
		 :attributes (attributes a)
		 :rows (rows a)
		 ))

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================




