;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-dialog.cl
;;; Short Desc: Functions to push buttons by software, 
;;;             used to implement demos by modules :  ATN ATP CSP CKY, 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.2.93 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 
;

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail-lib)

(eval-when (compile load eval)
  (export '(my-software-push)))
	    
(defmethod  my-software-push ((b radio-button) (display display))
  (setf (status b) (not (status b)))
  (if (status b)
      (progn  
	(draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
			       (- (width b) 3) (- (height b) 3))
	(clear-button (inhibit-buttons b))
	(disable-button (inhibit-buttons b)))
    (progn (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
				  (- (width b) 3) (- (height b) 3) :color gi::white)
	   (enable-button (inhibit-buttons b))))
  (funcall (action b)))

(defmethod my-software-push ((b push-button) d)
  (gin::a-software-push b))




;;====================================================================
(in-package :gin)
(defmethod a-software-push ((b push-button))
  (when (and (equal (status b) 0) (status (region b)))
    (cw:deactivate (region b))
    (setf (status b) 1)
    (if (colorp)
	(progn (draw-filled-rectangle (display b) (+ 3 (left b)) (+ 3 (bottom b))
				      (- (width b) 5) (- (height b) 5)
				      :color black)
	       (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
	       (if (slot-boundp b 'bitmap)
		   (copy-mask (bitmap b) 0 0 (display b)
			      (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
			      (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
			      (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
											     :width (- (width b) 5) :height (- (height b) 5))))
	       (if (label b)
		   (let ((cf (font (display b)))
			 (c-label (clip-label b)))
		     (setf (font (display b)) (font b))
		     (write-display (display b) c-label
				    (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				    (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
		     (setf (font (display b)) cf)))
	       (setf (cw:window-stream-foreground-color (pattern (display b))) black))
      (progn (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-ior
			(cw:make-region :left (+ 1 (left b))       :bottom (+ 1 (bottom b))
					:width (- (width b) 1) :height (- (height b) 1)) t)
	     ))
    (cw:bitblt (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b))
	       (window (display b)) (+ 1 (left b)) (+ 1 (bottom b)))
    (disable-button (inhibit-buttons b))
    (funcall (action b))
    ))
