;;; -*- Mode:Lisp; Package:pail-lib; Syntax:Common-Lisp; Base:10;-*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   poolfile.cl
;;; Short Desc: Interfaces the pool with files
;;; Version:    0.1
;;; Status:     experimental
;;; Last Mod:   3.3.92
;;; Author:     dta
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; ------------------------------------------------------------------------
;;; Change History: 
;;; ========================================================================
;;;
;;;
;;; ========================================================================
;;; DESCRIPTION
;;; ========================================================================
;;;
;;; 
;;; 


(in-package :pail-lib)

;(import '(database:save-object))
(export '(select-loaded-file add-to-file access-pail-files
	  find-pail-files load-file-no-questions file-button w-directory))
(defvar *loaded-files* nil)

(excl:chdir (add-subdir *pail-path* "pool"))

(defparameter *temp-pool*  (make-instance 'pail-lib::pool))

(defclass file-button (pop-up-button)
	  ((w-directory :initarg :w-directory
		      :accessor w-directory
		      :initform 
		       (or 
			 pail-lib::*user-dir*
			 (add-path "pool" *pail-path*)))
			   
	   (label :accessor label
		  :initform "Files")))

(defmethod initialize-instance :after ((fb file-button) &rest junk)
  (setf (menu fb)
    (make-instance 'menu
      :items `(("Get file" (lambda () (access-pail-files
				       (find-pail-files (w-directory ',fb))
				       (namestring
					(truename
					 (make-pathname
					  :directory (namestring (w-directory ',fb)))))))
			   "Select among files in current directory one to load")
	       ("Maintain file" (lambda ()
				  (let ((file (select-loaded-file)))
				   (cond
				    (file
				     (setq file (add-to-file file pail-lib::*pail-pool*))
				     (setf (filename file)
				      (merge-pathnames
				       (filename file)
				       (make-pathname :directory (namestring (w-directory ',fb)))))))))
				"Add items from pool to a file")
	       ("Maintain pool" (lambda () (maintain-pool  pail-lib::*pail-pool*))
				"Allows items to be deleted from the pool")
	       ("Change Directory"
		(lambda () (let ((answer (ask (format nil "Enter directory (formerly ~a): "
						      (namestring (truename (w-directory ',fb)))))))
			     (if (and (not (equal answer ""))
			              (probe-file answer)) ; mike 2.8.93
				 (setf (w-directory ',fb) 
				   answer)))))))))



(defclass poolfile ()
	  ((filename :initarg :filename
		     :accessor filename
		     :initform (ask "What is the name of the new file? ")
		     :type string)
	   (contents :initarg :contents
		     :accessor contents
		     :initform nil
		     :type list)	; a list of filentries
	   (real-contents :initarg :real-contents
			  :initform nil
			  :accessor real-contents
			  :type list)))	; the actual items themselves.
					; This is saved in the main
					; file, but not the header


(defclass filentry ()
	  ((poolname :initarg :poolname
		     :accessor poolname
		     :type string)
	   (classname :initarg :classname
		      :accessor classname
		      :type string)	; the name of the class of
					; this entry.  If any entry in
					; a file does not have its
					; class defined, then it won't
					; be loaded.
	   ))


(defparameter *editable-things* nil)

(defmethod save-file ((f poolfile) (pool pool))
  (let* ((items (real-contents f))
	 (*package* (find-package :dump))
	 (fname (namestring (filename f))))
	
	
    (setq *print-right-margin* 25)
    (setq *print-pretty* t)
    (setq *print-miser-width* 10)


    (setf *editable-things* nil)
    (setf (filename f) "")
    (database:save-object f fname :package :dump)
    (setf (real-contents f) nil)
    (database:save-object f (concatenate 'string fname ".hd")
			  :package :dump
			  :print-pretty t)
    (setf (real-contents f) items)
    (setf (filename f) fname)
    (handler-case
      (with-open-file (stream (concatenate 'string fname ".pail")
  		       :direction :output
		       :if-exists :supersede
		       :if-does-not-exist :create)
        (format stream "~%(~%")
        (loop for thing in *editable-things* do
	  (format stream "~%(~s " (car thing))
	  (format stream "~s~%" (cadr thing))
		(pprint (read-from-string (caddr thing)) stream)
	  (format stream ")~%"))
        (format stream "~%)~%")
       )
      (file-error () t)
     )
    ))
      



(defun select-loaded-file ()
  (accept-items (make-instance 'menu
		  :items (cons '("New file" NewFile)
			       (mapcar #'(lambda (item) `(,(format nil "~a" (filename item)) ,item)) *loaded-files*))
		  :query "Please select file to which items will be added.")))

		
(defmethod add-to-file (f (pool pool))
  (cond ((equal 'NewFile f) (let ((newfile (make-instance 'poolfile)))
				  (add-to-file newfile pool)
				  (push newfile *loaded-files*)
				  newfile))
    ((null f) nil)
    (t (error "Invalid argument ~a" f))))






(defmethod add-to-file ((f poolfile) (pool pool))
  (cond ((not (known-items *pail-pool*)) (display-error "No items are in the pool"))
	(t (let* ((disp (make-instance 'display
			  :left (truncate (width *root-window*) 5)
			  :bottom (truncate (height *root-window*) 4)
			  :height (+ (font-character-height *default-font*) 155)
			  :title (format nil "Items for ~a" (filename f))))
		  (abort-button (make-instance 'push-button :label "Cancel" :width 90))
		  (done-button (make-instance 'push-button :label "Save" :width 90))
		  (selection (make-instance 'select-button
			       :label "Available in the pool"
			       :height 150
			       :items (mapcar #'name-part (known-items *pail-pool*))
			       :action #'(lambda nil nil)
			       )))
	     (set-button abort-button disp :left 260 :bottom 5
			 :action `(lambda nil (close-display ,disp)))
	     (set-button done-button disp
			 :left 260
			 :bottom (+ (height abort-button) 10)
			 :action #'(lambda nil
				     (setf (real-contents f) nil)
				     (setf (contents f) nil)
				     (do ((i (items selection) (cdr i))
					  (pooli (known-items *pail-pool*) (cdr pooli)))
					 ((null i) nil)
				       (when (status (car i))
					 (push (make-instance 'filentry
						 :poolname (name-part (car pooli))
						 :classname (format nil "~a" (class-name
									      (class-of
									       (start-object (car pooli)))))
						 )
					       (contents f))
					 (push (car pooli) (real-contents f))))
				     (write-display disp "Saving . . ." 250 70)
				     (save-file f pool)
				     (close-display disp)))
				      

	     (do ((i (items selection) (cdr i))
		  (pooli (known-items *pail-pool*) (cdr pooli)))
		 ((null i) nil)
	       (if (member (car pooli) (real-contents f)) 
		   (setf (status (car i)) t)
		 ))
	     (set-button selection disp)
	     f    
	     ))
	))


(defmethod load-file ((file poolfile))
  (let ((bottom 4)
	(content (make-instance 'display
		   :title (format nil "Contents of ~a"
				  (filename file))
		   :width (apply #'max (cons 1 (mapcar
						#'(lambda (entry)
						    (+ 10
						       (font-string-width *default-font* (write-to-string (classname entry)))
						       (font-string-width *default-font* (write-to-string (poolname entry)))))
						(contents file))))
		   :height (* (length (contents file)) (+ 5 (font-character-height  *default-font*)))
		   :left (truncate (width *root-window*) 5)
		   :bottom (truncate (height *root-window*) 2)))
	)
    (dolist (item (contents file)) (write-display content
					  (concatenate 'string
					    (poolname  item) " - "
					    (classname item))
					  0 bottom)
      (setq bottom (+ bottom (font-character-height  *default-font*) 5)))
   (let ((all nil))
     (dolist (item (contents file))
       (let ((predefined (read-from-string (classname item))))
	 (when (not (find-class (intern
				 predefined :pail) nil))
	   (push (classname item) all)
	   (unintern (intern
		      predefined :pail) :pail)
	   )
	 ))
     (if (not (equalp (length all) 0))
	 (display-error (format nil "Class `~a' not found.  Cannot load."
				(car all)))
       (when (and (equal :yes (y-or-n-dialog (format nil "Load ~a now?" (filename file)) :cancel-button nil))
		  (drop-unwanted-dups file  *pail-pool*))
	 
	 (let ((*package* (find-package :dump)))
	   (with-open-file (stream (concatenate 'string (filename file) ".pail"))
	     (setf *editable-things*
	       (read stream)))
					;	   (print *editable-things*)
	   )
	 (load (filename file))
			  
	 (setf (known-items *pail-pool*)
	   (append (known-items *pail-pool*) 
	           (real-contents database::*db-input*)))
	 (setf (filename database::*db-input*) (filename file))
	 (push database::*db-input* *loaded-files*)
	 )))
     (close-display content)
     )
  )



(defun load-file-no-questions (pathname &optional (pool *pail-pool*))
  (let ((file nil))
    (load pathname)
    (setf file database::*db-input*)
    (let ((all nil))
      (dolist (item (contents file))
	(let ((predefined (read-from-string (classname item) :pail)))
	  (when (not (find-class (intern
				  predefined :pail) nil))
	    (push predefined all))
	  (if (not predefined) (unintern (intern
					  predefined :pail) :pail))
	  ))
      (if (not (equalp (length all) 0))
	  (display-error (format nil "Class `~a' not found.  Cannot load."
				 (car all)))
	(progn
;	  (drop-unwanted-dups file  pool)
	 
	  (let ((*package* (find-package :dump)))
	    (with-open-file (stream (merge-pathnames pathname "*.pail"))
	      (setf *editable-things*
		(read stream)))
;	    (print *editable-things*)
	    )
	  (load pathname)
			  
	  (setf (known-items pool)
	        (append (known-items pool) 
		        (real-contents database::*db-input*)))
	  (setf (filename database::*db-input*) (format nil "~a" pathname))
	  (push database::*db-input* *loaded-files*)
	  )))
    
    )
  )
  


(defun get-file-object (name)
  (loop for entry in *editable-things*
      when (equal (cadr entry) name)
      do (return (let
		     ((obj (make-instance (car entry))))
		   (read-instance obj (intern-all (caddr entry) :dump) name)))))
    

	
(defmethod drop-unwanted-dups ((file poolfile) (pool pool))
  (let ((match nil)
	(good nil)
	(answer nil))
    (dolist (f *loaded-files* good)
      (if (equalp (filename f) (filename file))
	  (setf match f)
	(push f good)))
    (cond  ((and match
		 (eq :yes (setf answer (y-or-n-dialog
					(format nil
						"File ~a has already been loaded. ~%Remove duplicates currently in the pool?"
						(filename file))))))
	    (setf (known-items pool)
	      (let ((good nil))
		(dolist (item (known-items pool) good)
		  (when (not (let ((found nil)) (dolist (entry (contents file) found)
						  (when (equalp (poolname entry) (name-part item))
						    (setf found t)))))
		    (push item good)))))
	    (setf *loaded-files* good)
	    t)
	   ((eq :canceled answer) nil)
	   (t (setf *loaded-files* good)
	      t))))
					 
      



(defun access-pail-files (files &optional
				(directory (excl:current-directory)))
  (if files
    (let (selection (items nil))
      (dolist (filename files)
	(push `(,(pathname-name filename)
		,filename)
	      items))
      (setq selection
	(accept-items
	 (make-instance 'menu
	   :items items
	   :query (format nil "PAIL files available in ~a" directory)
	   ))
	)
      (when selection

	(load (concatenate 'string selection ".hd"))
	(setf (filename database::*db-input*) selection)
	(load-file database::*db-input*))
      )
    (display-error (format nil "No PAIL files found in ~a." directory))))






(defun find-pail-files (directory)
  (if (pathnamep directory)
      (find-pail-files (namestring directory))
    (loop for filename in (directory (make-pathname
				      :directory directory
				      :name :wild
				      :type "hd"))
	collect 
	  (subseq (namestring filename) 0 (- (length (namestring filename)) 3))
      ))
  )

(defmethod edit-object ((entry pool-item) target)
  (let* ((newitem (if (equal "no name" (name-part entry))
		      (make-instance
		             'pool-item
			     :start-object target)
		      entry))
	 (newfile (make-instance 'poolfile
		   :filename "TEMP"
		   :contents (list (make-instance 'filentry
				     :poolname (name-part newitem)
				     :classname (format nil "~a"
							(class-name (class-of  target)))
				     ))
		   :real-contents (list newitem)))
	 (good nil)
	)
    
    (save-file newfile *temp-pool*)
    (setq *editable-things* nil)
    (loop until good do (progn
			  (user::run-shell-command
			   (concatenate 'string *edit-command* "TEMP.pail")
			   :wait t)
			  (setf good t)
			  (handler-case (with-open-file (stream "TEMP.pail")
					  (read stream))
					  
			    (error (condition)
			            (progn
					(display-error
					  (format nil "~a"  condition))
					(setq good nil))))
			  ))
    (setf (known-items *temp-pool*) nil)
    (handler-case
      (load-file-no-questions "TEMP" *temp-pool*)
     (error () (documentation-print "badly formed new item -- check syntax")))
      (make-instance 'pool-item
	:start-object (pool-find-object *temp-pool* (name-part newitem))
	:name-part (name-part newitem)
	:from-button (from-button entry))

    
    ))

  
  


;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================
