;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   operators.cl
;;; Short Desc: definition of data types for both planners
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   14.1.92 DTA
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;;; Operators
(in-package :pail-lib)
(export '(op opname op-p op-set op-list dump-editable use-ops bc-set bc-rule 
		      filter subgoals add-list del-list not-same *ops*))

(defvar *ops* nil
  "List of available operators in current domain.")




;;; Some worlds have graphic support (e.g., blocks world).  This means
;;; that someone has to tell the graphics system what type of object
;;; each of these things is.  Only the user who is setting up the
;;; problem knows this, so this is specified with (use-world), and is
;;; stored in this global variable.
(defvar *world* nil
  "The current world in which the planner is working")

(defclass op ()
	    
  ((opname     :initarg :opname
	       :initform nil
	       :accessor opname
	       :type string)
   (filter     :initarg :filter
	       :initform nil
	       :accessor filter
	       :type list)
   (subgoals   :initarg :subgoals
	       :initform nil
	       :accessor subgoals
	       :type list)
   (add-list   :initarg :add-list
	       :initform nil
	       :accessor add-list
	       :type list)
   (del-list   :initarg :del-list
	       :initform nil
	       :accessor del-list
	       :type list)
   (not-same   :initarg :not-same
	       :initform nil
	       :accessor not-same
	       :type list)))

(defclass op-set ()   ; A set of operators (ops)
	  ((opset-name :initarg :opset-name
		    :initform "opset"
		    :accessor opset-name
		    :type string)
	   (op-list :initarg :op-list
		    :initform nil
		    :accessor op-list
		    :type list))
	   (:documentation "A set of planning operators"))



(defmethod op-p ((alleged-op op))
  (declare (ignore alleged-op))
  t)

(defmethod op-p (alleged-op)
  (declare (ignore alleged-op))
  nil)

(defmethod change-type ((a op-set) (b op-set)) a)

(defmethod pail-lib::dump-editable ((oo op)   )
  (concatenate 'string
			(format nil "~%")
			(format nil "(~a" (opname oo))
			(format nil "~%")
			(format nil "    (FILTER   ~a)" (filter oo))
			(format nil "~%")
			(format nil "    (SUBGOALS ~a)" (subgoals oo))
			(format nil "~%")
			(format nil "    (ADD ~a)" (add-list oo))
			(format nil "~%")
			(format nil "    (DELETE ~a)" (del-list oo))
			(format nil "~%")
			(format nil "    (NOT-SAME ~a))" (not-same oo))))

#| (defmethod dump-editable ((opset op-set))
  (let ((sofar (format nil "~%(~a~% OP-LIST (" (opset-name opset))))
    (loop for op in (op-list opset) do
	(concatenate 'string sofar (dump-editable op)))
    (concatenate 'string sofar "))"))) |#


(defmethod dump-editable ((op-set op-set))
  (eval `(concatenate 'string "(" ,@(loop for op in (op-list op-set)
   collect (dump-editable op)) ")")
  ))
    


(defmethod pail-lib::change-type ((oo op) (pp op)) oo)

(defmethod read-instance ((oo op) desc name)
  (progn 
    (setf (opname oo) (car desc))
    (setf (filter oo) (cadr (nth 1 desc)))
    (setf (subgoals oo) (cadr (nth 2 desc)))
    (setf (add-list oo) (cadr (nth 3 desc)))
    (setf (del-list oo) (cadr (nth 4 desc)))
    (setf (not-same oo) (cadr (nth 5 desc)))
    oo))

(defmethod read-instance ((op-set op-set) desc name)
  (progn
    (setf (opset-name op-set) name)
    (setf (op-list op-set)
      (loop for op-desc in desc collect (let ((op (make-instance 'op)))
					  (read-instance op op-desc name))))
    
    op-set))

(defmethod print-function ((o op) stream print-depth)
  (format stream "<~a>" (opname op)))

(defmethod print-object ((o op) stream )
  (format stream "<~a>" (opname o)))

(defmethod use-ops ((ops op-set))
  (setf *ops* ops)
  (when (eq planning:*current-planner* snlp:*tweak-planner*)
    (setf snlp::*templates*		; REALLY need to integrate the two
      (nreverse
       (mapcar #'(lambda (op)
		   (list (snlp::make-snlp-step
			  :action (opname op)
			  :precond (append (filter op) (subgoals op))
			  :add (add-list op)
			  :dele (del-list op))
			 (mapcar #'(lambda (ne)
				     `(snlp::not (,(car ne) ,(cdr ne))))
				 (not-same op))))
	       (op-list ops)))))
  (length (op-list *ops*)))



(defclass bc-rule (op) 
	  ((opname     :initarg :opname
	       :initform 'bc-rule
	       :accessor opname
	       :type string))
	  )

(defclass bc-set (op-set) ()
	  )

(defmethod pail-lib::dump-editable ((rule bc-rule)   )
  (concatenate 'string
			(format nil "~%")
			(format nil "(~a" (opname rule))
			(format nil "~%")
			(format nil "    (IF ~a)" (subgoals rule))
			(format nil "~%")
			(format nil "    (THEN ~a))" (add-list rule))
			

))



(defmethod read-instance ((rule bc-rule) desc name)
  (progn 
    (setf (opname rule) (car desc))
    (setf (subgoals rule) (cadr (nth 1 desc)))
    (setf (add-list rule) (cadr (nth 2 desc)))
    rule))

(defmethod read-instance ((bc-set bc-set) desc name)
  (progn
    (setf (opset-name bc-set) name)
    (setf (op-list bc-set)
      (loop for rule-desc in desc collect (let ((rule (make-instance 'bc-rule)))
					  (read-instance rule rule-desc name))))
    
    bc-set))


(defmethod change-type ((a op-set) (b bc-set))
  (make-instance 'bc-set
    :opset-name (opset-name a)
    :op-list (loop for op in (op-list a) collect
		  (make-instance 'bc-rule
		    :opname (opname op)
		    :subgoals (subgoals op)
		    :add-list (add-list op)))))

		    

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
