;;; ecrit par Rolf Grau, 29.03.93
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :gtre)

(export '(my-button))

(defvar *original-screen-width* 1300)
(defvar *original-screen-height* 950)
(defvar *loader-buttons-width*)
(defvar *file-loaded* nil)
(defparameter *filename* nil)
(defvar *last-file* nil)
(defvar *value-list* '("attribute"))

(defclass my-button (value-button)
	  ((label :accessor label
		  :initform "Files")
	   (button-type :initarg :button-type
			:accessor button-type
			:initform nil)
	   (after-get :initarg :after-get
		      :initform #'(lambda (item) nil)
		      :type function
		      :accessor after-get)
	   (show-function :initarg :show-function
			  :accessor show-function
			  :initform #'(lambda (item)
					(documentation-print item)))
	   (w-directory :initarg :w-directory
			:accessor w-directory
			:initform pail::*pail-path*)
	   ))


(defmethod initialize-instance :after ((cl-button my-button) &rest junk)
  (declare (ignore junk))
  (case (button-type cl-button)
    (rules 
     (setf (menu cl-button) 
       (make-instance 'menu
	 :items `(("Load"
		   (if (not		; Added by E.S, only the negative case was provided
			(string= (button-value ',cl-button) "no name"))
		       (progn
			 (documentation-print
			  (format nil "Loading ~a ..." *filename*))
			 (if (load
			      (concatenate 'string 
				(namestring pail::*nmjtmspath*)
				*filename*))
			     (progn (setq *file-loaded* t)
				    (setf (button-value ',cl-button)
				      *filename*)
				    (documentation-print
				     "File loaded"))
			   (documentation-print
			    "Loading error")))
		     (choose-load-file ',cl-button))
		   )
		  ("View"
		   (choose-file-dialog *filename*)
		   )
		  ("Edit"
		   (if (not (string= (button-value ',cl-button) "no name"))
		       (progn
			 (user::run-shell-command
			  (concatenate 'string 
			    pail-lib::*edit-command*
			    (namestring pail::*nmjtmspath*) ; Line added by E.S
			    *filename*)
			  :wait t)
			 *filename*)	;necessary because of 'setf value-button :after' method
		     (progn 
		       (setf *filename* 
			 (ask "What is the name of the file you want to create?~%"))
			 (user::run-shell-command
			  (concatenate 'string 
			    pail-lib::*edit-command*
			    (namestring pail::*nmjtmspath*) ; Line added by E.S
			    *filename*)
			  :wait t)
			 *filename*)	;necessary because of 'setf value-button :after' method
		     ))
		  ("Change Directory"
		   (when *filename*
		     (progn (setf (w-directory ',cl-button) 
			      (change-dir (w-directory ',cl-button)))
			    *filename*)	;necessary because of 'setf value-button :after' method
		     ))
		  ("Help"
		   (documentation-print "Sorry, no help available.")))))
     )

    (tms
     (setf (menu cl-button) 
       (make-instance 'menu
	 :items `(("Run"
		   (progn (run-rules)
			  (documentation-print "NMJTMS rules have been run.")
			  (setf (button-value ',cl-button)
			    (ask "Under what name should this item be registered?~%"))
			  ))
		  ("Show"
		   (progn (funcall (show-function ,cl-button))
			  (button-value ',cl-button)
			  ))
		  ("Add assertion"
		   (let* ((answer (ask (format nil "Enter assertion (e.g. (I appetite) USER):~%")))
			  end-position
			  item)
		     (when (not (equal answer ""))
		       (progn (setq end-position (parse-assertion answer))
			      (if end-position
				  (progn 
				    (with-input-from-string (stream (subseq answer 0 (+ 1 end-position)))
				      (setf item
					(pail-lib::intern-all (read stream) :gtre)))
				    (gtre::assert! item 
					     (if (search "GOD" answer :test #'char-equal)
						 'gtre::GOD
					       'gtre::USER)))
				(mp:process-wait  
				 "Invalid assertion" 
				 #'(lambda nil
				     (eq 'Continue 
					 (ack-dialog "Incorrect syntax!"  
						     :title "NMJTMS: Error")))))))
		     (button-value ',cl-button))
		   )
		  ("Retract assertion"
		   (let ((answer (ask (format nil "Enter assertion to retract(e.g. (I appetite)):~%")))
			 item)
		     (when (not (equal answer ""))
		       (progn (if (parse-assertion answer)
				  (progn (with-input-from-string (stream answer)
					   (setf item
					     (pail-lib::intern-all (read stream) :gtre)))
					 (gtre::retract! item 'gtre::USER))
				(mp:process-wait  
				 "Invalid assertion to retract" 
				 #'(lambda nil
				     (eq 'Continue 
					 (ack-dialog "Incorrect syntax!"  
						     :title "NMJTMS: Error")))))))
		     (button-value ',cl-button))
		   )
		  ("Help"
		   (documentation-print "Sorry, no help available")
		   )))))

    (t (print (button-type cl-button)))
    )
    
  (setf (display-function cl-button)
    `(lambda (x) (if (and x (not (stringp x)))
		     (rectify-string (pail-lib::name-part x))
		   (rectify-string x)
		   )))

  (setf (button-value cl-button) "no name")
  )

(defun rectify-string (s) (if (stringp s) s (symbol-name s)))

(defun parse-assertion (assertion)
  (let ((start (search "(" assertion))
	(end (search ")" assertion)))
    (when (and start end) end)))


(defun choose-load-file (cl-button)
  (setq *last-file* *filename*)
  (setq *filename* (choose-file-lo cl-button))
  (if (not (or (string= "Canceled" *filename*) 
	       (string= "Sorry! No example files here" *filename*)))
      (progn
	(documentation-print (format nil "Loading ~a ..." *filename*))
	(if (load (concatenate 'string (namestring (w-directory cl-button)) *filename*))  
	    (progn (setq *file-loaded* t)
		   (setf (button-value cl-button) *filename*)
		   (documentation-print "File loaded"))
	  (progn (documentation-print "Loading error")
		 (setq *filename* *last-file*))))
    (setq *filename* *last-file*))
  )
    
(defmethod choose-file-lo ((cl-button my-button))
  (setq *nmjtms-directory* (w-directory cl-button))
  (setq *loader-buttons-width* (scalew 100))
  (let* ((*default-font* *small-font*)
	 (exit-button (make-instance 'push-button  
		       :font *small-font*   :width *loader-buttons-width* :label "LOAD"))
	 (help-on-loader-button
	  (make-instance 'pail-lib::help-button   
	    :width *loader-buttons-width*
	    :font *small-font* :label "HELP" 
	    :subject "Loading files "
	    :technical (pail-lib::add-path "nmjtms-load-doc.tec" pail::*nmjtmspath*)
	    :general (pail-lib::add-path "nmjtms-load-doc.gen" pail::*nmjtmspath*)))
	 (cancel-button (make-instance 'push-button      
			  :font *small-font* 
			  :width *loader-buttons-width* 
			  :label "CANCEL"))
	 (dir-button (make-instance 'push-button 
		       :font *small-font*   :width *loader-buttons-width* :label "CH-DIR"))
	 )
    
    (setq *canceled* nil)
    (setq *choose-done* nil)
    (setq *fdisp* (make-instance 'display :height  (scaleh 550)
				 :width  (scalew 500)
				 :left (round (* 0.2 (width *root-window*)))
				 :bottom  (round (* 0.1 (height *root-window*)))
				 :title "Select a file, please"))
    (protect-display *fdisp* t) 
    (setq *default-font* *bold-font*)
    (make-directory)
    (setq *default-font* *small-font*)
    (set-button exit-button *fdisp* 
		:left (- (width *fdisp*) (scalew 20) *loader-buttons-width*) 
		:bottom (scaleh 140)
		:action (function(lambda nil
				   (if  (choosen-file *files-button*)
				       (progn
					 (reset-button  exit-button)
					 (deactivate-display *fdisp*)
					 (setf *choose-done* t))
				     (reset-button   exit-button))
				   )))
    (set-button cancel-button *fdisp* 
		:left  (- (width *fdisp*) (scalew 20) *loader-buttons-width*) 
		:bottom (scaleh 200)
		:action (function(lambda nil 
				   (setq *canceled* t)
				   (reset-button cancel-button)
				   (deactivate-display  *fdisp* ) 
				   (setf *choose-done* t))))
    (set-button help-on-loader-button *fdisp* 
		:left  (- (width *fdisp*)  (scalew 20) *loader-buttons-width*) 
		:bottom (scaleh 80))
		  
    (set-button dir-button *fdisp* 
		:left (- (width *fdisp*) (scalew 20) *loader-buttons-width*)
		:bottom (scaleh 260)
		:action `(lambda () 
			   (change-dir (namestring *nmjtms-directory*))
			   (make-directory)
			   (setf (w-directory ',cl-button) 
			     (namestring *nmjtms-directory*))
			   (reset-button ,dir-button)))

    (mp:process-wait "waiting to exit "   #'(lambda nil *choose-done*))
    (if *canceled* "Canceled"
      (choosen-file *files-button*))))
 
(defun  scalew (x ) 
  (round (* x (/ (width *root-window*) *original-screen-width*))))
(defun  scaleh (x )
  (round (* x (/ (height *root-window*) *original-screen-height*))))




    




