;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:GIN; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   select-button.cl
;;; Short Desc: select-object with Displays.
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Mar 1991
;;; Author:     na

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :gin)
(use-package :cwex)

(export '(select-button items item-label add-item))

(defparameter *button-frame-x* 2)
(defparameter *button-frame-y* 1)

(defclass select-button (button)
	  ((scroll-region :accessor scroll-region)
	   (exclusive :initform nil
		      :accessor exclusive
		      :initarg :exclusive)
	   (items   :initform nil
		    :initarg :items
		    :accessor items))
  (:documentation "A BIG button where you can select an item from a list"))

(defclass select-item (push-button)
	  ((parent :accessor parent
		   :initarg :parent))
  (:documentation "An item inside a select-button"))

(defmethod initialize-instance :after ((b select-button) &key action font label exclusive items)
  (if *debug* (format t "~%initialize-instance :after (~A select-button) ~A" b (list action font label exclusive items)))
  (if (not (or (label b) (slot-boundp b 'bitmap)))
      (setf (label b) "Select some items"))
  (if (not (slot-boundp b 'width))
      (setf (width b) (max (+ 8 (if (label b) (font-string-width (font b) (label b)) 0))
			   (if (slot-boundp b 'bitmap)
			       (+ 5 (width (bitmap b)))
			     0))))
  (unless (buttonp (car (items b)))
      (setf (slot-value b 'items) (let ((item-list nil))
			(dolist (i (items b) (nreverse item-list))
			  (push (make-instance 'select-item :label (if (stringp i) i (write-to-string i))
					       :action action
					       :parent b
					       :font (font b)
					       :width (- (width b) 1 (* 2 *button-frame-x*) *static-scroll-bar-width*)) item-list)))))
  (if (not (slot-boundp b 'height))
      (setf (height b) (+ (* (+ *button-frame-y* (height (car (items b))))
			     (length (items b)))
			  (* 2 *button-frame-y*))))
  )


(defmethod set-button ((b select-button) display &key
		       (left 0) (bottom 0))
  (when (and display (status display))
    (if *debug* (format t "~%set-button (~A select-button) ~A ..." b display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (setf bottom (bottom b)) (setf left (left b))
    (setf (display b) display) (setf (status b) t)
    (setf (scroll-region b) (make-display :title nil :borders 1 :font (font b)
					  :width (- (width b) *static-scroll-bar-width* 1)
					  :height (height b)
					  :left (+ *static-scroll-bar-width* left) :bottom bottom
					  :inner-height (max (+ *button-frame-y* (* (+ *button-frame-y* (height (car (items b))))
										    (length (items b))))
							     (height b))
					  :inner-width (max (+ 3 *button-frame-x* (apply #'max (mapcar `(lambda (string)
													  (font-string-width (font ,b) string))
												       (mapcar #'label (items b)))))
							    (width b))
					  :parent display))
    (cw:scroll (window (scroll-region b)) (cw:make-region :bottom (- (inner-height (scroll-region b))
								     (height (scroll-region b)))))
    (make-static-scroll-bar (window (scroll-region b)))
    (let ((lef (+ 1 *button-frame-x*))
	  (bot (- (inner-height (scroll-region b)) *button-frame-y* (height (car (items b)))))
	  (inc (+ *button-frame-y* (height (car (items b)))))
	  (cf (font display)))
      (setf (font display) (font b))
      (write-display display (label b) (+ *button-frame-x* left)
		     (+ bottom (height b) *button-frame-y* (font-baseline (font b))))
      (dolist (l (items b) t)
	(set-button l (scroll-region b) :left lef :bottom bot)
	(decf bot inc))
      (setf (font display) cf))))

(defmethod set-button ((b select-item) display &key
		       left bottom)
  (if *debug* (format t "~%set-button (~A select-item) ~A" b display))
  (unless (stringp (label b))
    (setf (label b) (write-to-string (label b))))
  (write-display display (label b) (+ left 2) (+ bottom (font-baseline (font b)) 
						 (/ (- (height b) (font-character-height (font b))) 2)))
  (setf (left b) left) (setf (bottom b) bottom) (setf (display b) display)
  (when (status b)
    (cw:complement-area (window display)
			(cw:make-region :left left :bottom bottom
					:width (width b)
					:height (height b)))
    (cw:complement-area (pattern display)
			(cw:make-region :left left :bottom bottom
					:width (width b)
					:height (height b))))
  (when (status (parent b))
    (setf (region b) (make-active-region display
					 :left left :bottom bottom
					 :width (width b) :height (height b)
					 :active t))
    (add-active-region-method (region b) ':left-button-down :after 
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (when (exclusive (parent b))
					    (clear-button (items (parent b))))
					  (toggle-button b)
					  (mp:process-run-function (label b) #'button-call (action b))
					  )))
    (add-active-region-method (region b) ':middle-button-down :after
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (when (exclusive (parent b))
					    (clear-button (items (parent b))))
					  (toggle-button b)
					  (mp:process-run-function (label b) #'button-call (action b))
					  )))
    (add-active-region-method (region b) ':mouse-cursor-in :after
			      (function (lambda (wstream mouse-state event)
					  (declare (ignore wstream event))
					  (when (equal (cw:mouse-state-button-state mouse-state) cw:*middle-button-down*)
					    
					    (when (exclusive (parent b))
					      (clear-button (items (parent b))))
					    (toggle-button b)
					    (mp:process-run-function (label b) #'button-call (action b))
					    ))))
    ))

(defmethod enable-button ((b select-button))
    (let ((cf (font (display b))))
    (setf (font (display b)) (font b))
    (write-display (display b) (label b) (+ *button-frame-x* (left b))
		   (+ (bottom b) (height b) *button-frame-y* (font-baseline (font b))))
    (setf (font (display b)) cf))
  (cw:flush (region b)))

(defmethod disable-button ((b select-button))
    (if (colorp)
      (progn (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
	     (setf (font (display b)) (font b))
	     (write-display (display b) (label b) (+ *button-frame-x* (left b))
			    (+ (bottom b) (height b) *button-frame-y* (font-baseline (font b))))
	     (setf (cw:window-stream-foreground-color (pattern (display b))) black))
    (progn (cw:bitblt *gray-bitmap* 0 0 (window (display b)) (+ *button-frame-x* (left b)) (+ (bottom b) (height b) *button-frame-y*)
		      16 16 boole-and
		      (cw:make-region :left (+ *button-frame-x* (left b)) :bottom (+ (bottom b) (height b) *button-frame-y*)
				      :width (font-string-width (font b) (label b)) :height (font-character-height (font b))) t)
	   (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ *button-frame-x* (left b)) (+ (bottom b) (height b) *button-frame-y*)
		      16 16 boole-and
		      (cw:make-region :left (+ *button-frame-x* (left b)) :bottom (+ (bottom b) (height b) *button-frame-y*)
				      :width (font-string-width (font b) (label b)) :height (font-character-height (font b))) t)))
  (setf (region b) (make-active-region (scroll-region b) :left 0 :bottom 0
				       :width (inner-width (scroll-region b)) :height (inner-height (scroll-region b)))))

(defmethod unset-button ((b select-button))
  (setf (status b) nil)
  (close-display (scroll-region b))
  (let ((fd (font (display b))))
    (setf (font (display b)) (font b))
    (write-display (display b) (label b) (+ *button-frame-x* (left b))
		   (+ (bottom b) (height b) *button-frame-y* (font-baseline (font b))) :operation boole-clr)
    (setf (font (display b)) fd)))
  

(defmethod clear-button ((b select-item))
  (when (and (status b) (status (display b)))
    (setf (status b) nil)
    (cw:complement-area (window (display b))
			(cw:make-region :left (left b) :bottom (bottom b)
					:width (width b) :height (height b)))
    (cw:complement-area (pattern (display b))
			(cw:make-region :left (left b) :bottom (bottom b)
					:width (width b) :height (height b)))
    ))

(defmethod clear-button ((b select-button))
  (dolist (i (items b) t)
    (clear-button i)))


;;; This doesn't work correctly in color:

(defmethod toggle-button ((b select-item))
  (cw:complement-area (window (display b))
		      (cw:make-region :left (left b) :bottom (bottom b)
				      :width (width b) :height (height b)))
    (cw:complement-area (pattern (display b))
		      (cw:make-region :left (left b) :bottom (bottom b)
				      :width (width b) :height (height b)))
  (if (setf (status b) (not (status b)))
      (disable-button (inhibit-buttons b))
    (enable-button (inhibit-buttons b)))
  )

(defmethod disable-button ((b select-item))
  (if *debug* (format t "~%disable-button (~A select-item)" b))
  (when (and (display b) (status (display b)))
    (setf (region b) (cw:deactivate (region b)))
    (if (colorp)
	(progn
	  (if (status b)
	      (progn (draw-filled-rectangle (display b) (left b) (bottom b)
					    (width b) (height b) :color 50%-gray)
		     (setf (cw:window-stream-foreground-color (pattern (display b))) white))
	    (progn (clear-display (display b) :left (left b) :bottom (bottom b)
				  :width (width b) :height (height b))
		   (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)))
	  (if (label b)
	      (let ((cf (font (display b)))
		    (label (label b)))
		(setf (font (display b)) (font b))
		(write-display (display b) label (+ (left b) 2) (+ (bottom b) (font-baseline (font b)) 
								   (/ (- (height b) (font-character-height (font b))) 2)))
		(setf (font (display b)) cf)))
	  (setf (cw:window-stream-foreground-color (pattern (display b))) black)
	  )
      (progn
	(cw:bitblt *gray-bitmap* 0 0 (window (display b)) (left b) (bottom b) 16 16 boole-andc1
		   (cw:make-region :left (left b) :bottom (bottom b)
				   :width (width b) :height (height b)) t)
	(cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (left b) (bottom b) 16 16 boole-andc1
		   (cw:make-region :left (left b) :bottom (bottom b)
				   :width (width b) :height (height b)) t)))))

(defmethod enable-button ((b select-item))
  (if *debug* (format t "~%enable-button (~A select-item)" b))
  (when (and (display b) (status (display b)))
    (setf (region b) (cw:activate (region b)))
    (clear-display (display b) :left (left b) :bottom (bottom b)
		   :width (width b) :height (height b))
    (if (label b)
	(let ((cf (font (display b)))
	      (label (label b)))
	  (setf (font (display b)) (font b))
	  (write-display (display b) label (+ (left b) 2) (+ (bottom b) (font-baseline (font b)) 
							     (/ (- (height b) (font-character-height (font b))) 2)))
	  (setf (font (display b)) cf)))
    (when (status b) 
      (cw:complement-area (window (display b))
			  (cw:make-region :left (left b) :bottom (bottom b)
					  :width (width b) :height (height b)))
      (cw:complement-area (pattern (display b))
			  (cw:make-region :left (left b) :bottom (bottom b)
					  :width (width b) :height (height b))))))


(defun item-label ()
  (mp:process-name mp:*current-process*))

(defmethod active ((b select-button))
  (dolist (i (mapcar #'status (items b)) nil)
    (if i (return t))))

(defmethod add-item ((b select-button) i &key action)
  (let ((ih (inner-height (scroll-region b)))
	(newi (make-instance 'select-item :label (if (stringp i) i (write-to-string i))
			     :action action
			     :parent b
			     :font (font b) :width (- (width b) 1 (* 2 *button-frame-x*)))))
    (setf (inner-height (scroll-region b)) (+ ih (* 2 *button-frame-y*) (height newi)))
    (setf (slot-value b 'items) (cons newi (items b)))
    (setf (label newi) (clip-label newi))
    (set-button newi (scroll-region b)
		:left (1+ *button-frame-x*)
		:bottom (- (inner-height (scroll-region b)) (height newi) *button-frame-y*))
    (cw:scroll (window (scroll-region b)) (cw:make-region :bottom (- (inner-height (scroll-region b))
								     (height (scroll-region b)))))
    ))

(defmethod delete-item ((b select-button) i)
  )

(defmethod buttonp ((b button)) t)
(defmethod buttonp (aardvark) nil)


(defmethod unset-button ((b select-item))
  (clear-display (display b) :left (left b) :bottom (bottom b)
		 :width (width b) :height (height b))
  (setf (region b) (cw:activate (region b)))
  (setf (status b) nil))

(defmethod (setf items) (arg (b select-button))
  (dolist (i (items b) t)
    (unset-button i))
  (if (buttonp (car arg))
      (setf (slot-value b 'items) arg)
    (setf (slot-value b 'items) (let ((item-list nil))
				  (dolist (i arg (nreverse item-list))
				    (push (make-instance 'select-item :label (if (stringp i) i (write-to-string i))
							 :parent b
							 :font (font b)
							 :width (- (width b) 1 (* 2 *button-frame-x*) *static-scroll-bar-width*)) item-list)))))
  (setf (inner-height (scroll-region b)) (max (height b) (+ *button-frame-y* (* (+ *button-frame-y* (height (car (slot-value b 'items))))
										(length arg)))))
  (let ((lef (+ 1 *button-frame-x*))
	(bot (- (inner-height (scroll-region b)) *button-frame-y* (height (car (slot-value b 'items)))))
	(inc (+ *button-frame-y* (height (car (slot-value b 'items))))))
    (dolist (l (slot-value b 'items) t)
      (set-button l (scroll-region b) :left lef :bottom bot)
      (decf bot inc)))
  (cw:scroll (window (scroll-region b)) (cw:make-region :bottom (- (inner-height (scroll-region b))
								   (height (scroll-region b))))))

(defmethod (setf action) :after (arg (b select-button))
  (dolist (i (items b) arg)
    (setf (action i) arg)))

#| (defmethod (setf items) :after (arg (b select-button)))
(defmethod (setf items) :before (arg (b select-button)))

(+ *button-frame-y* (* (+ *button-frame-y* (height (car (items b))))
		       (length (items b))))

 |#