;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:GIN; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   help.cl
;;; Short Desc: online-help library
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Jun 15 1991
;;; Author:     na

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :gin)
(use-package :cwex)

(export '(display
	  file-does-not-exist
	  display-error
	  help-stream
	  filename
	  help-display
	  protect-display
	  clear-scroll
	  ask
	  ))


(defclass help-stream ()
	  ((filename :initform *help-file*
			  :initarg :filename
			  :accessor filename)
	   (width	:initarg :width :initform 500 :reader width)
	   (height	:initarg :height :initform 400 :reader height)
	   (bottom	:initarg :bottom :initform nil :reader bottom)
	   (left	:initarg :left :initform nil :reader left)
	   (normal-font	:initarg :font :initform *normal-font* :reader font)
	   (bold-font   :initarg :bold-font :initform *bold-font* :reader bold-font)
	   (italic-font :initarg :italic-font :initform *italic-font* :reader italic-font)
	   (title	:initarg :title :initform "Help" :reader title)
	   (start       :initform 0   :accessor start)
	   (eof         :initform 0   :accessor eof)
	   (previous    :initform nil :accessor previous)
	   (display     :accessor display)
	   (pre-height  :accessor pre-height)
	   (up-button   :accessor up-button)
	   (down-button :accessor down-button)
	   (exit-button :accessor exit-button)
	   (from-button :accessor from-button :initarg :from-button :initform nil)
	   (wstream      :accessor wstream)))

(defclass help-display (scroll-display)
	  ((width	:initarg :width
			:initform (+ 502 *static-scroll-bar-width*)
			:reader width)
	   (filename :initarg :filename
			  :accessor filename
			  :initform "")
	   ))

(defmethod initialize-instance :after ((d help-display) &key
				       width height left bottom
				       (inner-width (inner-width d))
				       (inner-height (inner-height d))
				       button-region scroll-region exit-button from-button)
  (if *debug* (format t "~%initialize-instance :after (d help-display) ~A" d))
  (setf (font (scroll-region d)) *normal-font*)
  (if (not (probe-file (filename d)))
      (file-does-not-exist (filename d)
				  :reason "Cannot open help-file, pathname used:"
				  :close-display d
				  :from-button (from-button d))
    (progn
      (show-file (scroll-region d) (filename d))
      (when (> (+ *static-scroll-bar-width*
		  (cw:window-stream-width (scroll-region d)))
	       (+ 2 (width d)))
	(setf (x-scrollbar d) t)
	(setf (inner-width d)
	  (+ (- *static-scroll-bar-width* 2)
	     (cw:window-stream-width (scroll-region d))))))))

(defmethod (setf filename) :after (value (d help-display))
  (if (not (probe-file value))
      (file-does-not-exist value
			   :reason "Cannot open help-file, pathname used:")
    (progn (show-file (scroll-region d) (filename d))
	   (when (> (+ *static-scroll-bar-width*
		       (cw:window-stream-width (scroll-region d)))
		    (+ 2 (width d)))
	     (setf (x-scrollbar d) t)
	     (setf (inner-width d)
	       (+ (- *static-scroll-bar-width* 2)
		  (cw:window-stream-width (scroll-region d))))))))


(defmethod initialize-instance :after ((h help-stream) &rest junk)
  (declare (ignore junk))
  (setf (eof h) nil)
  (if (not (probe-file (filename h)))
      (file-does-not-exist (filename h)
			   :reason "Cannot open help-file, pathname used:"
			   :from-button (from-button h))
    (progn
      (setf (wstream h) (open (filename h) :direction :input :if-does-not-exist nil))
      (setf (display h) (make-display :width (width h) :height (height h)
				      :bottom (bottom h) :left (left h)
				      :title (title h) :x-scrollbar t))
      (setf (pre-height h) (height (display h)))
      (cw:modify-window-stream-method (window (display h)) :reshape-notify :after
				      (function (lambda (&rest internal-data)
						  (declare (ignore internal-data))
						  (refresh h))))
      #| (setf (reshape-method (display h)) `(refresh ,h)) |#
      (let ((dpbs-p *default-push-button-size-p*))
	(setf *default-push-button-size-p* nil)
	(setf (up-button h) (make-instance 'push-button :bitmap *up*))
	(setf (down-button h) (make-instance 'push-button :bitmap *down*))
	(setf *default-push-button-size-p* dpbs-p))
      (draw-line (display h) 0 31 (width (display h)) 31)
      (setf (exit-button h) (make-instance 'push-button :label "Exit Help"))
      (set-button (exit-button h) (display h)
		  :bottom 5 :left (- (width h) (width (exit-button h)) 5)
		  :action `(lambda nil
			     (close-display ,(display h))
			     (close ,(wstream h))
			     (if ,(from-button h)
				 (reset-button ,(from-button h)))))
      (set-button (up-button h) (display h) :active nil
		  :bottom 5 :left (- (width h) (width (exit-button h)) (width (down-button h)) 10)
		  :action `(lambda nil (scroll-up ,h)))
      (set-button (down-button h) (display h) :active nil
		  :bottom 5 :left (- (width h) (width (exit-button h)) (width (down-button h))
				     (width (up-button h)) 15)
		  :action `(lambda nil (scroll-down ,h)))
      (setf (font (display h)) (font h))
      (refresh h :force t))))


(defmethod (setf filename) :after (value (h help-stream))
  (if (not (probe-file value))
      (file-does-not-exist value
			   :reason "Cannot open help-file, pathname used:")
    (progn (if (wstream h) (close (wstream h)))
	   (setf (wstream h) (open value :direction :input :if-does-not-exist nil))
	   (setf (start h) 0)
	   (refresh h :force t))))


(defmethod scroll-up ((h help-stream))
  (setf (start h) (car (previous h)))
  (setf (previous h) (cdr (previous h)))
  (file-position (wstream h) (start h))
  (refresh h :force t)
  (reset-button (up-button h))
  (unless (previous h) (disable-button (up-button h))))
  

(defmethod scroll-down ((h help-stream))
  (setf (previous h) (cons (start h) (previous h)))
  (setf (start h) (file-position (wstream h)))
  (file-position (wstream h) (- (start h) 1))
  (refresh h :force t)
  (enable-button (up-button h))
  (reset-button (down-button h))
  (if (eof h) (disable-button (down-button h))))

(defmethod refresh ((h help-stream) &key (force nil))
  (when (or force (not (equal (pre-height h) (height (display h)))))
    (protect-display h t)
    (setf (pre-height h) (height (display h)))
    (clear-display (display h) :bottom 32)
    (file-position (wstream h) (start h))
    (setf (eof h) nil)
    (let ((chars-read 0))
      (do ((line (read-line (wstream h) nil nil))
	   (bottom (- (height (display h)) 5 (font-character-height (font h))))
	   (decr (+ (cw:font-character-height (font h)) 4)))
	  ((or (not (stringp line)) (< bottom 38))
	   (if (not (stringp line)) (setf (eof h) t)))
	(if (> (+ (font-string-width (font (display h)) line) 10) (inner-width (display h)))
	    (setf (inner-width (display h)) (+ (font-string-width (font (display h)) line) 20)))
	(write-display (display h) "" 10 bottom)
	(do* ((string line line)
	      (start 0 (+ end 2))
	      (pos (search "<<" string :start2 start)
		   (search "<<" string :start2 start))
	      (end (if pos (search ">>" string :start2 (+ pos 2)))
		   (if pos (search ">>" string :start2 (+ pos 2)))))
	    ((null end)
	     (setf (font (display h)) *normal-font*)
	     (write-display (display h) (subseq string start)))
	  (setf (font (display h)) *normal-font*)
	  (write-display (display h) (subseq string start pos))
	  (setf (font (display h)) *bold-font*)
	  (write-display (display h) (subseq string (+ pos 2) end)))
	(setf bottom (- bottom decr))
	(setf chars-read (+ 1 chars-read (length line)))
	(setf line (read-line (wstream h) nil nil)))
      (file-position (wstream h) (+ (start h) chars-read)))
    (if (eof h) (if (equal (status (down-button h)) 0) (disable-button (down-button h)))
      (enable-button (down-button h)))
    (protect-display h nil)))



(defun file-does-not-exist (path &key
				 (reason "Unable to open file")
				 from-button
				 close-display
				 (width 400)
				 (height 92)
				 wait
				 (font *normal-font*))
  (let ((warning-display nil)
	(done nil)
	(w
	 (max 155
	  (font-string-width font
	    (write-to-string (merge-pathnames path)))
		(font-string-width font reason)))
	 (exit-button (make-instance 'push-button :label "Acknowledge")))
    (setf width (+ w 20))
    (setf warning-display (make-display :width width
					:height height :left 400
					:bottom 400 :title "File not found"
					:font font))
    (set-button exit-button warning-display
		:left 5 :bottom 5
		:action (function (lambda nil
				    (close-display warning-display)
				    (setf done t)
				    (if close-display
					(close-display close-display))
				    (if from-button
					(reset-button from-button)))))
    (write-display warning-display reason 10 70)
    (write-display warning-display (write-to-string (merge-pathnames path)) 10 45)
    (when wait (mp:process-wait "waiting for file-does-not-exist acknowledge"
				#'(lambda nil done)))))

(defun display-error (text &key
			   from-button
			   width height
			   left bottom
			   (font *normal-font*)
			   (wait t)
			   (title "Error")
			   (button-label "Acknowledge"))
  (let* ((*default-push-button-size-p* t)
	 (*default-push-button-width* 120)
	 (fonth (font-character-height font))
	 (done nil)
	 (stringl (make-string-list-from-text (format nil text)))
	 (exit-button (make-instance 'push-button :label button-label))
	 (position (cw:mouse-position))
	 (warning-display (make-display :title title
					:width (if width width (setf width (+ (* 2 fonth) (max (let ((result nil))
												 (dolist (i stringl (apply #'max result))
												   (push (font-string-width font i) result)))
											       (+ 10 (width exit-button))
											       155))))
					:height (if height height (setf height (* fonth (+ 3 (length stringl)))))
					:left (max 0 (min (- (width *root-window*) width)
							  (if left left (- (cw:position-x position) 119))))
					:bottom (max 0 (min (- (height *root-window*) height)
							    (if bottom bottom (- (cw:position-y position) 15))))
					:font font)))
    (set-button exit-button warning-display
		:left 5 :bottom 5
		:action (function (lambda (&rest cw-internals)
				    (declare (ignore cw-internals))
				    (setf done t)
				    (close-display warning-display)
				    (if from-button
					(reset-button from-button)))))
    (do ((y 1 (1+ y))
         (strings stringl (rest strings)))
        ((null strings))
      (write-display warning-display (first strings) fonth (- height (* fonth y))))
    (when wait (mp:process-wait "waiting for error acknowledge"
				#'(lambda nil done)))
    ))

(defun ask (string &key (left (truncate (width *root-window*) 2))
			(bottom (truncate (height *root-window*) 2))
			width height
			(font *default-font*)
			(title "Please answer")
			default
			from-button
			(condition (function (lambda (x) t)))
			(error-message "Error in input"))
  (let* ((stringl (make-string-list-from-text (format nil string)))
	 (fonth (font-character-height font))
	 (fontbl (font-baseline font))
	 (rx 0) (ry 0)
         (disp (make-display :title title :font font
                             :width (if width width (+ 200 (let ((result nil)) (dolist (i stringl (apply #'max result))
										 (push (font-string-width font i) result)))))
			     :height (if height height (setf height (* fonth (+ 2 (length stringl)))))
			     :left left :bottom bottom)))
    (do ((y 1 (1+ y))
         (strings stringl (rest strings)))
        ((null strings))
      (write-display disp (first strings) fonth (- height (* fonth y))))
    (setf rx (x-position disp)) (setf ry (y-position disp))
    (prog1
        (do* ((res (read-display disp rx ry :remove t) (read-display disp rx ry :remove t))
	      (ok (funcall condition res) (funcall condition res)))
	    (ok res)
	  (display-error error-message)
	  (clear-display disp :left rx :bottom (- ry fontbl) :height fonth))
      (close-display disp)
      (if from-button (reset-button from-button)))))


(defun y-or-n-dialog (query &key (title "Please Click")
				 (left (truncate (width *root-window*) 2))
				 (bottom (truncate (height *root-window*) 2))
				 height width
				 (cancel-button t)
				 (font *default-font*))
  (let* ((stringl (make-string-list-from-text (format nil "~a" query)))
	 (fonth (font-character-height font))
	 (wi (max 175 (+ (* 2 fonth) (let ((result nil)) (dolist (i stringl (apply #'max result))
						 (push (font-string-width font i) result))))))
	 (he (max (if height height 100) (* fonth (+ 5 (length stringl)))))
	 (dw (make-display :title title :font font
			   :width wi :height he
			   :left (max 0 (min (- (width *root-window*) wi)
					     left))
			   :bottom (max 0 (min (- (height *root-window*) he)
					       bottom))))
	 (done nil)
	 (yb (make-instance 'push-button :width 65 :label "Yes"))
	 (nb (make-instance 'push-button :width 65 :label "No"))
	 (cb (make-instance 'push-button :width (max 65 (+ 5 (font-string-width *default-font* "Cancel"))) :label "Cancel")))
    (do ((y 1 (1+ y))
         (strings stringl (rest strings)))
        ((null strings))
      (write-display dw (first strings) fonth (- he (* fonth y))))
    
    (set-button nb dw :left 5 :bottom 5 :action (function (lambda (&rest cw-internals)
							      (declare (ignore cw-internals))
							      (setf done t))))
    (set-button yb dw :left 5 :bottom (+ 11 (height nb)) :action (function (lambda (&rest cw-internals)
									     (declare (ignore cw-internals))
									     (setf done t))))
    (if cancel-button (set-button cb dw :left 103 :bottom 5 :action (function (lambda (&rest cw-internals)
							       (declare (ignore cw-internals))
							       (setf done t)))))
    (if *debug* (format t "~%Y-N dialog waiting for mouse-input"))
    (mp:process-wait "Y-N dialog Waiting"
		     #'(lambda nil done))
    (cw:flush (window dw))
    (if (equal (status yb) 1)
	:yes
      (if (equal (status nb) 1)
	  :no
	:canceled))))


(defmethod close-display ((h help-stream))
  (if (slot-boundp h 'display)
      (close-display (display h)))
  (if (and (slot-boundp h 'wstream) (wstream h)) (close (wstream h)))
  (if (from-button h)
      (reset-button (from-button h))))

(defmethod display-wait-status ((h help-stream) wait)
  (when (and (slot-boundp h 'display) (status (display h)))
    (if wait (setf (cw:window-stream-mouse-cursor (window (display h))) *mouse-cursor-timer*)
      (setf (cw:window-stream-mouse-cursor (window (display h))) *mouse-cursor-northwest-arrow*))))

(defmethod protect-display ((h help-stream) status)
  (if status
      (setf (region (display h)) (make-active-region (display h)))
    (if (region (display h)) (cw:flush (region (display h))))))


(defmethod status ((h help-stream))
  (if (slot-boundp h 'display)
      (status (display h))))

(defun colorp ()
  (eq cw::*color-support* :pseudocolor))


;;; for some strange reason cw:documentation-print does not work anymore
;;; here is what it does:

(defun cw:documentation-print (s &optional (clear t))
  (if (not (equal (cw:window-stream-status *prompt-window*) :flushed))
      (progn (when clear
	       (cw:clear *prompt-window*)
	       (cw:reset *prompt-window*))
	     (cw:expose *prompt-window*)
	     (format  *prompt-window* "~a" s))
    (format t "~a" s)))

;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================
