; ******************************************************************************
;
;             HOPFIELD-NET    
; 
; ******************************************************************************


;          **** GLOBAL VARIABLES ***

(defvar pattern-number)

; for preliminary graphics:

(defvar handle)



;             **** CLASSES ****

(defclass hopfield-net-class (net-class)
  ((learning-rate :initform 1
	          :initarg :learning-rate
	          :accessor learning-rate
	          :type 'real)
   (input-pattern-pool
                 :initform nil
		 :initarg :input-pattern-pool
		 :accessor input-pattern-pool
		 :type 'list))
  (:documentation "Foundation of all Hopfield nets"))


(defclass hopfield-node-class (node-class)
  ((threshold   :initform 0.0
		:initarg :threshold
		:accessor threshold
		:type 'real))
  (:documentation "Foundation of all Hopfield nodes"))




;              ***** ACTIONS *****
  
  
(defmethod compute-activation((node hopfield-node-class))
  (if 
      (> (input node) (threshold node))
      (setf (activation node) 1.0)
    (setf (activation node) 0.0)))


; ********* wird spaeter gestrichen ********
(defmethod compute-input((node node-class))
  (setf (input node) 0)
  (map 
      nil
    #'(lambda(q) 
	(setf (input node) 
	  (+ (input node)
	     (* 
	      (activation (from-node q))
	      (weight q)))))
    (in-connections node)))

; ******** Terminologie mit NP einheitlich machen (hier: compute-input, compute-activation, in NP: touch, update
(defun asynch-update (node-seq)
  (let* ((number-of-nodes (length node-seq))
	 random-number)
    (dotimes (node-number number-of-nodes)
      (setf random-number (random number-of-nodes))
      (let ((node (nth random-number node-seq)))
	(compute-input node)
	(compute-activation node)))))







(defmethod hopfield-compute-new-weights((net hopfield-net-class)(node node-class))
  (do
      ((n (length (in-connections node)))
       (i-c (in-connections node))
       (own-activation (activation node))
       (num 0 (+ 1 num)))
      ((= num n) ())
    (let*
	((curr-c (nth num i-c))
	 (old-weight (weight curr-c))
	 (delta-weight   
	  (* 
	   (learning-rate net)                   
	   (- (* 2 own-activation) 1)
	   (- (* 2 (activation (from-node curr-c))) 1))))
      (setf (weight curr-c)
	(+ old-weight delta-weight)))))




;        **** AUXILIARY FUNCTIONS ****


(defmethod hopfield-initialize-weights ((net hopfield-net-class)  val)
  (traverse-node-seq (get-node-seq net (second (get-node-seq-names net))) 
		     n
		     (map
			 nil
		       #'(lambda(y)
			     (setf (weight y) val))
		       (in-connections n))))


(defmethod hopfield-feed-in ((net hopfield-net-class) activation-list node-seq)
  (do ((current-a-list activation-list (cdr current-a-list))
       (current-n-list node-seq (cdr current-n-list)))
      ((or (null current-a-list) (null current-n-list)))
    (setf (activation (car current-n-list)) (car current-a-list))))


; wird nicht verwendet: gehoerte eigentlich in die generelle library
(defun get-weights (net layer number from-layer)
  (let
      ((node (nth number (get-node-seq net layer))))
    (terpri)
    (do
	((n (length (in-connections node)))
	 (i-c (in-connections node))
	 (m 0)
	 (num 0 (+ 1 num)))
	((= num n) ())
      (let*
	  ((curr-c (nth num i-c)))
	(if
	    (member (from-node curr-c) (get-node-seq net from-layer))
	    (progn
	      (princ (position (from-node curr-c) (get-node-seq net from-layer)))
	      (princ ": ")(princ (weight curr-c))(terpri)
	      (setq m (+ m 1))))))))


; ********** Spaeter noch zu aendern (pattern verwaltung standardisieren) **********

(defmethod fill-input-pattern-pool ((net hopfield-net-class) patterns)
					; "patterns" is a list of lists, each of which contains 
					; an activation pattern for the input layer nodes (1s and 0s)
  (setf (input-pattern-pool net) patterns))


(defmethod choose-input-pattern-randomly ((net hopfield-net-class)) 
  (nth (random (length (input-pattern-pool net))) (input-pattern-pool net))) 

(defmethod choose-input-pattern-one-after-the-other ((net hopfield-net-class))
  (setq pattern-number (+ pattern-number 1))
  (setq pattern-number (mod pattern-number (length (input-pattern-pool net))))
  (nth pattern-number  (input-pattern-pool net))) 





;              ***** BUILDING THE NETWORK STRUCTURE ******


(defun hopfield-make-net (net-name number-of-nodes)
  (let
      ((net (make-net net-name 'hopfield-net-class '(hopfield-node-seq))))

					; Node sequence
    (make-node-seq net 
		   'hopfield-node-class 
		   'hopfield-node-seq
		   number-of-nodes)

					; Total interconnectivity within node sequence 
    (connect-nodes-in-node-seq 'connection-class 
			       (get-node-seq net 'hopfield-node-seq)
			       nil
			       :weight 0)))


;                   ***** RUN *****


(defmethod run-hopfield-learn ((net hopfield-net-class))
  (do
      ((pattern-presentations (length (input-pattern-pool net)))
       (pattern-counter 0 (+ pattern-counter 1)))
      ((= pattern-counter pattern-presentations) (progn (terpri)  "Run finished"))
    (hopfield-feed-in net (nth pattern-counter (input-pattern-pool net)) (get-node-seq net 'hopfield-node-seq))
    (traverse-node-seq (get-node-seq net 'hopfield-node-seq) n (hopfield-compute-new-weights net n)) 
    (update-ns-view handle)))



;In the function below, the "pattern" is given as a list of 1s and 0s.

(defmethod run-hopfield-recall ((net hopfield-net-class) pattern cycles)
  (hopfield-feed-in net pattern (get-node-seq net 'hopfield-node-seq))
  (do
      ((n 0 (+ n 1)))
      ((= n cycles) (progn (terpri)  "Run finished"))
    (asynch-update (get-node-seq net 'hopfield-node-seq))
    (update-ns-view handle)))




;             ****** PRELIMINARY GRAPHICS ******

(defmethod hopfield-make-activation-output ((net hopfield-net-class) columns)
	    (setf handle (get-ns-view-handle (get-node-seq net 'hopfield-node-seq) columns)))























