;;; -*- Mode: LISP; Package: NN; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   nn-main-dialog.cl
;;; Short Desc: dialog handling for both neural nets algorithms
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   
;;; Author:     PC
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Taken from the rules-dialog.cl
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :nn)


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *display-list* nil)

(defun start-nn-dialog (&optional (from-button nil))
  (let* ((disp (make-instance 'display :title "Neural Networks: Main Window"
			      :width 450
			      :height 200
			      :borders 1
			      :bottom (bottom pail-lib::*main-window*)
			      :left (+ (width pail-lib::*main-window*) (left pail-lib::*main-window*))))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			  :technical (add-path "rules-doc.tec"
					       (add-subdir *pail-path* "np"))
			  :general (add-path "rules-doc.gen"
					     (add-subdir *pail-path* "np"))
			  :subject "Neural Networks"))
	 (back-propagation-button   (make-instance 'push-button :label "Back Propagation" :width 200))
	 (hopfield-nets-button   (make-instance 'push-button :label "Hopfield Nets" :width 200))
	 (*default-push-button-size-p* nil)
	 left-side)

    (push disp *display-list*)
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
  
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 18 :weight :bold))
    (write-display disp
		   "   Neural Networks"
		   (/ (- (width disp) (font-string-width (font disp) "Truth Maintenance Systems")) 2)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)

    (set-button help-button disp :left 15 :bottom 15)
    
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda () (exit-function ,exit-button ,from-button)))
    (setf left-side (floor (- (width disp) (width back-propagation-button)) 2))
    (set-button back-propagation-button disp
		:left left-side
		:bottom (* 2 (height exit-button))
		:action `(lambda nil (start-back-propagation :from-button ,back-propagation-button)))
    (set-button hopfield-nets-button disp
		:left left-side
		:bottom (* 3 (height exit-button))
		:action `(lambda () (start-hopfield-nets :from-button ,hopfield-nets-button)))
    disp))


(defun start-back-propagation (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "np-make" (add-subdir *pail-path* "np")) 
		 :source t :force t))
  (np::start-np-dialog from-button))


(defun start-hopfield-nets (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "hopfield-make" (add-subdir *pail-path* "hopfield")) 
		 :source t :force t))
  (hopfield::start-hop-dialog from-button))


(defun exit-function (exit-button from-button)
  (progn (dolist (d *display-list*)
	   (close-display (eval d)))
	 (reset-button from-button)))

(defun yes-or-no-dialog (query &key (title "Please Click"))
  (let ((dw (make-instance 'menu
	     :left 500
	     :bottom 500
	     :query query
	     :items '(("Yes" t) ("No" nil)))))
    (accept-items dw)))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================

