;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:HOPFIELD; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   hopfield-interface.cl
;;; Short Desc: Defined are the classes that make-up the interface
;;; Author:	Erik Vinkhuyzen

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :hopfield)


(defvar *debug* nil)


(import `(mp::without-scheduling))

(defclass output-window (display)
    ; This class defines the output window of the network.
    ; It the activations of the network. in the activations-window,`
    ; and has several buttons with transparent functionality.
	  ((hopfield-network
	                    :initarg :hopfield-network
			    :accessor hopfield-network
			    :type hopfield-network)
	   (energy-window   :initarg :energy-window
			    :accessor energy-window
			    :initform nil
			    :type energy-window)
	   (activations-window  
	                    :initarg :activations-window
			    :initform nil
			    :accessor activations-window
			    :type activations-window)
	   (exit-button     :initform (make-instance 'push-button :label "Exit")
	                    :initarg :exit-button
			    :accessor exit-button
			    :type push-button)
	   (step-button     :initarg :step-button
			    :accessor step-button
			    :initform (make-instance 'push-button :label "Step")
			    :type push-button)
	   (help-button     :initform (make-instance 'help-button :label "Help"
						     :technical (add-path "technical-output-help" *hoppath*)
						     :general (add-path "general-output-help" *hoppath*)
						     :subject "Help for Output-Window")
	                    :initarg :help-button
			    :accessor help-button
			    :type help-button)
	   (reset-button    :initarg :reset-button
			    :accessor reset-button
			    :initform (make-instance 'push-button :label "Reset")
			    :type push-button)
	   (current-cycle-button
	                    :initarg :current-cycle-button
			    :accessor current-cycle-button
			    :initform (make-instance 'value-button :name "Current Cycle: ")
			    :type value-button)
	   ))

(defmethod initialize-instance :after ((ow output-window) &key)
  (setf (activations-window ow) (make-instance 'activations-window 
						:parent ow
						:title "Activations"
						:width (- (height ow) 30)
						:height (- (height ow) 30)
						:left 5
						:bottom 5))
  ;(if *debug* (format t "(initialize-instance output-window) activations-window"))
  (setf (energy-window ow) (make-instance 'energy-window 
					   :parent ow
					   :title "Energy"
					   :width 200
					   :height (+ 10 (font-character-height *default-font*))
					   :left (+ (width (activations-window ow)) (floor (/ (- (width ow) (width (activations-window ow))) 3)))
					   :bottom (floor (+ 5 (* 2 (/ (height (activations-window ow)) 3))))))
  ;(if *debug* (format t "(initialize-instance output-window) energy-window"))
  #|(setf (hamming ow) (make-instance 'energy-window 
					   :parent ow
					   :title "Hamming Distance"
					   :width 200
					   :height (+ 10 (font-character-height *default-font*))
					   :left (- (width ow) 220)
					   :bottom (- (height ow) 100)))|#
  ;(if *debug* (format t "(initialize-instance output-window) hamming"))
  (set-button (current-cycle-button ow) ow
	      :bottom (floor (+ 5 (/ (height (activations-window ow)) 3)))
	      :left (+ (width (activations-window ow)) (floor (* 2 (/  (- (width ow) (width (activations-window ow))) 3))))
	      )
  
  (setf (action (step-button ow)) `(lambda () (step-test (hopfield-network ,ow))
					   (reset-button (step-button ,ow))))
  (set-button (step-button ow) ow
	      :bottom (floor (+ 5 (/ (height (activations-window ow)) 3)))
	      :left (+ (width (activations-window ow)) 20))
  
  
  (set-button (help-button ow) ow 
	      :left (+ 20 (width (activations-window ow)))
	      :bottom (bottom (activations-window ow))
	      :border 2)
  ;(if *debug* (format t "(initialize-instance output-window) help-button"))
  (set-button (reset-button ow) ow 
	      :left (+ (width (activations-window ow)) 20)
	      :bottom (floor (+ 5 (* 2 (/ (height (activations-window ow)) 3))))
	      :border 2
	      :action `(lambda () (reset (hopfield-network ,ow))
			       (reset-button (reset-button ,ow))))
  
  
  ;(if *debug* (format t "(initialize-instance output-window) reset-button"))
  (set-button (exit-button ow) ow 
	      :left  (+ (width (activations-window ow)) (floor (* 2 (/  (- (width ow) (width (activations-window ow))) 3))))
	      :bottom (bottom (activations-window ow))
	      :border 2
	      :action `(lambda nil (exit (hopfield-network ,ow))))
  ;(if *debug* (format t "(initialize-instance output-window) exit-button"))
  )
  
  
(defmethod renew-display ((ow output-window))
  (setf (activations-window ow) (make-instance 'activations-window 
						:parent ow
						:title "Activations"
						:width (- (height ow) 30)
						:height (- (height ow) 30)
						:left 5
						:bottom 5)))

(defmethod update-cycle-button ((ow output-window) cycle)
  (setf (button-value (current-cycle-button ow)) cycle))


(defclass input-window (display)
	  ; This input-window is a window in which the student can interact.
	  ; It has a window with units, that correspond to an array of activations.
	  ; Furthermore it has buttons in which you can define the parameters of the
	  ; netwrok like the learning-rate, the decay, the number of cycles and the treshold.
	  ; Also it has buttons that allow a student to store several patterns and 
	  ; learn all these patterns in a row.
	  ((hopfield-network
	                    :initarg :hopfield-network
			    :accessor hopfield-network
			    :type hopfield-network)
	   (editor-window   :initarg :editor-window
			    :initform nil
			    :accessor editor-window
			    :type editor-window)
	   (pool-button     :initarg :pool-button
			    :accessor pool-button
			    :initform (make-instance 'pool-button
					:pool *pail-pool*
					:label "Patterns:"
					:target-class 'hopfield-patterns
					:width (round (width *root-window*) 12)
					:show-function
					#'(lambda (item)
					    (documentation-print (patterns item))))
			    :type pool-button)
	   (store-button    :initarg :store-button
			    :accessor store-button
			    :initform (make-instance 'push-button :label "Store")
			    :type push-button)
	   (next-button     :initarg :next-button
			    :accessor next-button
			    :initform (make-instance 'push-button :label "Next")
			    :type push-button)
	   (delete-button   :initarg :delete-button
			    :accessor delete-button
			    :initform (make-instance 'push-button :label "Delete")
			    :type push-button)
	   (noise-button    :initarg :noise-button
			    :accessor noise-button
			    :initform (make-instance 'push-button :label "Noise")
			    :type push-button)
	   (clamp-button    :initarg :clamp-button
			    :accessor clamp-button
			    :initform (make-instance 'push-button :label "Clamp")
			    :type push-button)
	   (learn-all-button    
                            :initarg :learn-all-button
			    :accessor learn-all-button
			    :initform (make-instance 'push-button :label "Learn All")
			    :type push-button)
	   (learn-button    :initarg :learn-button
			    :accessor learn-button
			    :initform (make-instance 'push-button :label "Learn")
			    :type push-button)
	   (clear-button    :initarg :clear-button
			    :accessor clear-button
			    :initform (make-instance 'push-button :label "Clear")
			    :type push-button)
	   (test-button     :initarg :test-button
			    :accessor test-button
			    :initform (make-instance 'push-button :label "Test")
			    :type push-button)
	   (exit-button     :initform (make-instance 'push-button :label "Exit")
	                    :initarg :exit-button
			    :accessor exit-button
			    :type push-button)
	   (help-button     :initform (make-instance 'help-button
					:technical (add-path "technical-input-help" *hoppath*)
					:general (add-path "general-input-help" *hoppath*)
					:subject "Help for Input-Window")
	                    :initarg :help-button
			    :accessor help-button
			    :type help-button)))

(defmethod initialize-instance :after ((input input-window) &key)
  (setf (editor-window input) (make-instance 'editor-window
			       :parent input
			       :title "Pattern Editor"
			       :width (- (height input) 30)
			       :height (- (height input) 30)
			       :left 5
			       :bottom 5))
  (setf (button-value (pool-button input))
    (make-instance 'pool-item :start-object (hopfield-patterns (editor-window input))
		   :name-part "FourbyFour"))
  (if *debug* (format t "3"))
  #|(setf (before-action (pool-button input)) `(lambda nil (setf (activations (hopfield-data (hopfield-network ,input)))
							   (activations (editor-window ,input)))
						     (setf (slot-value (pool-button ,input) 'start-object) 
						       (hopfield-data (hopfield-network ,input)))))|#
  (setf (after-get (pool-button input))
    `(lambda (item)
       (setf *item* item)
       (when (and (<= 5 (size (start-object item)))
		  (not (no-weight-window (hopfield-network ',input))))
	 (display-error "The weight-window will be killed, otherwise it will go too slow")
	 (setf (no-weight-window (hopfield-network ',input)) t))
       (when (not (eql (size (hopfield-network ',input))
		     (round (length (car (patterns (start-object item)))))))
	   (setf (size (hopfield-network ',input)) (round (length (car (patterns (start-object item))))))
	   (setf (button-value (size-button (parameter-window (hopfield-network ',input))))
	     (round (sqrt (size (hopfield-network ',input)))))
	 )
       (setf (editor-window (start-object item)) (editor-window ,input))
       (setf (hopfield-patterns (editor-window ,input)) (start-object item))
       (setf (hopfield-network (start-object item)) (hopfield-network ',input))
       (enable-buttons ,input)
       (let ((hp (hopfield-patterns (editor-window ,input))))
	 (if (null (current hp)) (setf (current hp) (size hp)))
	 (next-pattern hp))
       ))
  
  (set-button (pool-button input) input
	      :left (- (width input) 130)
	      :bottom (floor (+ 5 (* 2 (/ (height (editor-window input)) 5)))))
  (setf (action (clamp-button input)) `(lambda () 
				 (without-scheduling (clamp (hopfield-network ,input) 
							    (activations (editor-window ,input))))
				 (reset-button (clamp-button ,input))))
  (set-button (clamp-button input) input
	      :bottom (floor (+ 5 (/ (height (editor-window input)) 5)))
	      :left (+ (width (editor-window input)) (floor (/ (- (width input) (width (editor-window input))) 3))))
  
  
  (setf (action (learn-button input)) `(lambda nil 
				      (without-scheduling (software-push (clamp-button ,input)))
				      (without-scheduling (hopfield-learn
							   (hopfield-network ,input)))
				      (reset-button (learn-button ,input))))				      
  (set-button (learn-button input) input
	      :bottom (floor (+ 5 (* 3 (/ (height (editor-window input)) 5))))
	      :left (+ (width (editor-window input)) (floor (/ (- (width input) (width (editor-window input))) 3))))
  (setf (action (learn-all-button input)) `(lambda nil
					     (let ((x (cycles (hopfield-network ,input))))
					       (setf (cycles (hopfield-network ,input)) 1)
					       (loop for j from 1 to x
						   do (progn (update-cycle-button (output-window (hopfield-network ,input)) j)
							     (loop for i from 1 to (size (hopfield-patterns (editor-window ,input)))
								 do (progn
								      (without-scheduling (setf (current (hopfield-patterns (editor-window ,input))) i))
								      (without-scheduling (software-push (clamp-button ,input)))
								      (without-scheduling (software-push (learn-button ,input)))))))
					       (reset-button (learn-all-button ,input))
					       (setf (cycles (hopfield-network ,input)) x))))
  (set-button (learn-all-button input) input
	      :bottom (floor (+ 5 (* 4 (/ (height (editor-window input)) 5))))
	      :left (+ (width (editor-window input)) (floor (/ (- (width input) (width (editor-window input))) 3))))
  (disable-button (learn-all-button input))
  (setf (action (clear-button input)) `(lambda nil
				   (clear (editor-window ,input))
				   (reset-button (clear-button ,input))))
  (set-button (clear-button input) input
	      :bottom (floor (+ 5 (/ (height (editor-window input)) 5)))
	      :left (+ 20 (width (editor-window input))))
  (setf (action (test-button input)) `(lambda nil (without-scheduling (software-push (clamp-button ,input)))
					      (without-scheduling (test (hopfield-network ,input)))
					      (reset-button (test-button ,input))))
  (set-button (test-button input) input
	     :bottom (floor (+ 5 (* 2 (/ (height (editor-window input)) 5))))
	     :left (+ (width (editor-window input)) (floor (/ (- (width input) (width (editor-window input))) 3))))
  
  (set-button (store-button input) input 
	      :left (+ (width (editor-window input)) 20)
	      :bottom (floor (+ 5 (* 4 (/ (height (editor-window input)) 5))))
	      :action `(lambda () 
			 (add-pattern (activations (editor-window ,input))
				      (hopfield-patterns (editor-window ,input)))
			 (reset-button (store-button ,input))
			 (enable-buttons ,input)))
			 
  (set-button (next-button input) input 
	      :left (+ (width (editor-window input)) 20)
	      :bottom (floor (+ 5 (* 2 (/ (height (editor-window input)) 5))))
	      :action `(lambda ()
			 (next-pattern (hopfield-patterns (editor-window ,input)))
			 (reset-button (next-button ,input))))
  (disable-button (next-button input))
  (set-button (delete-button input) input
	      :left (+ (width (editor-window input)) 20)
	      :bottom (floor (+ 5 (* 3 (/ (height (editor-window input)) 5))))
	      :action `(lambda ()
			 (delete-pattern (hopfield-patterns (editor-window ,input)))
			 (reset-button (delete-button ,input))))
  (disable-button (delete-button input))
  (set-button (noise-button input) input
	      :left (+ (width (editor-window input)) 20)
	      :bottom (bottom (editor-window input))
	      :action `(lambda () (generate-random-pattern (editor-window ,input))
			       (reset-button (noise-button ,input))))
  (if *debug* (format t "6"))
  (set-button (exit-button input) input 
	      :left (+ (width (editor-window input)) (floor (* 2 (/  (- (width input) (width (editor-window input))) 3))))
	      :bottom (bottom (editor-window input))
	      :border 2
	      :action `(lambda nil (exit (hopfield-network ,input))))
  (if *debug* (format t "8"))
  (set-button (help-button input) input 
	      :left (+ (width (editor-window input)) (floor (/ (- (width input) (width (editor-window input))) 3)))
	      :bottom (bottom (editor-window input))
	      :border 2)
  (if *debug* (format t "9")))


(defmethod renew-display ((input input-window))
  (setf (editor-window input) (make-instance 'editor-window
			       :parent input
			       :title "Pattern Editor"
			       :width (- (height input) 30)
			       :height (- (height input) 30)
			       :left 5
			       :bottom 5))
  (disable-button (learn-all-button input))
  (disable-button (delete-button input))
  (disable-button (next-button input))
  (reset (hopfield-patterns (editor-window input))))
	
  
(defmethod enable-buttons ((input input-window))
  (loop for i in (list (learn-all-button input)
		       (delete-button input)
		       (next-button input))
    do (loop while (< (status i) 0)
			do (enable-button i))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Parameter-Window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass parameter-window (display)
	  ((hopfield-network
	                    :initarg :hopfield-network
			    :accessor hopfield-network
			    :type hopfield-network)
	   (cycle-button    :initarg :cycle-button
			    :accessor cycle-button
			    :initform (make-instance 'value-button
					:name "Cycles"
					:numeric t
					:bottom 150
					:left 150
					:value 1)
			    :type value-button)
	   (size-button     :initarg :size-button
			    :accessor size-button
			    :initform (make-instance 'value-button
					:name "Size"
					:numeric t
					:bottom 270
					:left 150)
			    :type value-button)
	   (decay-button    :initarg :decay-button
			    :accessor decay-button
			    :initform (make-instance 'value-button
					:name "Decay"
					:numeric t
					:bottom 110
					:left 150
					:value 0)
			    :type value-button)
	   (threshold-button :initarg :threshold-button
			    :accessor threshold-button
			    :initform (make-instance 'value-button
					:name "Threshold"
					:numeric t
					:bottom 70
					:left 150
					:value 0)
			    :type value-button)
	   (lrate-button    :initarg :lrate-button
			    :accessor lrate-button
			    :initform (make-instance 'value-button
					:name "Learning Rate"
					:numeric t
					:bottom 190
					:left 150
					:value 1)
			    :type value-button)
	   (asynchronous-button
	                    :initarg :asynchronous-button
			    :accessor asynchronous-button
			    :initform (make-instance 'push-button 
					:label "  Synchrone "
					:left 100
					:bottom 230)
			    :type push-button)
	   (weight-window-button
	                    :initarg :weight-window-button
			    :accessor weight-window-button
			    :initform (make-instance 'radio-button
					:label "weight-window"
					:left 50
					:bottom 310
					:status t)
			    :type radio-button)					
	   (help-button     :initform (make-instance 'help-button
					:technical (add-path "technical-parameter-help" *hoppath*)
					:general (add-path "general-parameter-help" *hoppath*)
					:subject "Help for Parameter-Window"
					:bottom 30
					:left 30)
	                    :initarg :help-button
			    :accessor help-button
			    :type help-button)
	   (exit-button     :initarg :exit-button
			    :accessor exit-button
			    :initform (make-instance 'push-button 
					:label "Exit"
					:left 200
					:bottom 30)
			    :type push-button)))


(defmethod initialize-instance :after ((pw parameter-window) &key)
  (setf (action (cycle-button pw)) `(lambda nil 
				      (setf (cycles (hopfield-network ,pw))
					(button-value ,(cycle-button pw)))))
  (set-button (cycle-button pw) pw)
  (setf (action (weight-window-button pw)) `(lambda ()
					      ;(if *debug* (format t "executing the action of the (weight-window-button pw) now! ~%"))
					      (setf (no-weight-window (hopfield-network ,pw)) 
						(not (status ,(weight-window-button pw))))))
  (set-button (weight-window-button pw) pw)
  (setf (action (size-button pw)) `(lambda nil
				     (when (and (<= 5 (button-value ,(size-button pw)))
						(not (no-weight-window (hopfield-network ,pw))))
					 (display-error "The weight-window will be killed, otherwise it will go too slow")
					 (toggle-button (weight-window-button ,pw)))
				     (setf (size (hopfield-network ,pw)) (* (button-value ,(size-button pw))
									    (button-value ,(size-button pw))))))
  (setf (button-value (size-button pw)) (floor (sqrt (size (hopfield-network pw)))))
  (set-button (size-button pw) pw)
  (setf (action (threshold-button pw)) `(lambda () (setf (threshold (hopfield-network ,pw))
						     (button-value ,(threshold-button pw)))))
  (set-button (threshold-button pw) pw)
  (setf (action (lrate-button pw)) `(lambda nil 
					 (setf (learning-rate (hopfield-network ,pw)) 
					   (button-value ,(lrate-button pw)))))
  (set-button (lrate-button pw) pw)
  (setf (action (decay-button pw)) `(lambda nil 
				      (setf (decay (hopfield-network ,pw))
					(button-value ,(decay-button pw)))))
  (set-button (decay-button pw) pw)
  (setf (action (asynchronous-button pw))
    `(lambda () (cond ((string= (label ,(asynchronous-button pw)) "  Synchrone ")
		       (setf (asynchronous (hopfield-network ,pw)) t)
		       (setf (label ,(asynchronous-button pw)) " Asynchrone ")
		       (reset-button ,(asynchronous-button pw)))
		      (t 
		       (setf (asynchronous (hopfield-network ,pw)) ())
		       (setf (label ,(asynchronous-button pw)) "  Synchrone ")
		       (reset-button ,(asynchronous-button pw))))))
  (set-button (asynchronous-button pw) pw)
  (set-button (help-button pw) pw)
  (setf (action (exit-button pw)) `(lambda () (exit (hopfield-network ,pw))))
  (set-button (exit-button pw) pw))
  
  
  


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The windows with a value in it
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass value-display (display) 
	  ((value :accessor value
		  :initarg :value
		  :type float)))



(defmethod (setf value) :after (value (vd value-display))
  (clear-display vd)
  (write-display vd (format nil "~a" value) 5 5))


(defclass energy-window (value-display) ())


(defmethod update ((ew energy-window) energy)
  (setf (value ew) energy))



(defclass hamming-window (value-window) ())



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The windows displaying the activations
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass grid-window (display)
	  ; This class is an abstract superclass, the sole reason being the definition
	  ; of the slot "radio-button-array"
	  ((radio-button-array :initarg :radio-button-array
			       :accessor radio-button-array
			       :initform nil
			       :type array)
	   ))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; square-grid-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass square-grid-window (grid-window)
	  ; This class is the superclass of both the activations-window in the 
	  ; output window and the editor-window of the input-window.
	  ; It displays the radio-button-array neatly in the window.
	  ( ))



(defmethod (setf radio-button-array) :after (radio-button-array (gw square-grid-window))
  ; This method puts the radio-button-array into the display
  ;(if *debug* (format t "Now: ((setf radio-button-array) grid-window)"))
  ;(set-button (aref radio-button-array 0 0) dw :bottom 0 :left 0)
  (let ((size (floor (sqrt (size (hopfield-network (parent gw)))))))
    (loop for i from 0 to (- size 1)
      do (loop for j from 0 to (- size 1)
	   for x = (+ i (* j size))
	do (progn (setf (width (aref radio-button-array x)) 
		    (floor (/ (width gw) size)))
		(setf (height (aref radio-button-array x))
		  (floor (/ (width gw) size)))
		(set-button (aref radio-button-array x) gw
		       :bottom (floor (- (width gw) (* (/ (width gw) size) (+ j 1))))
		       :left (* i (floor (/ (width gw) size)))))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; activations-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass activations-window (square-grid-window)
; The next slot should be the very same as the activations in the hopfield-network
	  ((units :initarg :units
		  :accessor units
		  :type array)))


(defmethod initialize-instance :after ((aw activations-window) &key)
; The activations-window requires a different kind of radio-button that does not 
; change color when it is pressed. Nor does it need to send a message.
  (let ((size (size (hopfield-network (parent aw)))))
    (if *debug* (format t "initialize-instance activations-window"))
    (setf (units aw) (units (hopfield-network (parent aw))))
    (setf (radio-button-array aw) (make-array size
					      :initial-contents (loop for i from 0 to (- size 1)
								    collect (radio-button (aref (units aw) i)))
					      :element-type 'radio-button-for-activations-window))))


(defmethod update-buttons ((aw activations-window))
  ; This method should display the new activations.
  ; When the activations are changed, the radio-buttons that represent the change should be changed too!
  (let ((size (size (hopfield-network (parent aw)))))
    (loop for i from 0 to (- size 1)
	do (if (eq (activation (aref (units aw) i)) 1)
		  (setf (status (aref (radio-button-array aw) i)) t)
		(setf (status (aref (radio-button-array aw) i)) nil)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; editor-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass editor-window (square-grid-window) 
  ((activations :initarg :activations
		:accessor activations
		:type array)
   (hopfield-patterns :initarg :hopfield-patterns
		      :accessor hopfield-patterns
		      :initform (make-instance 'hopfield-patterns)
		      :type hopfield-patterns)
   ))


; The editor-window should keep its array updated with the user input.
; When the test-button is pressed it should take this pattern.

(defmethod initialize-instance :after ((ew editor-window) &key)
  (let* ((size (size (hopfield-network (parent ew)))))
    (setf (activations ew) (make-array (size (hopfield-network (parent ew))) 
				       :adjustable t
				       :element-type 'integer
				       :initial-contents 
				       (loop for x from 0 to (- size 1)
					   collect -1)))
    (if *debug* (format t "initialize-instance :after (editor-window) inside let~%"))
    (setf (hopfield-network (hopfield-patterns ew)) (hopfield-network (parent ew)))
    (setf (editor-window (hopfield-patterns ew)) ew)
    (setf (radio-button-array ew) (make-array (size (hopfield-network (parent ew)))
					      :element-type 'radio-button-with-index
					      :initial-contents
					      (loop for i from 0 to (- size 1)
						  collect (make-instance 'radio-button-with-index
									:label ""
									:x i))))
									

    ;(if *debug* (format t "(initialize-instance :after editor-window) made radio-button-array ~%"))
    (loop for i from 0 to (- size 1)
	do (setf (action (aref (radio-button-array ew) i)) `(lambda nil (update-activations ,ew (status (aref (radio-button-array ,ew) ,i))
											    (x (aref (radio-button-array ,ew) ,i))))))))

(defmethod clear ((ew editor-window))
  (let ((size (size (hopfield-network (parent ew)))))
    (loop for i from 0 to (- size 1)
      do (progn (setf (aref (activations ew) i) -1)
		(white (aref (radio-button-array ew) i))
		(setf (status (aref (radio-button-array ew) i)) nil)))))

(defmethod update-activations ((ew editor-window) status index)
  ;(if *debug* (format t "update-activations with status: ~a index: ~a~%" status index))
    (if status
	(setf (aref (activations ew) index) 1)
      (setf (aref (activations ew) index) -1)))
	
(defmethod reset ((ew editor-window))
  (clear ew)
  (setf (patterns (hopfield-patterns ew)) ()))




(defmethod generate-random-pattern ((ew editor-window))
  (let ((size (size (hopfield-network (parent ew)))))
    (loop for a from 0 to (- size 1)
      do (when (< 90 (random 100))
	   (cond ((= (aref (activations ew) a) 1)
		  (setf (aref (activations ew) a) -1)
		  (update-radio-button ew a -1))
		 (t
		  (setf (aref (activations ew) a) 1)
		  (update-radio-button ew a 1)))))))

(defmethod update-radio-button ((ew editor-window) index value)
  (cond ((= value 1)
	 (setf (slot-value (aref (radio-button-array ew) index) 'status) t)
	 (black (aref (radio-button-array ew) index)))
	(t
	 (setf (slot-value (aref (radio-button-array ew) index) 'status) nil)
	 (white (aref (radio-button-array ew) index)))))


(defmethod update-display ((ew editor-window))
  ; This method changes the display according to the new array.
  (let* ((size (size (hopfield-network (parent ew)))))
    (loop for x in (loop for a from 0 to (- size 1)
				   collect (aref (activations ew) a))
      for y from 0 to (- size 1)
      	if (= x 1)
	do (progn (setf (slot-value (aref (radio-button-array ew) y) 'status) t)
		  (black (aref (radio-button-array ew) y)))
      else do (progn (setf (slot-value (aref (radio-button-array ew) y) 'status) nil)
		  (white (aref (radio-button-array ew) y))))))
      
  

			

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; weight-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
  
      
(defclass weight-window (display)
    ((weight-button
	              :initarg :weight-button
		      :accessor weight-button
		      :initform (make-instance 'value-button
				  :action nil
				  :name "weight: ")
		      :type value-button)
     (hopfield-network 
	              :initarg :hopfield-network
		      :accessor hopfield-network
		      :type hopfield-network)
     (weight-grid-window
                      :initarg :weight-grid-window
		      :accessor weight-grid-window
		      :type weight-grid-window)
     (exit-button     :initform (make-instance 'push-button :label "Exit")
		      :initarg :exit-button
		      :accessor exit-button
		      :type push-button)
     (help-button     :initform (make-instance 'help-button
				  :technical (add-path "technical-weight-help" *hoppath*)
				  :general (add-path "general-weight-help" *hoppath*)
				  :subject "Help for Weight-Window")
		      :initarg :help-button
		      :accessor help-button
		      :type help-button)
     (reset-button    :initarg :reset-button
		      :accessor reset-button
		      :initform (make-instance 'push-button :label "Reset")
		      :type push-button)))

(defmethod initialize-instance :after ((ww weight-window) &key)
  (setf (weight-grid-window ww)
    (make-instance 'weight-grid-window
      :parent ww
      :left 5
      :bottom 5
      :width (- (height ww) 30)
      :height (- (height ww) 30)
      :title "Weights"
      :connections (connections (hopfield-network ww))))
  (set-button (weight-button ww) ww 
	      :left (+ (width (weight-grid-window ww)) (floor (/ (- (width ww) (width (weight-grid-window ww))) 3)))
	      :bottom (floor (* 2 (/ (height ww) 3))))
  (set-button (help-button ww) ww 
	      :left (+ (width (weight-grid-window ww)) 20)
	      :bottom (bottom (weight-grid-window ww)))
	      
  (set-button (reset-button ww) ww 
	      :left (+ (width (weight-grid-window ww)) (floor (/ (- (width ww) (width (weight-grid-window ww))) 3)))
	      :bottom (floor (/ (height ww) 3))
	      :action `(lambda () (reset (hopfield-network ,ww))
			       (reset-button (reset-button ,ww))))
  (set-button (exit-button ww) ww 
	      :left (+ (width (weight-grid-window ww)) (* 2 (floor (/ (- (width ww) (width (weight-grid-window ww))) 3)))) 
	      :bottom (bottom (weight-grid-window ww))
	      :action `(lambda nil (exit (hopfield-network ,ww)))))

(defmethod renew-display ((ww weight-window))
  (setf (weight-grid-window ww)
    (make-instance 'weight-grid-window
      :parent ww
      :left 5
      :bottom 5
      :width (- (height ww) 30)
      :height (- (height ww) 30)
      :title "Weights"
      :connections (connections (hopfield-network ww))))
  (setf (button-value (weight-button ww)) 0))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; weight-grid-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	 

(defclass weight-grid-window (grid-window)
	  ((connections :initarg :connections
			:accessor connections
			:type list)))

    
(defmethod initialize-instance :after ((ww weight-grid-window) &key)
  (let ((size (size (hopfield-network (parent ww))))
	(l (connections ww)))
    (loop for a from 0 to (- size 2)
	do (loop for b from a to (- size 2)
	       do (progn 
			 (setf (width (radio-button (first l))) (floor (/ (width ww) (- size 1))))
			 ;(if *debug* (format t "set width, a: ~a, b: ~a~%" a b))
			 (setf (height (radio-button (first l))) (floor (/ (width ww) (- size 1))))
			 ;(if *debug* (format t "set height"))
			 (setf (action (radio-button (first l))) 
			   `(lambda () 
			      ;(if *debug* (format t "executing the action NOW~%"))
			      (setf (button-value (weight-button (parent ,ww)))
				(weight ,(radio-button (first l))))))
			 ;(if *debug* (format t "set action"))
			 (set-button (radio-button (first l)) ww 
			      :bottom (* a (floor (/ (width ww) (- size 1))))
			      :left (* b (floor (/ (width ww) (- size 1)))))
			 ;(if *debug* (format t "set-button"))
			 (setf l (cdr l)))))))
				 




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; radio-button-with-index
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;			  

(defclass radio-button-with-index (radio-button)
	  ((x :initarg :x
	      :accessor x
	      :type integer)))


(defmethod initialize-instance :after ((rb radio-button-with-index) &key)
  (setf (label rb) ""))


    
(defmethod black ((b radio-button-with-index))
  ;(if *debug* (format t "black~%"))
  (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
				      (- (width b) 3) (- (height b) 3)))

(defmethod white ((b radio-button-with-index))
  ;(if *debug* (format t "white~%"))
  (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
				    (- (width b) 3) (- (height b) 3) :color white))



(defmethod (setf status) :after (stat (b radio-button-with-index))
  ;(if *debug* (format t "set the status to: ~a~%" stat))
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; radio-button-for-activations-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass radio-button-for-activations-window (radio-button-with-index) 
	  ())

(defmethod set-button ((b radio-button-for-activations-window) display &key
		       (left 0) (bottom 0))
  (when (and display (status display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (setf (display b) display)
    (setf bottom (bottom b)) (setf left (left b))
    (draw-rectangle display left bottom
		    (width b) (height b))
    ;If the status is true, draw black radio-button
    (if (status b) (draw-filled-rectangle display (+ left 2) (+ bottom 2)
					  (- (width b) 3) (- (height b) 3)))
    (setf (region b) (make-active-region display :left left :bottom bottom
					 :width (width b) :height (height b)))
    (add-active-region-method (region b) ':left-button-down :after
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (mp:process-run-function (write-to-string (label b)) #'gin::button-call (action b)))))))

(defmethod (setf status) (stat (b radio-button-for-activations-window))
  (cond (stat 
	 (black b)
	 (setf (slot-value b 'status) t))
	(t 
	 (white b)
	 (setf (slot-value b 'status) nil))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; radio-button-for-weight-window
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		


(defclass radio-button-for-weight-window (radio-button-with-index) 
	  ((weight :initarg :weight
		   :accessor weight
		   :initform 0
		   :type float)))

(defmethod (setf weight) :after (weight (rb radio-button-for-weight-window))
  (if (= weight 0)
      (white rb)
    (progn (white rb)
	   (draw-square rb))))

(defmethod draw-square ((rb radio-button-for-weight-window))
  (let ((x (* (abs (weight rb)) (width rb) 5)))
    (if (<= (weight rb) 0)
	(when (> (width rb) x)
	  (draw-rectangle (display rb)
			  (floor (+ (left rb) (/ (- (width rb) x) 2)))
			  (floor (+ (bottom rb) (/ (- (width rb) x) 2)))
			  (floor x)
			  (floor x)))
      (if (< (width rb) x)
	    (black rb)
	(draw-filled-rectangle (display rb) 
			       (floor (+ (left rb) (/ (- (width rb) x) 2)))
			       (floor (+ (bottom rb) (/ (- (width rb) x) 2)))
			       (floor x)
			       (floor x))))))
			     

(defmethod toggle-button ((b radio-button-for-weight-window))
  (when (and (display b) (status (display b))
	     (equal (cw:active-region-status (region b)) :active))
    (black b)
    (white b)
    (draw-square b (weight b))
    (if (action b)
	(mp:process-run-function (write-to-string (label b)) #'gin::button-call (action b)))))


(defmethod set-button ((b radio-button-for-weight-window) display &key
		      (left 0) 
		      (bottom 0)
		      (action nil))
		      
  (when (and display (status display))
    ;(if *debug* (format t "~%set-button (~A radio-button) ~A ..." b display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (if action
	(setf (action b) action)
      (setf action (action b)))
    (setf (display b) display)
    (setf bottom (bottom b)) (setf left (left b))
    (draw-rectangle display left bottom
		    (width b) (height b))
    
    
    (setf (region b) (make-active-region display :left left :bottom bottom
					 :width (width b) :height (height b)))
    
    (add-active-region-method (region b) ':left-button-down :after
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (mp:process-run-function (write-to-string (label b)) #'gin::button-call (action b)))))
    ))
	 








		
			   
				       
     


;;;=========================================================
;;;  TEST-GROUND
;;;=========================================================


