;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:PAIL-LIB; Base:10; -*-
;;; ***********************************************************************
;;;
;;;                       EXPLANATION BASED LEARNING BROWSER
;;;
;;; ***********************************************************************
;;;
;;; Filename:   tms-browser-specif.cl
;;; Short Desc: Specification for JTMS browsers.
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   10.7.91 15:00:01 Dean ALLEMANG & Fatma FEKIH-AHMED
;;; Author:     Dean ALLEMANG
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------

;;; =======================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================
 
;;; DESCRIPTION
;;; -----------------------------------------------------------------------
;;; Specializes the general browser class for use by EBG.  This
;;; includes defining CLOS objects to correspond to the TMS objects
;;; provided by Lausanne.
;;; -----------------------------------------------------------------------
 

(in-package :pail-lib)

(eval-when (load compile eval)
  (export '(jtms-browser nmjtms-browser
	    all-tms-trees construct-just-tree)))


;;; =======================================================================
;;; CLASSES AND STRUCTURES - Definitions and Access Functions
;;; =======================================================================


;;; -----------------------------------------------------------------------


(defclass tms-browser (browser)
	  ((left-menu :initarg left-menu
		      :accessor left-menu
		      :type menu)
	   (title :initform "NMJTMS browser")
	   (help-window :initarg :help-window ; Only one help window per browser
			:initform nil
			:accessor help-window
			:type help-stream
			:documentation "attached help window for this browser")
	   ))

(defclass jtms-browser (tms-browser) ())

(defclass nmjtms-browser (tms-browser) ())

(defclass tms-tree (tree)
	  ((original-node :initarg :original-node
			  :initform nil
			  :accessor original-node)
	   (help-window  :initarg :help-window
			 :initform nil
			 :accessor help-window
			 :type pathname)))

(defclass just-tree (tree)
	  ((original-node :initarg original-node
			  :initform nil
			  :accessor original-node)))

;;; =======================================================
;;; END OF FILE
;;; =======================================================
