;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp; -*-
;;;
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   gtredefs.cl
;;; Short Desc: Definitions of close structures for gtre
;;; Version:    1.0
;;; Last Mod:   07.03.91 Dean ALLEMANG
;;; Status:     Experimental
;;; Author:     Dean ALLEMANG & Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; ------------------------------------------------------------------------
;;; Change History: 
;;; ------------------------------------------------------------------------
;;; At the writing of this code, GTRE is not in clos.  In order to
;;; integrate it into the pools, there has to be a type to convert the
;;; other rule sets to.  This defines those types, and the conversion.
;;; The types have no slots;  they are only here to index the
;;; conversion functions.
;;; -------------------------------------------------------
;;; RCS $Log$
;;; -------------------------------------------------------


(in-package :pail-lib)


(export '(rule name-part if-part then-part doc-part date-part
          print-rule
          make-rule 
          rule-set name-part rule-set-part
          print-rule-set
          get-rule
          sexpr-to-rule
          rule-to-sexpr
	  rule-instance preconditions conclusions bindings 
	  working-memory assertions trace-info
	  tre-example
          ))

(defclass tre-example ()
	  ((name-part  :accessor name-part
		       :initarg :name-part
		       :initform nil
		       :type string)
	   (rule-set   :accessor rule-set
		       :initarg :rule-set
		       :initform nil
		       :type list)
	   (assertions :accessor assertions
		       :initarg :assertions
		       :initform nil
		       :type list)
	   (contradiction :accessor contradiction
			  :initarg :contradiction
			  :initform nil
			  :type list)
	   (lisp-code :accessor lisp-code
		      :initarg :lisp-code
		      :initform nil
		      :type list)
	   ))


(defmethod change-type ((source rule-set) (dest tre-example))
  (let (res)
    (setq res (translate-rule-set source))
    (gtre::tre-init) 
    (mapcar #'(lambda (r)
		(eval r))
	    res)
    (make-instance 'tre-example :name-part (name-part source))))

(defmethod change-type ((source working-memory) (dest tre-example))
  (dolist (assert (assertions source))  (gtre::assert! assert))
  (make-instance 'tre-example :name-part (name-part source)))
  
;(defmethod change-type ((source ebg-example) (dest tre-example))
;  (make-instance 'tre-example
;    :rule-set (rule-set (change-type (rule-set source) dest))
;    :assertions (assertions (change-type (wm source) dest))))


(defmethod change-type ((source tre-example) (dest tre-example))
  (when (not (null (contradiction source)))
    (mapcar #'(lambda (r)
		(eval r))
	    (contradiction source)))
  (mapcar #'(lambda (r)
	      (eval r))
	  (assertions source))
  (mapcar #'(lambda (r)
	      (eval r))
	  (rule-set source))
  (mapcar #'(lambda (r)
	      (eval r))
	  (lisp-code source))
  source)



;;; =======================================================================
;;; * END OF FILE *
;;; =======================================================================
