;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:RULES; Base:10; -*-
;;; ************************************************************************
;;; WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   obj-forw
;;; Short Desc: WIN-SHELL - a tiny shell from the WINSTON-HORN book
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:    5.11.90 15:00:00 SK
;;; Author:     WINSTON, typed in: Hauser-Fischer
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; ------------------------------------------------------------------------
;;; Change History:
;;; HF  11.11.87  first code, debugged
;;; SK  16.10.89  improved
;;; SK   5.11.90  some pail standards applied
;;; DTA 29.5.91  Changed to CLOS 
;;; ------------------------------------------------------------------------
;;;
;;; DESCRIPTION
;;; -----------
;;; forward-chaining functions
;;; ------------------------------------------------------------------------
 
(in-package :rules)

(defvar *trace-chaining*  t)
(defvar *trace-stream* t)
(defvar *reactive* nil)
(defvar *max-iterations* 50)
(defvar *stop-rules* nil)



(defun combine-streams (s1 s2) (append s1 s2))
 
(defun add-to-stream (e s) (append s (list e)))
 
(defun first-of-stream (s) (car s))
 
(defun rest-of-stream (s) (cdr s))
 
(defun empty-stream-p (s) (null s))
 
(defun make-empty-stream () nil)
 
#| (defun match (p d assignments)
  (prog (answer)
    (setq answer (unify (replace-pattern-variables p assignments)
			(replace-pattern-variables d assignments)))
    (return (cond ((equal answer 'pail-lib::fail) nil)
		  ((null answer)
		   (cond
		    ((null assignments) t)
		    (t assignments)))
		  (t (append assignments answer)))))) |#

 

(defun match (p d assignments)
  (prog (answer)
    (setq answer (unify p d assignments))
    (return (cond ((equal answer 'unify::fail) nil)
		  ((null answer)
		   (cond
		    ((null assignments) t)
		    (t assignments)))
		  (t answer)))))


(defun replace-pattern-variables (s a-list)

  ;;replace pattern-variables whenever they exist.

  (cond ((null s) nil)
	((eq t a-list)  s)
        (t (apply-sub s a-list))))

(defmethod filter-assertions (pattern initial-a-list (wm working-memory))

   (cond
     ((equal (string-upcase (symbol-name (car pattern))) "LISP")
					;"LISP" at the beginning of an antecedent in-
					;dicates that this antecedent is to be eva-
					;luated directly, that is, it is not to be 
					;matched to any assertions. Prior to eva-
					;luation, replace-pattern-variables
					;replaces   all the pattern
					;variables by their values.
      
      (cond ((rule-eval (replace-pattern-variables (cdr pattern)
                                   initial-a-list))
             (list initial-a-list))
            (t nil)))
     ((equal (string-upcase (symbol-name (car pattern))) "NOT")
      (if (loop for assertion in (assertions wm) always
		(null (match (cadr pattern)
                                   assertion
                                   initial-a-list))
	    )
	  (setq a-list-stream (list initial-a-list))))
		  
     (t (do ((assertions		; var1
                 (assertions wm)              ; initial value 1
                 (cdr assertions))            ; update form 1
             (a-list-stream                   ; var2
                 (make-empty-stream)))        ; initial value 2
            ((null assertions) a-list-stream) ;termination test 
          (let ((new-a-list (match pattern    ;do-body
                                   (car assertions)
                                   initial-a-list)))
            (cond (new-a-list                 ;test T?
                   (setq a-list-stream        ;add to assertions!?
                         (add-to-stream new-a-list
                                        a-list-stream)))))))))

(defun rule-eval (s)  (if (or (member '*unbounditem* s) (has-var s)) nil (eval s)))

 
 
(defmethod filter-a-list-stream (pattern a-list-stream (wm working-memory))
   (cond ((empty-stream-p a-list-stream) (make-empty-stream))
        (t  (combine-streams
            (filter-assertions pattern
                               (first-of-stream a-list-stream) wm)
            (filter-a-list-stream pattern
                                  (rest-of-stream a-list-stream) wm)))))
 
(defmethod cascade-through-patterns (patterns a-list-stream (wm working-memory))
  (cascade-through-patterns-reverse (reverse patterns) a-list-stream wm))

 
(defmethod cascade-through-patterns-reverse (patterns a-list-stream (wm working-memory))
 
   (cond ((null patterns) a-list-stream)
         (t (filter-a-list-stream
                 (car patterns)
                 (cascade-through-patterns-reverse
                         (cdr patterns)
                         a-list-stream
			 wm)
		 wm))))
 
 
 
(defmethod use-rule ((rule rule) (wm working-memory) &optional (start-stream (make-empty-stream)))
  (cond (*trace-chaining* 
         (format-display *trace-stream* "considering new rule ~a"
                 (name-part rule)))) ;SK
  (setq used-rule-a-list-stream  (make-empty-stream))
  (let* ((rule-name (name-part rule))
         (if-list (if-part rule))
         (then-list (if (eq (car (then-part rule)) 'dump::and)
			(cdr (then-part rule))
		      (list (then-part rule))))
         (a-list-stream (cascade-through-patterns
                         if-list
                         (list start-stream)
			 wm))
         (action-stream (feed-to-actions rule-name
                                         then-list
                                         a-list-stream
					 wm)))
    (cond ((not (empty-stream-p used-rule-a-list-stream))
           (feed-to-rules-used rule
                               if-list
                               then-list
                               used-rule-a-list-stream
			       wm)
           t))))
 
 
(defmethod feed-to-rules-used (rule if-list
			       then-list a-list-stream (wm working-memory))
  (let ((ruleis (list (cons t t))))
    (cond ((empty-stream-p a-list-stream) t)
	  (t (loop for alist in a-list-stream
		 do (setf (trace-info wm)
		      (cons (if (assoc alist ruleis)
				(cdr (assoc alist ruleis))
			      (let ((answer (make-instance 'rule-instance
					      :rule rule
					      :bindings alist
					      :preconditions (replace-pattern-variables
							      if-list
							      alist)
					      :conclusions (replace-pattern-variables
							    then-list
							    alist))))
				(setf ruleis (acons alist  answer ruleis))
				answer))
			    (trace-info wm))))
	     ))))
 
 
 
(defun lispexpand (expr)
  (cond
   ((atom expr) expr)
   ((equal (string-upcase (format nil "~a" (car expr))) "LISP")
    (eval (cdr expr)))
   (t (loop for item in expr collect (lispexpand item)))))


(defmethod spread-through-actions (rule-name actions a-list (wm working-memory))
 
  (do ((actions
	actions
	(cdr actions))
       (action-stream
	(make-empty-stream)))
      ((null actions) action-stream)
    (let ((action (lispexpand (replace-pattern-variables
			       (car actions)
			       a-list))))
 
      (cond ((equal (string-upcase (symbol-name (car action))) "LISP")
	     (eval (cdr action)))
	    ((remember action wm)
	     (setq used-rule-a-list-stream
	       (add-to-stream a-list
			      used-rule-a-list-stream))
	     (setq action-stream
	       (add-to-stream action action-stream))

	     (cond (*trace-chaining*
		    (progn (format-display *trace-stream* "rule ~a asserts ~a"
					   rule-name action)
			   ))
		   ))))))


(defun best-of-stream (a-list-stream)
  (first-of-stream a-list-stream))

(defmethod feed-to-actions (rule-name actions a-list-stream (wm working-memory))
 
   (cond ((empty-stream-p a-list-stream) (make-empty-stream))
         (*reactive* (spread-through-actions rule-name
                                    actions
                                    (best-of-stream a-list-stream)
				    wm))
	  (t (combine-streams
            (spread-through-actions rule-name
                                    actions
                                    (first-of-stream a-list-stream)
				    wm)
            (feed-to-actions rule-name
                             actions
                             (rest-of-stream a-list-stream)
			     wm)))))
 
 
#| (defun replace-pattern-variables (s a-list)
 
  (cond ((null s) nil)
        ((and (not (atom s))
              (equal (car s) '%%))
         s)
        ((atom s) s)
        ((equal (car s) '<)
         (cadr (assoc (pattern-variable s) a-list)))
        (t (cons (replace-pattern-variables (car s) a-list)
                 (replace-pattern-variables (cdr s) a-list))))) |#
 
 

#| (defun replace-pattern-variables (s a-list)

  ;replace pattern-variables whenever they exist.

  (cond ((null s) nil)
	((eq t a-list)  s)
        ((variablep s)
         (cond ((assoc  s a-list)
                (cadr (assoc  s a-list)))
               (t s)))
	((atom s) s)
        (t (cons (replace-pattern-variables (car s) a-list)
                 (replace-pattern-variables (cdr s) a-list))))) |#


(defmethod remember (new (wm working-memory))
 
  (cond ((member new (assertions wm) :test 'equal) nil)
        (t (setf (assertions wm) (append (assertions wm) (list new)))
           new)))


(defmethod forward-chain ((ruleset rule-set) (wm table))
  (forward-chain  ruleset (change-type wm (make-instance 'working-memory))))
 
(defmethod forward-chain ((ruleset rule-set) (wm working-memory))

    ;Starts the whole forward-chaining process
    ;
    ;Steps through the rule-list until it finds a rule that produces a new
    ;assertion or new assertions, whereupon it again starts at the begin-
    ;ning of the rule list.
    ;FORWARD-CHAIN stops if it can't produce a new assertion with any rule
    ;in the entire list.

    ;Please note: 
    ;I believe that Winston/Horn have a mistake in this part of the listing.
    ;They have the CDR RULES-TO-TRY expression in the first part of the DO
    ;statement, i.e. they added an UPDATE FORM 1 to the parameter 1 and 
    ;initial value 1. That way the CDR will be executed every time the 
    ;DO-loop is run. This CDR, however, also effects their SETQ RULES-TO-TRY
    ;RULES which restores RULES-TO-TRY to its full amount of rules. Since
    ;CDR is applied to RULES-TO-TRY before the DO-body is executed, the
    ;first rule in RULES will never be used in RULES-TO-TRY because CDR cuts
    ;it off immediately after RULES-TO-TRY is restored to RULES. Thus the
    ;first rule in RULES is active only during the very first pass of the
    ;DO-loop, namely when RULES-TO-TRY has its initial value 1.  -HF?
;********************************
; Winston/Horn's (faulty) code...
;******************************** 
   (let (iterations)
     (setf *stop-rules* nil)
     (setf (trace-info wm) nil		;initializes RULES-USED
         *chaining-type* 'forward            ;sets chaining type as a trace-flag
	 last-two-facts-to-prove nil) 	     ;initializes LAST-TWO-FACTS-TO-
	                                     ; PROVE, a variable that is 
					     ; needed to prevent circular
					     ; backward-chaining. It has a
					     ; value here for the case that
					     ; you want to backward-chain
					     ; with BACKWARD and use the
					     ; RULES-USED produced with
					     ; FORWARD-CHAIN. LAST-TWO-FACTS-
					     ; TO-PROVE can't be initialized
					     ; by BACKWARD, only by BACKWARD-
					     ; CHAIN, and in there RULES-USED
					     ; is initialized to NIL.

   (setf iterations 0)
   (do ((rules-to-try			;parameter 1
         (rule-set-part ruleset))	;initial value 1
        (progress-made nil))		;parameter and initial value 2
       ((or (null rules-to-try)
	    *stop-rules*) progress-made)		;termination test, return form
					;DO-body:
     (prog1 (cond ((use-rule (car rules-to-try) wm) ;if USE-RULE with the first rule
		   (setq rules-to-try (rule-set-part ruleset)) ; in the list produces a result,
		   (setq progress-made t)) ; start over with all of the
					; rules.
		  (t (setq rules-to-try	;if USE-RULE fails, try the next
		       (cdr rules-to-try)))) ; rule in RULES-TO-TRY by CDRing
       (setf iterations (1+ iterations)))
     )
 			                     ; the RULES-TO-TRY list.
   (format-display *trace-stream* "FORWARD-CHAIN finished: no more rules to try")))


;---------------------------------------------------------------------------

(defun fc ()                           ;If FORWARD-CHAIN is too long to
   (forward-chain))                    ; to type, use FC.

;---------------------------------------------------------------------------

 

(defmethod how (fact (wm working-memory))
 
  (cond ((equal (car fact) 'LISP) (format-display *trace-stream* "~a evaluated by Lisp." (cdr fact)) t)
	(t (how1 fact (trace-info wm) nil wm))))
 
(defmethod how1 (fact possibilities success-switch (wm working-memory))
  (cond ((null possibilities)
         (cond (success-switch t)
               ((recall fact wm)
                (format-display *trace-stream* "fact ~a was given in ASSERTIONS" fact) t)
               (t (format-display *trace-stream* "fact ~a is not established" fact) nil)))
        ((member fact (conclusions (car possibilities))
                 :test 'equal)
         (format-display *trace-stream* "fact ~a deduced by" fact)
         (format-display *trace-stream* "rule ~a " (rule (car possibilities)))
         (mapcar #'(lambda (a)
                     (format-display *trace-stream* "       ~a" a))
                 (preconditions (car possibilities)))
         (do ((fact (preconditions (car possibilities)) (cdr fact))) ((null fact) t) (how (car fact) wm))
         (how1 fact (cdr possibilities) t wm))
        (t (how1 fact
                 (cdr possibilities)
                 success-switch
		 wm))))
 
 
(defmethod why (fact (wm working-memory))
 
   (why1 fact (trace-info wm) nil))
 
(defun why1 (fact possibilities success-switch)
 
  (cond ((null possibilities)
         (cond (success-switch t)
               (t (format-display *trace-stream* "~a was not used" fact)
                  nil)))
        ((member fact (cadr (car possibilities))
                 :test 'equal)
         (format-display *trace-stream* "~a is needed to show:" fact)
         (mapcar #'(lambda (a)
                     (format-display *trace-stream* "       ~a" a))
                 (car (cddr (car possibilities))))
         (why1 fact (cdr possibilities) t))
        (t (why1 fact
                 (cdr possibilities)
                 success-switch))))
 

(defmethod recall (pattern (wm working-memory))
 
   (recall1 pattern (assertions wm)))
 
(defun recall1 (pattern assertions)
  (cond ((null assertions) nil)
        ((match pattern (car assertions) nil)
         (cons (car assertions)
               (recall1 pattern (cdr assertions))))
        (t (recall1 pattern (cdr assertions)))))
 


;;--------------------------------------------------------------------
;;
;; FUNCTIONS OF FORWARD
;;
;;--------------------------------------------------------------------


(defun inf-to-pre (ae)
  (cond ((or (atom ae)                 ;easy case first: AE is an atom
             (equal (car ae) 'quote))  ; or a quoted variable that isn't
         ae)                           ; to be evaluated.
        (t (inf-aux ae nil nil))))     ; else stack starts empty.


(defun inf-aux (ae operators operands)
  
   ;INF-AUX takes an AE expecting AE's first element to be an operand and the
   ;second to be an operator. The operand is sent to INF-TO-PRE while the 
   ;operator (plus the rest of AE, i.e. CDR AE) is sent to INF-ITER.
   
  (inf-iter (cdr ae)                     ;work on CDR after  
            operators
            (cons (inf-to-pre (car ae))  ; recursion on CAR
                  operands)))

(defun inf-iter (ae operators operands)
  (cond
       ((and (null ae)
             (null operators))
        (car operands))
       ((and ae
             (or (not (cdr ae))
                 (and (atom (car ae))
                      (not (weight (car ae))))
                 (not (atom (car ae))))
             (inf-iter (cons '* ae) operators operands)))
       ((and (not (null ae))
             (or (null operators)
                 (> (weight (car ae))
                    (weight (car operators)))))
        (inf-aux (cdr ae)
                 (cons (car ae) operators)
                 operands))
       (t (inf-iter ae
                    (cdr operators)
                    (cons (list (opcode (car operators))
                                (cadr operands)
                                (car operands))
                          (cddr operands))))))

(defun weight (operator) (get operator 'weight))
  ;defines the weight functions in the evaluation hierarchy.
        
        (setf (get ':=' weight) 0)
        (setf (get '~'  weight) 1)  ;my way of representing OR
        (setf (get '&'  weight) 2)  ;my way of representing AND
        (setf (get '='  weight) 3)  ;equal
        (setf (get '<>' weight) 3)  ;not equal
        (setf (get '><' weight) 3)  ;not equal
        (setf (get '/=' weight) 3)  ;not equal
        (setf (get '<'  weight) 3)   
        (setf (get '>'  weight) 3)
        (setf (get '+'  weight) 4)
        (setf (get '-'  weight) 4)
        (setf (get '*'  weight) 5)
        (setf (get '/'  weight) 5)
        (setf (get 'r' weight) 5)  ;remainder, i.e. modulo division
        (setf (get '**' weight) 6)  ;exponentiation
        
(defun opcode (operator) (get operator 'opcode))
  ;gets the appropriate LISP command (OPCODE) for the operator
        
        (setf (get ':= 'opcode) 'setq)
        (setf (get '~  'opcode) 'or)  
        (setf (get '&  'opcode) 'and)   
        (setf (get '=  'opcode) 'equal)      ;"=" only compares numbers!   
        (setf (get '<> 'opcode) 'string/=)   ;"/" would limit the operators
        (setf (get '>< 'opcode) 'string/=)   ;  to numbers
        (setf (get '/= 'opcode) 'string/=)  
        (setf (get '<  'opcode) '<)  
        (setf (get '>  'opcode) '>)     
        (setf (get '+  'opcode) '+)
        (setf (get '-  'opcode) '-)
        (setf (get '*  'opcode) '*)
        (setf (get '/  'opcode) '/)
        (setf (get 'r 'opcode) 'rem)         ;modulo division
        (setf (get '** 'opcode) 'expt)       ;exponentiation

;---------------------------------------------------------------------------
; end of file
;---------------------------------------------------------------------------

