;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rules-ex1.cl
;;; Short Desc: 1st demo of rule chaining
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - DTA
;;; Author:     DTA from TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================



(in-package :rules)


(defparameter *browse* nil)


;;; Load example data into the pool

(load-file-no-questions (add-path "rules-con1" (add-subdir *pail-path* "pool")))

(defun dialog-1 (text-disp rule-disp table-disp)
  (let ((ruleset (pool-find-object *pail-pool* "stackrules"))
	(wm (pool-find-object *pail-pool* "safe-to-stack-wm"))
	(*readable* t)
	)
    (format-display table-disp "~a" (assertions wm))
    (format-display rule-disp "~a" (print-rule-set ruleset nil))
    (format-display text-disp "In the Rules window is a set of rules")
    (format-display text-disp "describing when it is safe to stack one to")
    (format-display text-disp "stack one item on another Objects can be")
    (format-display text-disp "stacked on heavier objects.  There is also a")
    (format-display text-disp "rule for computing the weight of an object.")
    (format-display text-disp "~&In the table window is the current")
    (format-display text-disp "working memory.  Facts are listed as ")
    (format-display text-disp "attribute/object/value triples.")
    (when (wait)
      (format-display text-disp "~%~%~%Now we run the rule set on the")
      (format-display text-disp "data in the working memory.")
      (format-display text-disp "The forward chainer draws all")
      (format-display text-disp "possible conclusions.~%")
      (setf *trace-stream* *verbose-disp*)
      (rules::forward-chain ruleset wm)

      
      
      
      (when (wait)
	
	(format-display text-disp "~%We can ask the rule system to")
	(format-display text-disp "explain the finding")
	(format-display text-disp "~%(safe-to-stack book this-table)")
	(format-display text-disp "~%The explanation is in the form")
	(format-display text-disp "of a trace of the rule firings.")

	
	(setf *browse* (make-instance 'ebg-browser
		       :starting-tree (generate-explanation
				       '(dump::safe-to-stack dump::book dump::this-table)
				       wm)
		       :ruleset ruleset
		       :wm wm
		       :title "Rules:Explanation trace"
		       :left 500
		       :bottom 0))
	(setf (left *browse*) (- (width *root-window*) (width *browse*) 5))
	
	(when (wait) (format-display text-disp "~%End of demo."))
	(close-display (display *browse*))))))
;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
