;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rules-dialog.cl
;;; Short Desc: dialog handling for rules
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   5.6.91 - DTA
;;; Author:     Dean Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Taken from the original ID3-dialog.cl by TW
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rules)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *pause* nil)
(defvar *quit* nil)
(defvar *verbose-disp* nil)
(defvar *verbose* nil)
(setf *verbose* *verbose-default*)
(defvar *to-explain-button* nil)
(defvar *explain* nil)




(defun make-title (nr)
  (format nil "The ~:R Demo of RULES" nr))


(defvar *menu-button-wms* nil)

(make-editor-fcn rules-table-edit)


(defun start-forward-rules-dialog (&optional (from-button nil))
  (setf *verbose-disp* (make-instance 'scroll-display
                                     :title "Rules:Verbose Comments"
				     :width (round (width *root-window*) 3)
				     :height (round (height *root-window*) 3)
				     :borders 1
				     :active nil
				     :left (round (width *root-window*) 2)
				     :bottom (round (height *root-window*) 3)))

  (setf *verbose* *verbose-default*)
  
  (let* ((disp (make-instance 'rule-display :title "RULES:Main Window"
			     :width 300
			     :height 150
			     :borders 1
			     :left (+ (width pail-lib::*main-window*) 
			              (left pail-lib::*main-window*))
			     :bottom (bottom pail-lib::*main-window*)))
	 (menu-button (make-instance 'pop-up-button
			:label "Demos"
			:width 100))
	 (tool-button (make-instance 'push-button :label "Tool" :width 100))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (setf (help-button disp)
			(make-instance 'help-button
			:technical (add-path "forward-rules-desc.tec" *rulespath*)
			:general (add-path "forward-rules-desc.gen" *rulespath*)
			:subject "RULES")))
	 (menu (make-instance 'menu
		 :items (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button ,exit-button))
					   (make-title (1+ i)))
				     mlist))))
       		 :query "DEMOS")))

    (setf (menu menu-button) menu)

    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
  
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 45 :weight :bold))
    (write-display disp
		   "Forward Rules"
		   (/ (width disp) 10)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
 
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (close-display *verbose-disp*)
			   (close-display ,disp)
			   (close-display (technical-window ,help-button))
			   (close-display (general-window ,help-button))
			   (if ,from-button (reset-button ,from-button))))

    (set-button help-button disp :left 15 :bottom 15)
  

    (set-button menu-button disp 
		:left (/ (- (width disp) (width menu-button)) 2)
		:bottom (+ 20 (height help-button)))
    (set-button tool-button disp 
		:left (/ (- (width disp) (width tool-button)) 2)
		:bottom 15
		:action `(lambda ()
			   (start-rules-tool ,tool-button ,exit-button))
		)
    exit-button
    ))




(defun start-rules-tool (&optional (from-button nil) (exit-button nil))
  (setf *verbose* *verbose-default*)
  #| (setf *verbose-disp* (make-instance 'scroll-display
				     :title "Verbose Comments"
				     :width 480
				     :height 200
				     :borders 1
				     :active *verbose*
				     :left 500
				     :bottom 375)) |#
  
  (if *verbose* (activate-display *verbose-disp*))

  (setf *trace-stream* *verbose-disp*)
  (let* ((dispwidth 500)
	 (dispheight 250)
	 (disp (make-instance 'rule-display
		 :title "RULES: Main Window"
		 :width (min (width *root-window*) dispwidth)
		 :height (min (height *root-window*) dispheight)
		 :left (round (- (width *root-window*) (min (width *root-window*)
							    dispwidth)) 2)
		 :bottom (round (- (height *root-window*) (min (height *root-window*)
							       dispheight)) 2)))
	 
	 
	 (*default-font* (findfont (width disp) dispwidth 13))
	 (exit-button (make-instance 'push-button :label "Exit" :width (round (width disp) 6)))
	 (help-button (make-instance 'help-button
			:technical (add-path "forward-rules-desc.tec" *rulespath*)
			:general (add-path "forward-rules-desc.gen" *rulespath*)
			:subject "Rules"))
	 (run-button (make-instance 'push-button :label "Run" :width (round (width disp) 6)))
	 (explain-button (make-instance 'push-button :label "Explain" :width (round (width disp) 6)))
	 (stop-button (make-instance 'push-button :label "Stop" :width (round (width disp) 6)))
	 (verb-button (make-instance 'radio-button :label "Verbose mode" :status *verbose*))
	 (reactive-button (make-instance 'radio-button :label "Reactive" :status *reactive*))
	 
	 (menu-button-rules (make-instance 'pool-button
			      :name "Rulesets:"
			      :value ""
			      :width (round (width disp) 3)
			      :target-class 'rules::rule-set
			      :pool *pail-pool*
			      :border t
			      :show-function #'(lambda (item) (documentation-print (print-rule-set item nil)))
			      ))
	 (menu-button-wms (make-instance 'pool-button
			    :name "Working memories:"
			    :pool *pail-pool*
			    :value ""
			    :width (round (width disp) 3)
			    :target-class 'rules::working-memory
			    :border t
			    ))
	 
	 (file-button (make-instance 'file-button))
	 )
    
    (setf (help-button disp) help-button)
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (width *pail-logo*) 15)
	       (- (height disp) (height *pail-logo*) 15))
    (set-button file-button disp
		:left (- (width disp) (width file-button) 7)
		:bottom (- (height disp) (height file-button) (cw:bitmap-height *pail-logo*) 20))
  
    (setf (font disp) (open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "A tool for dealing with rule sets"
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (open-font :courier :italic 45 :weight :bold))
    #| (write-display disp
		   "RULES"
		   (/ (width disp) 3)
		   (- (height disp) 40 (cw:font-ascent (font disp)))) |#
    (setf (font disp) *default-font*)
    
    
    (set-button help-button disp :left 15 :bottom 15)
    

    (set-button run-button disp 
		:left (+  (width help-button) 15 20)
		:bottom 15
		:action `(lambda nil
			   (setf (start-object (button-value ,menu-button-wms))
			     (change-type (start-object (button-value ,menu-button-wms)) (make-instance 'working-memory)))
			   (rules::forward-chain (start-object (button-value ,menu-button-rules)) (start-object (button-value ,menu-button-wms)))
			   (reset-button ,run-button)
			   ))

    (set-button explain-button disp 
		:left (+ (left run-button) (width run-button) 20)
		:bottom 15
		:action `(lambda nil
			   (let ((tree (generate-explanation
					(select-fact (start-object (button-value ,menu-button-wms)))
					(start-object (button-value ,menu-button-wms)))))
			     (when tree
			       (push (make-instance 'ebg-browser
				       :starting-tree tree
				       :ruleset (start-object (button-value ,menu-button-rules))
				       :wm (start-object (button-value ,menu-button-wms))
				       )
				     (eblist ,disp))))
			   (reset-button ,explain-button)
			   ))

    (set-button stop-button disp 
		:left (+ (left explain-button) (width explain-button) 20)
		:bottom 15
		:action #'(lambda nil
			   (setf rules::*stop-rules* t)
			   (reset-button stop-button)
			   ))

    
  
    (set-button menu-button-rules disp 
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom 55

		)
    
    (set-button menu-button-wms disp 
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 55 (height menu-button-rules))

		)
    (setf *menu-button-wms*  menu-button-wms)
    #| (set-button *to-explain-button* disp
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 55 (* 2 (height menu-button-rules)))
		) |#

    (set-button verb-button disp
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 15 (bottom *menu-button-wms*) (height *menu-button-wms*))
		:action #'(lambda nil (setf *verbose* (not *verbose*))
				  (if *verbose* (activate-display *verbose-disp*)
				    (deactivate-display *verbose-disp*))))
    
    (set-button reactive-button disp
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 15 (bottom verb-button) )
		:action #'(lambda nil (setf *reactive* (not *reactive*))
				  ))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (deactivate-display *verbose-disp*)
			   (close-display ,disp)
			   (if ,from-button (reset-button ,from-button))))
    ))


(defmethod select-fact (other) (declare (ignore other)) nil)

(defmethod select-fact ((wm working-memory) )
  (cond ((not (assertions  wm)) (display-error "No items are in the pool"))
	(t (let* ((done nil)
		  (font (findfont 1152 (width *root-window*) 10))
		  (longest (loop for item in (assertions  wm)
			       maximize (font-string-width font (format nil "~a" item))))
		  (width (min (+ longest 10) (round (* 2 (width *root-window*)) 3)))
		  (disp (make-instance 'display
			  :left (truncate (width *root-window*) 10)
			  :bottom (truncate (height *root-window*) 4)
			  :height (+ (font-character-height *default-font*) 155)
			  :width (+ width 180)
			  :title "Choose item to explain:"
			  :font font))
		  (abort-button (make-instance 'push-button :label "Cancel" :width 90 :font font))
		  (done-button (make-instance 'push-button :label "Explain" :width 90 :font font))
		  (maxl (round width (font-string-width font "M")))
		  (*print-pretty* nil)
		  (selection (make-instance 'select-button
			       :label "Proven facts"
			       :height 150
			       :width width
			       :font font
			       :items (loop for ass in (assertions  wm)
					  collect (let ((label (format nil "~a" ass)))
						    (subseq label
							  0 (min maxl (length label)))))
			       :exclusive t
			       :action #'(lambda nil nil)
			       ))
		  answer)
	     (set-button abort-button disp :left (+ width 45) :bottom 5
			 :action #'(lambda nil (setf done t)))
	     (set-button done-button disp
			 :left (+ width 45)
			 :bottom (+ (height abort-button) 10)
			 :action #'(lambda nil
				     (loop for sb in (items selection)
					 as ass in (assertions  wm) do
					   (if (status sb) (setq answer ass)))
				     (setf done t)
				     ))
	     
	     (set-button selection disp)
	     (mp::process-wait  "find fact" #'(lambda () done))
	     (close-display disp)
	     answer
	     ))
	))









(defun read-explain () (let ((old-package *package*))
			 
			 (setf *explain*
			   (intern-all (read-from-string (button-value *to-explain-button*) nil) :dump)
			   
			   )))


(defun rectify-string (s) (if (stringp s) s (symbol-name s)))



(defun auto-handler (nr parent start-button cont-button exit-button verb-button)
  (let ((text-disp (make-instance 'scroll-display
				 :title "Comments"
				 :font (open-font-named "fixed")
				 :parent parent
				 :width 300
				 :height 110
				 :borders 1
				 :left 400
				 :bottom 55))
	(rule-disp (make-instance 'scroll-display
				 :title "Rules"
				 :font (open-font-named "fixed")
				 :width 480
				 :height 200
				 :borders 1
				 :left 10
				 :bottom 143))
	(table-disp (make-instance 'scroll-display
				  :title "Working Memory"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 200
				  :borders 1
				  :left 10
				  :bottom 375)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display rule-disp)
	       (close-display table-disp)
	       (close-display (technical-window *help-button*))
	       (close-display (general-window *help-button*))
	       (setf table-disp nil)
	       
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format (window text-disp) "~&~%[Press <Continue> Button]")
	  (sleep 1)
	  (mp:process-wait "wait-on-click" (function (lambda () (not pail::*pause-demo*))))
	  (if pail::*stop-demo* (setq *quit* t))
	  (software-push cont-button)
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      #| (when (not *verbose*)
	(toggle-button verb-button)
	) |#
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :rules)))
	(if fun-sym
	    (funcall fun-sym text-disp rule-disp table-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))


(defun store-display (disp)
  (declare (ignore disp)))


(defun demo (nr menu-button other-exit-button)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (let* ((dispwidth (min 500 (- (round (width *root-window*) 2) 10)))
	(dispheight (min 260 (round (height *root-window*) 2)))
	(*verbose* t)
	(disp (make-instance 'rule-display :title (concatenate 'string "Rules:" (make-title nr))
			    :width dispwidth
			    :height dispheight
			    :borders 1
			    :left (- (width *root-window*) dispwidth 15)
			    :bottom (- (height *root-window*) dispheight 20)))
	(*default-font* (findfont (width *root-window*) 1140 13))
	(exit-button (make-instance 'push-button :label "Exit" :width (round (width disp) 5)))
	
	(start-button (make-instance 'push-button :label "Start" :width (round (width disp) 5)))
	(cont-button (make-instance 'push-button :label "Continue" :width (round (width disp) 5)))
	(verb (make-instance 'radio-button :label "Verbose Mode"
			     :status *verbose*
			     :action 
			     '(lambda ()
			       (if *verbose*
				   (progn
				     (setf *verbose* nil)
				     (deactivate-display *verbose-disp*))
				 (progn
				   (setf *verbose* *verbose-disp*)
				   (activate-display *verbose-disp*))))))
	
	
	)

    	; make sure that default is set
    
;    (print *verbose*)
    (if *verbose*
	(progn (activate-display *verbose-disp*)
	       (setf *verbose* *verbose-disp*))
      (deactivate-display *verbose-disp*))
    (setf *help-button* (setf (help-button disp)
			  (make-instance 'help-button
			    :width (round (width disp) 5)
			    :subject (concatenate 'string "Rules:" (make-title nr))
			    :technical (add-path
					"demo-desc.tec"
					*rulespath*)
			    :general (add-path
				      (concatenate 'string
					"demo" (write-to-string nr) "-desc.gen")
				      *rulespath*) )))
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (setf *quit* t)
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)
			   (close-display ,disp)
			   (close-display (technical-window *help-button*))
			   (close-display (general-window *help-button*))
			   (deactivate-display *verbose-disp*)))

    (set-button *help-button* disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(round (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
;		    (disable-button exit-button)
		    (dialog-handler nr disp start-button cont-button exit-button verb)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (round (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
;		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    (set-button verb disp :left (round (width disp) 4) :bottom (- (height disp) 50))
    ))


(defun dialog-handler (nr parent start-button cont-button exit-button verb-button)
  (let* ((*default-font* (findfont (width *root-window*) 1140 13))
	(text-disp (make-instance 'scroll-display
				 :title "Comments"
				 :font (findfont (width *root-window*) 1140 10)
				 :parent parent
				 :width (- (width parent) 10)
				 :height (round (height parent) 2)
				 :borders 1
				 :left 5
				 :bottom 50))
	(rule-disp (make-instance 'scroll-display
				 :title "Rules"
				 :font *default-font*
				 :width (- (round (width *root-window*) 2) 10)
				 :height (- (round (height *root-window*) 2) 20)
				 :borders 1
				 :left 10
				 :bottom 0))
	(table-disp (make-instance 'scroll-display
				  :title "Working Memory"
				  :font *default-font*
				  :width (- (round (width *root-window*) 2) 10)
				  :height (- (round (height *root-window*) 2) 35)
				  :borders 1
				  :left 10
				  :bottom (+ (round (height *root-window*) 2) 10))))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display rule-disp)
	       (close-display table-disp)
	       (close-display (technical-window *help-button*))
	       (close-display (general-window *help-button*))
	       (setf table-disp nil)
	       
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format-display  text-disp "~&~%[Press <Continue> Button]")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      #| (when (not *verbose*)
	(toggle-button verb-button)
	) |#
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :rules)))
	(if fun-sym
	    (funcall fun-sym text-disp rule-disp table-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))


(defun auto-demo (nr )
  (let ((disp (make-instance 'display :title (concatenate 'string "Rules:" (make-title nr))
			    :width 800
			    :height 200
			    :borders 1
			    :left 115
			    :bottom 610))
	(exit-button (make-instance 'push-button :label "Exit" :width 180))
	
	(start-button (make-instance 'push-button :label "Start" :width 180))
	(cont-button (make-instance 'push-button :label "Continue" :width 180))
	(verb (make-instance 'radio-button :label "Verbose Mode"
			     :status *verbose*
			     :action 
			     '(lambda ()
			       (if *verbose*
				   (progn
				     (setf *verbose* nil)
				     (deactivate-display *verbose-disp*))
				 (progn
				   (setf *verbose* *verbose-disp*)
				   (activate-display *verbose-disp*))))))
	
	
	)

					; make sure that default is set
    
;    (print *verbose*)
    (if *verbose*
	(progn (activate-display *verbose-disp*)
	       (setf *verbose* *verbose-disp*))
      (deactivate-display *verbose-disp*))
    (setf *help-button* (make-instance 'help-button
			  :width 180
			  :subject (concatenate 'string "Rules:" (make-title nr))
			  :technical (add-path
				      "demo-desc.tec"
				      *rulespath*)
			  :general (add-path
				    (concatenate 'string
				      "demo" (write-to-string nr) "-desc.gen")
				    *rulespath*) ))
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (setf *quit* t)
			   (close-display ,disp)
			   (close-display (technical-window *help-button*))
			   (close-display (general-window *help-button*))
			   (deactivate-display *verbose-disp*)))

    (set-button *help-button* disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(round (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
					;		    (disable-button exit-button)
		    (auto-handler nr disp start-button cont-button exit-button verb)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (round (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
					;		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    (set-button verb disp :left (round (width disp) 4) :bottom 80)

    (setf pail::*stop-demo* nil)
    (software-push start-button)
    (software-push exit-button)
    
    ))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
