;;; -*- Mode: LISP; Package: EBG; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   ebg-ex
;;; Short Desc: An implementation of Mitchells EBG-Method
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   25.05.91 SK
;;; Author:     Stefan Keller 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; Languages:  - Macintosh Allegro Common Lisp (MCL Version 2.0)
;;;             - Sun Allegro Common Lisp (ACL Version 3.1.13.1)
;;; ------------------------------------------------------------------------
;;; Change History:
;;;
;;; ========================================================================


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail)


;;; ==========================================================================
;;; PARAMETERS
;;; ==========================================================================


(defparameter *rule-set*      "A member of 'rule-set")
(defparameter *rule-set1*     "A member of 'rule-set")
(defparameter *rule-set2*     "A member of 'rule-set")
(defparameter *gen-ebg-tree*  "A member of 'ebg-tree")
(defparameter *gen-ebg-tree1* "A member of 'ebg-tree")
(defparameter *gen-ebg-tree2* "A member of 'ebg-tree")


;;; ==========================================================================
;;; RULE-SETS
;;; ==========================================================================


(setf *rule-set1*
      (make-instance 'rule-set 
                     :name-part 'safe-to-stack-rule-set
                     :rule-set-part 
                     (list 
                      (make-rule 'rule-a
                                 :if '((volume ?p1 ?v1)
                                       (density ?p1 ?d1))
                                 :then '(weight ?p1 (LISP (* ?v1 ?d1))))
                      (make-rule 'rule-b
                                 :if '((weight ?p1 ?w1)
                                       (weight ?p2 ?w2)
                                       (LISP (< ?w1 ?w2)))
                                 :then '(lighter ?p1 ?p2))
                      (make-rule 'rule-c
                                 :if '((isa ?p1 table))
                                 :then '(weight ?p1 5))
                      (make-rule 'rule-e
                                 :if '((lighter ?p1 ?p2))
                                 :then '(safe-to-stack ?p1 ?p2))
                      (make-rule 'rule-f
                                 :if '((isa ?p1 endtable))
                                 :then '(isa ?p1 table))
                      )))

;;;This creates a symbol with the rule object
;;;It would be cleaner to defin an :after method of initialize-instance
;(dolist (rule (rule-set-part *rule-set*))
;  (set (name-part rule) rule))
;(defmethod initialize-instance :after ((rule rule) &key)
;  (set (name-part rule) rule))


(setf *rule-set* *rule-set1*)


;;; ==========================================================================
;;; GEN-EBG-TREES
;;; ==========================================================================


;;; ATTENTION: this ebg-tree is made by hand and takes just rules.
;;; In proof trees only single conclusions appear, so this implies a 
;;; restriction, that no rule can have multiple conclusions!
;;; A member of 'ebg-tree
(setf *gen-ebg-tree0*			
  (make-node :content (get-rule *rule-set* 'rule-e)
	     :descendants
	     (list 
	      (make-node :content (get-rule *rule-set* 'rule-b)
			 :descendants
			 (list 
			  (make-node :content (get-rule *rule-set* 'rule-a)
				     :descendants
				     (list (make-node :content nil
						      :fact '(volume ?p1 ?v1)
						      :descendants nil)
					   (make-node :content nil
						      :fact '(density ?p1 ?d1)
						      :descendants nil)))
			  (make-node :content (get-rule *rule-set* 'rule-c)
				     :descendants
				     (list (make-node :content nil
						      :fact '(isa ?p1 table)
						      :descendants nil)))
			  (make-node :content nil
				     :fact '(LISP (< ?w1 ?w2))
				     :descendants nil)))
	      )))

;;; Version without facts
;;; a member of 'ebg-tree
(setf *gen-ebg-tree1*			
  (make-node :content (get-rule *rule-set* 'rule-e)
	     :descendants
	     (list 
	      (make-node :content (get-rule *rule-set* 'rule-b)
			 :descendants
			 (list 
			  (make-node :content (get-rule *rule-set* 'rule-a)
				     :descendants nil)
			  (make-node :content (get-rule *rule-set* 'rule-c)
				     :descendants nil)))
	      )))

;;;--- Tests
(setf *gen-ebg-tree2* ;a member of 'ebg-tree
      (make-node 
       :content (get-rule *rule-set* 'rule-e)
       :descendants
       (list (make-node 
              :content (get-rule *rule-set* 'rule-b)
              :descendants 
              (list (make-node 
                     :content (get-rule *rule-set* 'rule-a)
                     :descendants 
                     (list (make-node :content (get-rule *rule-set* 'rule-f)
                                      :descendants nil)
                           (make-node :content (get-rule *rule-set* 'rule-f)
                                      :descendants nil) ))
                    (make-node 
                     :content (get-rule *rule-set* 'rule-c)
                     :descendants nil)
                    ))
             )))

#| ---------------------------------------------------------------------------
(print-object *gen-ebg-tree* t)
(print-tree *gen-ebg-tree*)
(print-ebg-tree *gen-ebg-tree*)
(print-object *rule-set* t)
(print-rule-set *rule-set*)
(rule-set-part *rule-set*)
(setf r (get-rule *rule-set* 'rule-a))
(if-part r)
--------------------------------------------------------------------------- |#


(setf *gen-ebg-tree* *gen-ebg-tree1*)


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================
