(in-package :csp)
(defvar *words*)
(defvar *current-schema*)



(defun set-numbers(schema)
  (setq *words* nil)
  (let ((next-int 1)(touched nil))
    (do ((row 1 (+ row 1)))
	((= row (1- (car (array-dimensions schema)))))
      (do ((col 1 (+ col 1)))
	  ((= col (1- (cadr (array-dimensions schema)))))
	(setq touched nil)
       ;; (format t "Faccio aref ~d ~d~%" row col)
	(if (and (not (eq '* (aref schema row  col)))
		 (eq '* (aref schema row (1- col)))
		 (not (eq '* (aref schema row (1+ col)))))
	    (progn (setq touched t) 
		   (push (new-word next-int 'across row col schema) *words*)
		   (setf (aref schema row col) next-int)))
	(if (and (not (eq '* (aref schema row  col)))
		 (eq '* (aref schema (1- row) col))
		 (not (eq '* (aref schema  (1+ row) col))))
	    (progn (setq touched t)
		   (push (new-word next-int 'down row col schema) *words*)
		   (setf (aref schema row  col) next-int)))
	(if touched 
	    (setq next-int (incf  next-int))))))   )
(defun show-schema (schema)
  (do ((col 1 (+ col 1)))
      ((= col (1- (cadr (array-dimensions schema)))))
    (format t "____"))
  (format t "_~%")
  (do ((row 1 (+ row 1)))
      ((= row (1- (car (array-dimensions schema)))))
    (do ((col 1 (+ col 1)))
	((= col (1- (cadr (array-dimensions schema)))))
      (cond ((eq '_  (aref schema row col))
	     (format t "|   "))
	    ((eq '*  (aref schema row col))
	     (format t "|***"))
	    (t (format t "|~3a" (aref schema row col)))))
    
    (format t "|~%")
    (do ((col 1 (+ col 1)))
	((= col (1- (cadr (array-dimensions schema)))))
      (format t "|___"))
    (format t "|~%")))
	

; ogni elemento attivo dello schema ne' una lista di 1 o 2 elementi
; rappresentanti parole. Ogni parola e' contraddistinta dalla lunghezza
; e dal tipo (down across)
; 
; Per ogni coppia di parole si verifica se esiste un incrocio
; in tal caso si genera il predicato di test corrispondente

;; word format: (number down/across length )

(defun new-word (num d-a row col schema)
  (let   ((l  (if (eq d-a 'across)
		  (compute-len-across row col schema)
		(compute-len-down row col schema))))
    (list num d-a l (cons row col))))

(defun compute-len-across (row col schema)
  (let  ((l 0))
    (do ((c col (+ c 1)))
	((eq (aref schema row c) '*) l)
      (incf l))))
    
  (defun compute-len-down (row col schema)
  (let  ((l 0))
    (do ((r row (+ r 1)))
	((eq (aref schema r col) '*) l)
      (incf l))))
   
(defun across-p (word)
  (eq (cadr word) 'across))
(defun column-of (word)(cdr (nth 3 word)))
(defun row-of (word)(car (nth 3 word)))
(defun length-of(word) (nth 2 word))
(defun all-positions (word)
  (let ((ps nil))
    (if (across-p word)
	(do ((c (column-of word) (+ c 1)))
	    ((eq (- c (column-of word)) (length-of word)) ps)
	  (push (cons (row-of word) c) ps))
      (do ((r (row-of word) (+ r 1)))
	    ((eq (- r (row-of word)) (length-of word)) ps)
	  (push (cons r (column-of word)) ps)))))
      
(defun crossing (word1 word2)
 (car  (intersection (all-positions word1)(all-positions word2) :test #'equal)))

(defun relative (pos word)
  (+ 1 (- (car pos)(row-of word))
     (- (cdr pos)(column-of word))))

(defun enumerate-crosses (wordlist)
  (if wordlist
      (let ((fw (car wordlist)))
	(mapcar #'(lambda (w) 
		    (let ((pos (crossing fw w)))
		      (if pos 
			  (progn 
			    (print (string-p2 fw w pos))
			     (print (string-p2 w fw pos))
			     (eval (read-from-string (string-p2 fw w pos)))
			    (eval (read-from-string (string-p2  w fw pos)))))))
		(cdr wordlist))
	(enumerate-crosses (cdr wordlist)))))

(defun generate-p2 (wordlist)
  (format nil "(defun p-2 (var1 value1 var2 value2)
     (cond~%~{~A~}~%))~%" (generate-cases wordlist nil)))
      
(defun generate-cases (wordlist stringlist)
  (if wordlist
      (let ((fw (car wordlist)))
	(mapcar
	 #'(lambda (w) 
	     (let ((pos (crossing fw w)))
	       (if pos (push  
			(format nil "~A~A" (cond-p2 fw w pos) (cond-p2 w fw pos))
			stringlist))))
	 (cdr wordlist))
	(generate-cases (cdr wordlist) stringlist))
    stringlist))

(defun cond-p2 (w1 w2 pos)
  (format nil "~A~A"
	  (format nil 
"        ((and (eq var1 '~A~A)(eq var2 '~A~A)) " (car w1)(cadr w1)(car w2)(cadr w2))
	  (format nil " (cross value1 ~A value2 ~A)) ~%" (relative pos w1) (relative pos w2))))  

(defun generate-p1 (words)
    (format nil "~A~A"
	    (format nil "(defun p-1 (var value)~%")
	    (cond-p1 words)))

(defun cond-p1(words)
    (format nil "   (cond ~%~{~A~}))"
		  (mapcar #'generate-case-p1 words)))
(defun generate-case-p1 (word)  
  (format nil "  ( (and (eq var '~A) (eq (length (string value)) ~a)))~%"
	  (variable-name word)
	  (length-of word)))



(defun all-crosses (word wordlist)
  (let ((neighbors nil))
    (dolist (w wordlist neighbors)
      (if (and (not (equal word w))
	       (crossing word w))
	  (push  (variable-name w) neighbors)))))
    
(defun variable-name (w)
  (atom-conc (list (format nil "~A" (car w)) (cadr w))))

(defun string-node (word)
  (format nil "~a" 
	  (append 
	   (list  (variable-name word) 'DICT)
	   (all-crosses word *words*))))
(defun net-definition ()
  (format nil
" (construct-network '(
~{~A~%~}))" (mapcar #'string-node *words*)))


(defun nth-char (n string)(nth (1- n) (coerce  string 'list )))
(defun cross (v1 n1 v2 n2)(eq (nth-char n1 v1)(nth-char n2 v2)))


(defun construct-network-from-crossw (schema)
  (setq *current-schema* schema)
  (set-numbers schema)
  (push (g-show-schema schema) *open-windows*)
  (message "Generating p-1 ...")
  (eval(read-from-string (generate-p1  *words*)))
  (message "Generating p-2 ...")
  (eval (read-from-string (generate-p2 *words*)))
  (message "Compiling p-1 ...")
  (compile 'p-1)
  (message "Compiling p-2 ...")
  (compile 'p-2) 
  (eval(read-from-string (net-definition))))
 
