;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-make.cl
;;; Short Desc: Compile & load code & documentation
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   25.12.92 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Build csp
;;;
(defpackage :csp  (:use :common-lisp :pail-lib :gin))
(in-package :csp)

(defvar *csp-path*)
(defparameter *libpath*(add-subdir *pail-path* "/pail-lib"))

(ensure-loaded (add-path *libpath* "size-indep-utils"))
(ensure-loaded (add-path *libpath* "sftw-push"))
(ensure-loaded (add-path *libpath* "file-browser"))
(setq *csp-path* (add-subdir *pail-path* "csp"))

(setq *csp-files* '("csp-dialog" "csp-adt" "csp1" "draw-net" "csp-interface" "csp-utils"
		    "csp-demo""csp-demo1""csp-demo2"))


(dolist (f *csp-files*)
  (ensure-loaded (add-path f *csp-path*)))
(setq gin::*default-display-border* 2)


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
