    (in-package :csp)

(defun but-h-pos (row b-h)
   (+ 5 (* row (+ 10 b-h))))
(defun but-w-pos (col b-w)
   (+ 10 (* col (+ 10 b-w))))

(defun init-flags () 
  (setq *domain-loaded* nil)
  (setq *open-display-nets* nil)
  (setq *open-displays-list* nil)
  (setq *graphics* nil)
  (setq *paused* nil)
  (setq *aborted* nil)
  (setq *csp-interface* t)
  (setq *stop-at-arc* nil)
  (setq *stop-at-sol* nil)
  (setq *stop-at-prop* nil)
  (setq *verbose* nil)  (setq *quiet1* t)
  (setq *queue* nil)
  (setq *all-distinct-values* nil)
  (setq *solutions* nil)
  (setq *main-network* nil)
  (setq *searching-network* nil)
  )

(defun init-csp-interface ()
  (init-sizes)
  (init-flags)
  (setq *exit-button*
    (make-instance 'push-button
      :width *but-width*  
      :height *but-height*
      :label "Exit"))
  
  (setq *pause-button*
    (make-instance 'push-button  
      :width *but-width* 
      :height *but-height*
      :label "Pause"))
  
  (setq *help-button*
    (make-instance 'help-button :label "Help" :font (my-findfont 13) :width (scaleh 70)
		   :subject "CSP Module"
		   :technical (add-path "csp-tool-tec.asc" *csp-path*)
		   :general (add-path "csp-tool-gen.asc" *csp-path*)))
  (setf (width *help-button*) *but-width* )
  (setf (height *help-button*)*but-height*)
    
  (setq *load-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Load"))
  
  (setq *edit-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Edit"))
  
  (setq *continue-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Continue"))
  
  (setq *clear-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Clear"))
  
  (setq *solutions-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Solutions"))
  
  (setq *run-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Run"))
  
  (setq *abort-button*
    (make-instance 'push-button
      :width *but-width* 
      :height *but-height* 
      :label "Abort"))
  
;;;----------- Radio buttons-------------
  (setq *adv-button*
    (make-instance 'radio-button
      :label "All Distinct Values"))
  
  (setq *stop-at-arc-button*
    (make-instance 'radio-button
      :label "Step arc consistency"))
  
  (setq *stop-at-prop-button*
    (make-instance 'radio-button
      :label "Stop after constraint prop. "))
  
  (setq *stop-at-sol-button*
    (make-instance 'radio-button
      :label "Stop at every solution "))
  
  (setq *graph-button*
    (make-instance 'radio-button
      :label "Graphics"))
  
  (setq *verbose-button*
    (make-instance 'radio-button
      :label "Verbose mode")))

(defun cspw()
  (init-csp-interface)
  (setf *csp-main-window* 
    (make-instance 'display      :title "CSP: main window"     
		   :left  *csp-mw-left*      :bottom *csp-mw-bottom*    
		   :width *csp-mw-width*      :height *csp-mw-height* ))
  (setf *out-win* 
    (make-instance 'scroll-display      :title "CSP: Standard Output"
		   :parent  *csp-main-window*       :left  *out-win-left*
		   :bottom *out-win-bottom*      :width *out-win-width*
		   :height *out-win-height*))
  (set-button *exit-button*  *csp-main-window* 
	      :left (but-w-pos 0 *but-width*)   
	      :bottom   (but-h-pos 0 *but-height*)
	      :action #'(lambda()(close-display *csp-main-window*)
			       (if (and *graphics* *main-network*)
				   (close-display (window *main-network*)))
			       (mapc '(lambda (n)
				       (close-display (window n)))
				     *open-display-nets*)
			       (setq  *execution-terminated* t)))
  (set-button *help-button*  *csp-main-window* 
	      :left (but-w-pos 5 *but-width*)    
	      :bottom   (but-h-pos 0 *but-height*))
  (set-button *load-button*  *csp-main-window* 
	      :left (but-w-pos 2 *but-width*)    
	      :bottom   (but-h-pos 0 *but-height*)
	      :action '(lambda nil (load-csp-domain)
			(reset-button *load-button*)))
  (set-button *edit-button*  *csp-main-window* 
	      :left (but-w-pos 3 *but-width*)    
	      :bottom   (but-h-pos 0 *but-height*)
	      :action '(lambda nil (edit-csp-domain)
			(reset-button *edit-button*)))
  (set-button *pause-button*  *csp-main-window* 
	      :left (but-w-pos 3 *but-width*)  
	      :bottom   (but-h-pos 1 *but-height*)
	      :action #'(lambda() 
			  (setf *paused* t)
			  (enable-button  *abort-button*)
			  (reset-button  *abort-button*)
			  (enable-button  *continue-button*)
			  (reset-button  *continue-button*)))
 

  (my-disable-button *pause-button*)

  (set-button *run-button*  *csp-main-window* 
	      :left (but-w-pos 0 *but-width*)  
	      :bottom   (but-h-pos 1 *but-height*)
	      :action '(lambda nil 
			(if *domain-loaded*
			    (run-csp)
			  (csp-not-loaded-warning))
			(reset-button  *run-button*)))
  (set-button *continue-button*  *csp-main-window* 
	      :left (but-w-pos 4 *but-width*)   
	      :bottom   (but-h-pos 1  *but-height*) 
	      :action '(lambda nil 
			(reset-button *abort-button*)
			(my-disable-button *abort-button*)
			(enable-button *pause-button*)
			(reset-button *pause-button*)
			(reset-button *continue-button*)
			(my-disable-button *continue-button*)
			
			(setf *paused* nil)))
  
  
  (my-disable-button *continue-button*)
  
  (set-button *abort-button*  *csp-main-window* 
	      :left (but-w-pos 5 *but-width*)   
	      :bottom   (but-h-pos 1  *but-height*)
	      :action '(lambda nil 
			(setf *aborted* t)
			))
			
  
  (my-disable-button *abort-button*)
	
  		
  (set-button *solutions-button*  *csp-main-window* 
	      :left (but-w-pos 1 *but-width*)   
	      :bottom   (but-h-pos 1  *but-height*)
	      :action '(lambda nil 
			(display-solutions)
			(reset-button *solutions-button*)))
  		
  (set-button *clear-button*  *csp-main-window* 
	      :left (but-w-pos 2 *but-width*)   
	      :bottom   (but-h-pos 1  *but-height*)
	      :action '(lambda nil 
			(clear-scroll *out-win* )
			(reset-button *clear-button*)))
  
  (set-button *stop-at-sol-button* *csp-main-window* 
	      :left (but-w-pos 1 *rd-but-width*)  
	      :bottom   (but-h-pos 3 *rd-but-height*)
	      :action '(lambda nil 
			(disable-button *stop-at-sol-button*)
			(setf *stop-at-sol* (status *stop-at-sol-button* ))
			(enable-button  *stop-at-sol-button*)))
  
  (set-button *stop-at-arc-button* *csp-main-window* 
	      :left (but-w-pos 1 *rd-but-width*)  
	      :bottom   (but-h-pos 4 *rd-but-height*)   
	      :action '(lambda nil 
			(disable-button *stop-at-arc-button*)
			(setf *stop-at-arc* (status *stop-at-arc-button* ))
			(enable-button  *stop-at-arc-button*)))
  
  (set-button *stop-at-prop-button* *csp-main-window* 
	      :left (but-w-pos 1 *rd-but-width*)  
	      :bottom   (but-h-pos 5 *rd-but-height*)
	      :action '(lambda nil 
			(disable-button *stop-at-prop-button*)
			(setf *stop-at-prop* (status *stop-at-prop-button* ))
			(enable-button  *stop-at-prop-button*)))
  (set-button *verbose-button* *csp-main-window* 
	      :left (but-w-pos 0 *rd-but-width*)  
	      :bottom   (but-h-pos 5 *rd-but-height*)
	      :action '(lambda nil 
			(disable-button  *verbose-button* )
			(setf *verbose*  (status *verbose-button*))
			(setf *quiet1* (not (status *verbose-button*)))
			
			(enable-button   *verbose-button* )))
  (set-button *adv-button* *csp-main-window* 
	      :left (but-w-pos 0 *rd-but-width*)  
	      :bottom   (but-h-pos 3 *rd-but-height*) 
	      :action '(lambda nil 
			(disable-button  *adv-button*)
			(setf *all-distinct-values* (status *adv-button*))
			(enable-button   *adv-button* )))
  
  (set-button *graph-button* *csp-main-window* 
	      :left (but-w-pos 0 *rd-but-width*)  
	      :bottom   (but-h-pos 4 *rd-but-height*)
	      :action '(lambda nil
			(graphics-on-off)))
  (if (not *domain-loaded*) (disable-button *graph-button*)))

;;;;-------------------------
;; Assumes that
;;    a network has been initialized in *main-network*
;;
(defun run-csp()
  (my-disable-button *load-button*)
  (my-disable-button *exit-button*)
  (when *graphics* 
    (if *open-display-nets* (mapcar '(lambda (net)
			     (close-display (window net))) *open-display-nets*))
    (when  *aborted* (close-display (window *main-network*))
	   (draw-graph *main-network*)))
  
  (setq *aborted* nil)
  (setq *paused* nil)
  (enable-button  *pause-button*)
  (reset-button  *pause-button*)
  (disable-button *graph-button*)
  (catch 'aborted (csp-main *main-network*))
  (reset-button *run-button*)
  (my-disable-button  *continue-button*)
  (reset-button  *pause-button*)
  (my-disable-button  *pause-button*)
  (reset-button  *abort-button*)
  (if (not (net-too-big))(enable-button *graph-button*))
  (my-disable-button  *abort-button*)
  (enable-button *load-button*)
 (enable-button *exit-button*)
			 
)


(defun my-disable-button (b)
  (disable-button b)
  (setf (status b) -1)) 

;;-----------------------------------
(defun graphics-on-off()  
  (setf *graphics* (status *graph-button* ))
  (format-display *out-win* "Graphics output ~a.~%"
		  (if *graphics* "on" "off"))
  (if *graphics* 
      (progn 
	(setq *gph-bottom* (+ 5 *csp-mw-bottom*))
	(setq *gph-left* (- *csp-mw-left* -14 (net-disp-width *main-network*)))
	(draw-graph *main-network*)
	)
    
    (progn
      (if *searching-network*
	  (close-display (window *searching-network*)))
      (close-display (window *main-network*))
      (mapcar '(lambda (net)
		(close-display (window net))) *open-display-nets*)
      (setq *aborted* nil)))
  (enable-button  *graph-button*))

;;-----------------------------------
(defun load-csp-domain ()
  (protect-display *csp-main-window* t)
  (if *graphics* (toggle-button *graph-button*))
  (disable-button *graph-button*)
  (let ((filename (choose-file-dialog 
		   :directory   (add-path *csp-path* "Untitled.csp") 
				 :button-string "LOAD"
				      :filter ".csp" :left 400 :bottom 200)))
    (cond ((null filename) nil)
	  ((not (terminates-with ".csp" filename))
	   (acknowledge-dialog "You must select a file terminating with .csp"))
	  (t (setq *domain-loaded* filename)
	     (message (format nil "Loading ~A: Please wait ..." filename))
	     (reset-custom-functions)
	     (if (safe-load filename)
		 (progn
		   (change-title-bar filename )
		   (set-radio-buttons-after-loading)
		   (if *main-network* 
		       (progn
			 (display *main-network*)
			 (possible-solutions-message)
			 (test-net-too-big)
			 (message (format nil "~A succesfully loaded." filename)))
		     (problems-during-loading filename)))
	       (problems-during-loading filename)))))
  (protect-display *csp-main-window* nil))

(defun safe-load (filename)
  (let ((result (safe-apply 'load (list filename))))
    (not (eq 'csp-error result) )))

(defun problems-during-loading(filename)
   (message
    (format nil
	    "**ERROR**: Problems with ~A:~% Main Network not initialized~%"
	    filename))
   (setq *domain-loaded* nil)
   (setf (title *csp-main-window*) (format nil "CSP: Main Window")))

(defun change-title-bar(filename)
  (setf (title *csp-main-window*) 
    (format nil "CSP: Main Window -- Current Input: ~A" filename)))

(defun test-net-too-big() 
  (if (net-too-big )
      (message "**Warning**: The Network is too big to enable Graphics")
    (enable-button *graph-button*)) ) 

;;------------------------------------------------------------
;; Editing Csp Domains
;;
(defun edit-csp-domain()
  (let ((filename 
	 (choose-new-file-dialog  :button-string "Edit"
			     :directory  (add-path *csp-path* "Untitled.csp")
				 :filter ".csp" :left 400 :bottom 200)))
    (cond ((null filename) nil)
	  ((not (terminates-with ".csp" filename))
	   (acknowledge-dialog "You must select a file terminating with .csp"))
	  (t(open-editor-window filename)))))
	    

(defun open-editor-window (filename)
  (user::run-shell-command
   (concatenate 'string "emacs "
		filename  )
		:wait nil))





;;-------------------------------------
;; To manage the stepper  **GIN**
;;----------------------------
    
(defun process-interrupts() 
 (if *paused* 
     (mp::process-wait "paused" '(lambda () (or *aborted* 
					     (not *paused*)))))
 (if *aborted*  (throw 'aborted 'aborted)))
  
(defun process-interrupts-for-stepper() 
   (enable-continue-button)
   (mp::process-wait "stepping" '(lambda ()(or *aborted*  (not *paused*))))
   (if *aborted*  (throw 'aborted 'aborted)))
    

(defun enable-continue-button()
  (when (or                       ;;---if  at least one stepping mode is enabled
       (status  *stop-at-sol-button*)
       (status  *stop-at-arc-button*)
       (status *stop-at-prop-button*))
    (if (not *paused*)
	(progn
	  (setf *paused* t)
	  (my-disable-button *pause-button*)
 	  (reset-button  *abort-button*)
	  (reset-button  *continue-button*)
	  (enable-button  *abort-button*)
	  (enable-button  *continue-button*)))))
	  
      
(defun csp-not-loaded-warning()
  (message
   (format nil 
"**Warning**: A CSP file must be loaded first!
             Use the Load button")))
  

(defun reset-custom-functions()
  (eval(read-from-string
"(defun csp::DOMAIN-DEPENDENT-SHOW-SOLUTION(s)nil)" ))
  (eval(read-from-string
"(defun csp::p-1 (var value)t)"))
 (eval(read-from-string
"(defun csp::p-2 (var value var1 value1) t)"))
 (eval(read-from-string
"(defun csp::variable-domain (domain) nil)"))
 (compile(eval(read-from-string
"(defun csp::equal-value(v1 v2)(equal v1 v2))"))))

(defun net-too-big()
  (> (length (nodes *main-network*)) 40))


(defun set-radio-buttons-after-loading()
  (update-radio-button *all-distinct-values* *adv-button*)
  (update-radio-button *verbose* *verbose-button*)
  (update-radio-button *stop-at-sol*  *stop-at-sol-button*)
  (update-radio-button *stop-at-prop* *stop-at-prop-button*)
  (update-radio-button  *stop-at-arc* *stop-at-arc-button*))
 
(defun update-radio-button (flag rb )
  (cond ((status rb)                ;; button is on
	 (if (not flag)             ;; changed t --> nil by loading file
	     (toggle-button rb)))   ;; turn button off
	((not (status rb))          ;; button is off
	 (if  flag                  ;; changed nil --> t by loading file
	     (toggle-button rb))))) ;; turn button on
