;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-demo1.cl
;;; Short Desc: First demo on Constraint Propagation
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.3.93 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :csp)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun demo-1 ( )
  (setq *open-windows* nil)
  (setq *demo-in-execution* 1)
  (format-display-fill demo-text-disp  (format nil
					       "messaggio 1"))
  (when (wait)
    (format-display-fill demo-text-disp (format nil
						"Messaggio 2"))
    (when (wait)
      (format-display-fill demo-text-disp (format  nil 
						   "Messaggio 3"))
      (when (wait)
	(format-display-fill demo-text-disp (format  nil  "
Messaggio 4"))
	(when (wait)
	  (cspw)
	 (push *csp-main-window* *open-windows*)
	  (protect-display *csp-main-window* t)
	  (format-display-fill demo-text-disp  (format nil  "message 4"))
	  (when (wait)
	     (setq *view* (make-instance 'help-display
			    :left   (left *atn-output-window*)
			    :bottom (scalew 50)
			    :height (scaleh 400)
			    :width  (scalew 800)
			    :filename  (add-path "demo1.csp" *csp-path*)))
	     (push *view*  *open-windows*)
	     (protect-display *gram-disp* t)
	     (format-display-fill demo-text-disp (format nil  "message 5"))
	    (when (wait)
	      (my-software-push *load-grammar* *gram-disp*)
	      (format-display-fill demo-text-disp (format nil  "message 6"))
	      (when (wait)
		(my-software-push *exit-grammar* *gram-disp*)
		(format-display-fill demo-text-disp (format nil  "message 7"))
		(when (wait)
		  (my-software-push *lexicon-tool*  *csp-main-window*)
		  (push *lex-disp* *open-windows*)
		  (protect-display *lex-disp* t) 
		  (format-display-fill demo-text-disp (format nil  "message 8"))
		  (when (wait)
		    (my-software-push *load-lexicon* *lex-disp*)
		    (format-display-fill demo-text-disp (format nil  "message 9"))
		    (when (wait)
		      (my-software-push *exit-lexicon*  *lex-disp*)
		      (format-display-fill demo-text-disp (format nil  "Message 10"))
		      (my-software-push *options* *csp-main-window*)
		      (push *options-disp* *open-windows*)
		      (sleep 2)
		      (my-software-push *show-chart-but*  *options-disp*)
		      (my-software-push *show-trees-but*  *options-disp*)
		      (when (wait)
			(my-software-push *options-exit* *options-disp*)
			(format-display-fill demo-text-disp (format  nil  "Message 11"))
			(when (wait)
			  (setq *current-sentence* '(they are flying planes))
			  (my-software-push *parse-sentence* *csp-main-window*)
			  (push  *graph-chart-disp*   *open-windows*)
			  (format-display-fill demo-text-disp  (format nil  "That's all folks!!!"))
			  (when (wait) 
			    (close-browsers)
			    (close-display  *graph-chart-disp*)
			    (my-software-push *exit-csp* *csp-main-window*)
			    (close-display *csp-main-window*)))))))))))))))


