;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-demo2.cl
;;; Short Desc: Second demo on chart parsing
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   20.4.93
;;; Author:     Paolo Cattaneo & Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :cky)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun demo-2 ( )
  (setq *open-windows* nil)
  (setq *demo-in-execution* 2)
  (setq *grammar* nil)
  (setq *lexicon* '(nil))(setq *parser* "cky")
  (format-display-fill demo-text-disp  (format nil
					       "This is the second CKY demo. The algorithm used
for this example is (again) based on
\"Preliminary Analysis of a Breadth-First 
Parsing algorithm: Theoritical and Experimental Results\" by
Martin, Church, and Patil."))
  (when (wait)
    (format-display-fill demo-text-disp (format  nil 
						 "The original CKY algorithm used in demo 1
restricts right hand side categories to be
of length two at most, which is often an inconvenience.
To  get around  this  restriction  we  modify the 
basic CKY strategy by introducing a new
kind of object called a dotted rule.
"))
    (when (wait)
      (format-display-fill demo-text-disp (format  nil  "
To run the CKY parser we need to load the CKY tool first."))
      (when (wait)
	(parser-tool)
	(push *cky-disp* *open-windows*)
	(protect-display *cky-disp* t)
	(format-display-fill demo-text-disp 
			     (format nil "For this demo we will use
a grammar with some right-hand-sides greater than 2. It is important
to choose the right parser strategy before loading the grammar.
We choose the parser by clicking on the <<Choose Parser>> button
and by selecting the <<CKY with dotted rules>> algorithm."))
	(when (wait)
	  (my-software-push *choose-parser* *cky-disp*)
	  (protect-display *choose-parser-disp* t)
	  (sleep 1)
	  (my-software-push *using-parser-cky-button* *choose-parser-disp*)
	  (my-software-push *using-parser-ckydot-button* *choose-parser-disp*)
	  (sleep 1)
	  (format-display-fill demo-text-disp  (format nil  "The type of sentences
we want to parse are numbers in string form. 
A typical sentence for this example would be
\"nine hundred and twenty-one\"...Don\'t worry that should be clear
once the lexicon and the grammar are loaded"))
	  (my-software-push *exit-choose-parser* *choose-parser-disp*)
	  (when (wait)
	    (my-software-push *grammar-tool* *cky-disp*)
	    (push *gram-disp* *open-windows*)
	    (protect-display *gram-disp* t)
	    (format-display-fill demo-text-disp (format nil  "We load the grammar stored
in the file number-grammar\.cgr by
using the grammar tool."))
	    (when (wait)
	      (my-software-push *load-grammar* *gram-disp*)
	      (format-display-fill demo-text-disp (format nil  "As you can see there are grammar
rules of lenght 3 and 4 which could not be used in the \"regular\" CKY algorithm."))
	      (when (wait)
		(format-display-fill demo-text-disp (format nil  "We then load the lexicon
which provides a mapping between words and categories."))
		(when (wait)
		  (my-software-push *lexicon-tool*  *cky-disp*)
		  (push *lex-disp* *open-windows*)
		  (protect-display *lex-disp* t) 
		  (format-display-fill demo-text-disp (format nil  "We load the lexicon stored
in the file number-lexicon.lex"))
		  (when (wait)
		    (my-software-push *load-lexicon* *lex-disp*)
		    (format-display-fill demo-text-disp (format nil  "As you may have noticed the current
grammar and lexicon are intended to recognize syntactally correct numbers
up to 999 in string (character) form."))
		    (when (wait)
		      (my-software-push *exit-grammar* *gram-disp*)
		      (my-software-push *exit-lexicon*  *lex-disp*)
		      (format-display-fill demo-text-disp 
					     (format nil  "It is time now to select a few options for the parser
so that we can get a better feeling for the parsing activity."))
			(when (wait)
			  (my-software-push *options* *cky-disp*)
			  (push *options-disp* *open-windows*)
			  (sleep 1)
			  (my-software-push *show-chart-but*  *options-disp*)
			  (sleep 1)
			  (my-software-push *show-trees-but*  *options-disp*)
			  (sleep 3)
			  (my-software-push *options-exit* *options-disp*)
			  (format-display-fill demo-text-disp (format  nil  "We are now ready to parse a
number... 921 as we have said before.
On the scrollable parser tool window you will see the trace of the matching activity. The chart 
window will contain a graphical representation of
the matrix. Each cell contains the possible reductions.
~%
You will guide the algorithm by clicking on the active words.
~%
After clicking on the last word the parser returns two solutions which are then diplayed in the form of a parse tree. Both
the chart cells and scrollable display show the possible combinations of the substrings (subsentences)."))
			    (when (wait)
			      (setq *current-sentence* '(nine hundred and twenty - one))
			      (my-software-push *parse-sentence* *cky-disp*)
			      (push  *graph-chart-disp*   *open-windows*)
			      (format-display-fill demo-text-disp  (format nil  "It is not advisable to use
the same grammar with the standard CKY algorithm. It just would not work. If you try you will get messages
of the kind \"Illegal Rule...\". We recommend that you read the general help for the parsing algorithms to
understand the difference between the standard and the dotted rule algorithm."))
			      (when (wait) 
				(format-display demo-text-disp "You may want to enhance the grammar and lexicon to
accept larger numbers.

That's it. Have fun using CKY.")
				(when (wait)
				  (close-browsers)
				  (close-display  *graph-chart-disp*)
				  (my-software-push *exit-cky* *cky-disp*)
				  (close-display *cky-disp*))))))))))))))))