;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-make.cl
;;; Short Desc: Compile & load code & documentation
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   25.4.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Build atp
;;;




(in-package :atp)


(setq *len-directory* (add-subdir *pail-path* "atp"))
(defvar *theorems-dir*  (add-subdir *len-directory* "examples"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))
(defvar *theorems-subdir*  "examples")
(setq    cw::*window-manager-titles-p* t)

(setq *len-files* '("len-adt"		    
		   "folpars"		    "folscan"
		    "prolpars"		    "norm"
		    "renvar"		    "class"
		    "outputs2"		  
		    "preproc"        	    "update_new"		
		    "skolem"		    "match"
		    "semp"		    "infer"
		    "tree-dvi"		    "choose"
      		    "library"		    "exist"
		    "en_strat"		    "order"
		    "input"                   "eval2"	
		    "weigths"		   "prolog"	 
		  	))


(ensure-loaded (add-path "size-indep-utils" *libpath*))
(ensure-loaded (add-path "sftw-push" *libpath*))
(ensure-loaded (add-path "rules" *libpath*))
(ensure-loaded (add-path "trees" *libpath*))
(ensure-loaded (add-path "browser" *libpath*))
(ensure-loaded (add-path "atp-browser"*len-directory*))

(dolist (f *len-files*)
  (ensure-loaded (add-path f *len-directory*)))

(ensure-loaded   (add-path "len-interface.cl" *len-directory*) :source nil)
(ensure-loaded   (add-path "len-filemgr.cl" *len-directory*)  :source nil)
(ensure-loaded   (add-path "atp-dialog.cl" *len-directory*)   :source nil)
(ensure-loaded   (add-path "atp-demo.cl"  *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo1.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo2.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo3.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo4.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo5.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "atp-demo6.cl" *len-directory*)    :source nil)
(ensure-loaded   (add-path "afterinput.cl" *len-directory*))

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
