;;; -*- Mode: LISP; Package: GTRE; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   tms-dialog.cl
;;; Short Desc: dialog handling for all TMS
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   22.8.91 - FFA
;;; Author:     DTA FFA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Taken from the jtms-dialog.cl
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :gtre)
(eval-when (compile load)
(import '(pail-lib::pool-button
	  pail-lib::pool-item
	  pail-lib::tms-tree
	  pail-lib::name-part
	  pail-lib::get-from-pool
	  pail-lib::ruledefs
	  pail-lib::asserts
	  pail-lib::construct-tms-tree
	  pail-lib::tms-browser
	  pail-lib::help-button
	  pail-lib::*pail-path*
	  pail-lib::add-subdir
	  pail-lib::add-path
	  pail-lib::ensure-loaded
	  pail-lib::*main-window*
	  )))


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *display-list* nil)

(defun start-tms-dialog (&optional (from-button nil))
  (let* ((disp (make-instance 'display :title "TMS: Main Window"
			     :width 450
			     :height 200
			     :borders 1
			     :bottom (bottom *main-window*)
			     :left (+ (left *main-window*) (width *main-window*))))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
				     :technical (add-path "tms-doc.tec"
							  (add-subdir *pail-path* "tms"))
				     :general (add-path "tms-doc.gen"
							(add-subdir *pail-path* "tms"))
				     :subject "TMS"))
	 (jtms-button   (make-instance 'push-button :label "JTMS" :width 200))
	 (nmjtms-button   (make-instance 'push-button :label "NMJTMS" :width 200))
	 (*default-push-button-size-p* nil)
	 left-side)

    (push disp *display-list*)
    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
  
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 18 :weight :bold))
    (write-display disp
		   "Truth Maintenance Systems"
		   (/ (- (width disp) (font-string-width (font disp) "Truth Maintenance Systems")) 2)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)

    (set-button help-button disp :left 15 :bottom 15)
    
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda () (exit-function ,exit-button ,from-button)))
    (setf left-side (floor (- (width disp) (width jtms-button)) 2))
    (set-button jtms-button disp
		:left left-side
		:bottom (* 2 (height exit-button))
		:action `(lambda nil (start-jtms :from-button ,jtms-button)))
    (set-button nmjtms-button disp
		:left left-side
		:bottom (* 3 (height exit-button))
		:action `(lambda () (start-nmjtms :from-button ,nmjtms-button)))
    disp))


(defun start-jtms (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "jtms-make" (add-subdir *pail-path* "jtms")) 
		 :source t :force t))
  (gtre::start-jtms-dialog from-button))


(defun start-nmjtms (&key (from-button nil))
  (when (not pail-lib::*runtime*)
    (ensure-loaded (add-path "nmjtms-make" (add-subdir *pail-path* "nmjtms")) 
		 :source t :force t))
  (gtre::start-nmjtms-dialog from-button))


(defun exit-function (exit-button from-button)
  #| (if (yes-or-no-dialog "Really Exit? ")
      (progn (dolist (d *display-list*)
	       (close-display (eval d)))
	     (reset-button from-button))
    (reset-button exit-button)) |#
  (progn (dolist (d *display-list*)
	   (close-display (eval d)))
	 (reset-button from-button)))

(defun yes-or-no-dialog (query &key (title "Please Click"))
  (let ((dw (make-instance 'menu
	     :left 500
	     :bottom 500
	     :query query
	     :items '(("Yes" t) ("No" nil)))))
    (accept-items dw)))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================

