;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rules-dialog.cl
;;; Short Desc: dialog handling for rules
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   5.6.91 - DTA
;;; Author:     Dean Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Taken from the original ID3-dialog.cl by TW
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rules)



;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defvar *pause* nil)
(defvar *quit* nil)
(defvar *verbose-disp* nil)
(defvar *verbose* nil)
(setf *verbose* *verbose-default*)
(defvar *to-explain-button* nil)
(defvar *explain* nil)




(defun make-title (nr)
  (format nil "The ~:R Demo of RULES" nr))


(defvar *number-of-demos* 0)


(make-editor-fcn rules-table-edit)


(defun start-forward-rules-dialog (&optional (from-button nil))
  (setf *verbose-disp* (make-instance 'scroll-display
                                     :title "Rules:Verbose Comments"
				     :width 580
				     :height 200
				     :borders 1
				     :active nil
				     :left 500
				     :bottom 375))

  (setf *verbose* *verbose-default*)
  
  (let* ((disp (make-instance 'display :title "RULES:Main Window"
			     :width 300
			     :height 150
			     :borders 1
			     :left 200
			     :bottom 680))
	 (menu-button (make-instance 'pop-up-button
			:label "Menu"
			:width 100))
	 (tool-button (make-instance 'push-button :label "Tool" :width 100))
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			:technical (add-path "rules-desc.tec" *rulespath*)
			:general (add-path "rules-desc.gen" *rulespath*)
			:subject "RULES"))
	 (menu (make-instance 'menu
		 :items (let ((mlist nil))
			   (dotimes (i *number-of-demos* (nreverse mlist))
			     (setf mlist 
			       (cons (list (format nil "Demo ~a" (1+ i)) 
					   `(lambda () 
					      (demo ,(1+ i) ,menu-button ,exit-button))
					   (make-title (1+ i)))
				     mlist))))
       		 :query "DEMOS")))

    (setf (menu menu-button) menu)

    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))
  
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "Welcome to ..."
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (cw:open-font :courier :italic 45 :weight :bold))
    (write-display disp
		   "Forward Rules"
		   (/ (width disp) 10)
		   (- (height disp) 40 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
 
    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (close-display *verbose-disp*)
			   (close-display ,disp)
			   (close-display (technical-window ,help-button))
			   (close-display (general-window ,help-button))
			   (if ,from-button (reset-button ,from-button))))

    (set-button help-button disp :left 15 :bottom 15)
  

    (set-button menu-button disp 
		:left (/ (- (width disp) (width menu-button)) 2)
		:bottom (+ 20 (height help-button)))
    (set-button tool-button disp 
		:left (/ (- (width disp) (width tool-button)) 2)
		:bottom 15
		:action `(lambda ()
			   (start-rules-tool ,tool-button ,exit-button))
		)
    exit-button
    ))


(defclass rule-display (display)
	  ((help-button :accessor help-button
			:initarg :help-button
			:initform nil)
	   (eblist :accessor eblist
		   :initarg :eblist
		   :initform nil)))

(defmethod close-display :before ((disp rule-display))
  (close-display (technical-window (help-button disp)))
  (close-display (general-window (help-button disp)))
  (loop for d in (eblist disp) do (close-display d)))



(defun start-rules-tool (&optional (from-button nil) (exit-button nil))
  (setf *verbose* *verbose-default*)
  #| (setf *verbose-disp* (make-instance 'scroll-display
				     :title "Verbose Comments"
				     :width 480
				     :height 200
				     :borders 1
				     :active *verbose*
				     :left 500
				     :bottom 375)) |#
  
  (if *verbose* (activate-display *verbose-disp*))

  (setf *trace-stream* *verbose-disp*)
  (let* ((disp (make-instance 'rule-display
			     :title "RULES: Main Window"
			     :width 500
			     :height 250
			     :left 200
			     :bottom 580))
	 
	 
	 (exit-button (make-instance 'push-button :label "Exit" :width 70))
	 (help-button (make-instance 'help-button
			:technical (add-path "rules-desc.tec" *rulespath*)
			:general (add-path "rules-desc.gen" *rulespath*)
			:subject "Rules"))
	 (run-button (make-instance 'push-button :label "Run" :width 70))
	 (explain-button (make-instance 'push-button :label "Explain" :width 70))
	 (edit-wm-button (make-instance 'push-button :label "Edit WM" :width 70))
	 (verb-button (make-instance 'radio-button :label "Verbose mode" :status *verbose*))
	 
	 (menu-button-rules (make-instance 'pool-button
			      :name "Rulesets:"
			      :value ""
			      :width 250
			      :target-class 'rules::rule-set
			      :pool *pail-pool*
			      :border t
			      :show-function #'(lambda (item) (documentation-print (print-rule-set item nil)))
			      ))
	 (menu-button-wms (make-instance 'pool-button
			    :name "Working memories:"
			    :pool *pail-pool*
			    :value ""
			    :width 250
			    :target-class 'rules::working-memory
			    :border t
			    ))
	 
	 )
    
    (setf (help-button disp) help-button)
    

    (setf *to-explain-button* (make-instance 'value-button
				:name "To Explain:"
				:value ""
				:width 250
				:use-window t
				:border t
				)
	  )


    (copy-mask *pail-logo* 0 0 disp
	       (- (width disp) (width *pail-logo*) 15)
	       (- (height disp) (height *pail-logo*) 15))
  
    (setf (font disp) (open-font :courier :italic 20 :weight :bold))
    (write-display disp
		   "A tool for dealing with rule sets"
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) (open-font :courier :italic 45 :weight :bold))
    #| (write-display disp
		   "RULES"
		   (/ (width disp) 3)
		   (- (height disp) 40 (cw:font-ascent (font disp)))) |#
    (setf (font disp) *default-font*)
    
    
    (set-button help-button disp :left 15 :bottom 15)
    

    (set-button run-button disp 
		:left (+  (width help-button) 15 20)
		:bottom 15
		:action `(lambda nil
			   (setf (start-object (button-value ,menu-button-wms))
			     (change-type (start-object (button-value ,menu-button-wms)) (make-instance 'working-memory)))
			   (rules::forward-chain (start-object (button-value ,menu-button-rules)) (start-object (button-value ,menu-button-wms)))
			   (reset-button ,run-button)
			   ))

    (set-button explain-button disp 
		:left (+ (left run-button) (width run-button) 20)
		:bottom 15
		:action `(lambda nil
			   (push (make-instance 'ebg-browser
				   :starting-tree (generate-explanation *explain* (start-object (button-value ,menu-button-wms)))
				   :ruleset (start-object (button-value ,menu-button-rules))
				   :wm (start-object (button-value ,menu-button-wms))
				   )
				 (eblist ,disp))
			   (reset-button ,explain-button)
			   ))

    (set-button edit-wm-button disp 
		:left (+ (left explain-button) (width explain-button) 20)
		:bottom 15
		:action #'(lambda ()
			    (let ((attr (cond
					 ((not (start-object (button-value menu-button-rules))) 0)
					 ((equal (length (car (if-part (car (rule-set-part (start-object (button-value menu-button-rules))))))) 2)
					  (delete-duplicates
					   (loop for rule in (rule-set-part (start-object (button-value menu-button-rules)))
					    append (loop for hyp in (if-part rule)
						    collect (car hyp)))))
					 (t (delete-duplicates
					     (loop for rule in (rule-set-part (start-object (button-value menu-button-rules)))
					      append (loop for hyp in (if-part rule)
						      collect (cadr hyp)))))
					 ))
				  )
			      (if (and (null (start-object (button-value menu-button-wms)))
				       (start-object (button-value menu-button-rules)))
				  (setf (start-object (button-value menu-button-wms))
				    (make-instance 'working-table
				      :attributes attr
				      :rows (list (loop for i in attr collect nil)))))
			      (setf (start-object (button-value menu-button-wms))
				(rules-table-edit (start-object (button-value menu-button-wms))))
			      (reset-button edit-wm-button)
			      )
			    ))
  
    (set-button menu-button-rules disp 
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom 55

		)
    
    (set-button menu-button-wms disp 
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 55 (height menu-button-rules))

		)
    (set-button *to-explain-button* disp
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 55 (* 2 (height menu-button-rules)))
		:action 'read-explain)

    (set-button verb-button disp
		:left (- (width disp) (width menu-button-rules) 60)
		:bottom (+ 15 (bottom *to-explain-button*) (height *to-explain-button*))
		:action #'(lambda nil (setf *verbose* (not *verbose*))
				  (if *verbose* (activate-display *verbose-disp*)
				    (deactivate-display *verbose-disp*))))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15)
		:bottom 15
		:action `(lambda nil
			   (deactivate-display *verbose-disp*)
			   (close-display ,disp)
			   (if ,from-button (reset-button ,from-button))))
    ))


(defun read-explain () (let ((old-package *package*))
			 
			 (setf *explain*
			   (intern-all (read (make-string-input-stream (button-value *to-explain-button*))) :dump)
			 )))



(defun auto-handler (nr parent start-button cont-button exit-button verb-button)
  (let ((text-disp (make-instance 'scroll-display
				 :title "Comments"
				 :font (open-font-named "fixed")
				 :parent parent
				 :width 300
				 :height 110
				 :borders 1
				 :left 400
				 :bottom 55))
	(rule-disp (make-instance 'scroll-display
				 :title "Rules"
				 :font (open-font-named "fixed")
				 :width 480
				 :height 200
				 :borders 1
				 :left 10
				 :bottom 143))
	(table-disp (make-instance 'scroll-display
				  :title "Working Memory"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 200
				  :borders 1
				  :left 10
				  :bottom 375)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display rule-disp)
	       (close-display table-disp)
	       (close-display (technical-window *help-button*))
	       (close-display (general-window *help-button*))
	       (setf table-disp nil)
	       (when *browse*
		 (close-browser nil *browse*)
		 (setf *browse* nil))
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format (window text-disp) "~&~%[Press <Continue> Button]")
	  (sleep 1)
	  (mp:process-wait "wait-on-click" (function (lambda () (not pail::*pause-demo*))))
	  (if pail::*stop-demo* (setq *quit* t))
	  (software-push cont-button)
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      #| (when (not *verbose*)
	(toggle-button verb-button)
	) |#
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :rules)))
	(if fun-sym
	    (funcall fun-sym text-disp rule-disp table-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))


(defun store-display (disp)
  (declare (ignore disp)))


(defun demo (nr menu-button other-exit-button)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (let ((disp (make-instance 'display :title (concatenate 'string "Rules:" (make-title nr))
			    :width 800
			    :height 200
			    :borders 1
			    :left 115
			    :bottom 610))
	(exit-button (make-instance 'push-button :label "Exit" :width 180))
	
	(start-button (make-instance 'push-button :label "Start" :width 180))
	(cont-button (make-instance 'push-button :label "Continue" :width 180))
	(verb (make-instance 'radio-button :label "Verbose Mode"
			     :status *verbose*
			     :action 
			     '(lambda ()
			       (if *verbose*
				   (progn
				     (setf *verbose* nil)
				     (deactivate-display *verbose-disp*))
				 (progn
				   (setf *verbose* *verbose-disp*)
				   (activate-display *verbose-disp*))))))
	
	
	)

    	; make sure that default is set
    
;    (print *verbose*)
    (if *verbose*
	(progn (activate-display *verbose-disp*)
	       (setf *verbose* *verbose-disp*))
      (deactivate-display *verbose-disp*))
    (setf *help-button* (make-instance 'help-button
		       :width 180
		       :subject (concatenate 'string "Rules:" (make-title nr))
		       :technical (add-path
					"demo-desc.tec"
					*rulespath*)
		       :general (add-path
					(concatenate 'string
					  "demo" (write-to-string nr) "-desc.gen")
					*rulespath*) ))
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (setf *quit* t)
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)
			   (close-display ,disp)
			   (close-display (technical-window *help-button*))
			   (close-display (general-window *help-button*))
			   (deactivate-display *verbose-disp*)))

    (set-button *help-button* disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(/ (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
;		    (disable-button exit-button)
		    (dialog-handler nr disp start-button cont-button exit-button verb)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (/ (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
;		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    
    
    
		    
    (set-button verb disp :left (/ (width disp) 4) :bottom 80)
    ))


(defun dialog-handler (nr parent start-button cont-button exit-button verb-button)
  (let ((text-disp (make-instance 'scroll-display
				 :title "Comments"
				 :font (open-font-named "fixed")
				 :parent parent
				 :width 300
				 :height 110
				 :borders 1
				 :left 400
				 :bottom 55))
	(rule-disp (make-instance 'scroll-display
				 :title "Rules"
				 :font (open-font-named "fixed")
				 :width 480
				 :height 200
				 :borders 1
				 :left 10
				 :bottom 143))
	(table-disp (make-instance 'scroll-display
				  :title "Working Memory"
				  :font (open-font-named "fixed")
				  :width 480
				  :height 200
				  :borders 1
				  :left 10
				  :bottom 375)))
    (labels ((clean-up ()
	       (close-display text-disp)
	       (close-display rule-disp)
	       (close-display table-disp)
	       (close-display (technical-window *help-button*))
	       (close-display (general-window *help-button*))
	       (setf table-disp nil)
	       (when *browse*
		 (close-browser  *browse*)
		 (setf *browse* nil))
	       (unless *quit*
		 (enable-button exit-button)
		 (reset-button cont-button)
		 (disable-button cont-button)
		 (reset-button start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button cont-button)
	  (reset-button cont-button)
	  (enable-button exit-button)
	  (format (window text-disp) "~&~%[Press <Continue> Button]")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      #| (when (not *verbose*)
	(toggle-button verb-button)
	) |#
      (let ((fun-sym (find-symbol (symbol-name (read-from-string (format nil "dialog-~a" nr))) :rules)))
	(if fun-sym
	    (funcall fun-sym text-disp rule-disp table-disp)
	  (format t "Demo not implemented")))
      (wait)
      (clean-up))))


(defun auto-demo (nr )
  (let ((disp (make-instance 'display :title (concatenate 'string "Rules:" (make-title nr))
			    :width 800
			    :height 200
			    :borders 1
			    :left 115
			    :bottom 610))
	(exit-button (make-instance 'push-button :label "Exit" :width 180))
	
	(start-button (make-instance 'push-button :label "Start" :width 180))
	(cont-button (make-instance 'push-button :label "Continue" :width 180))
	(verb (make-instance 'radio-button :label "Verbose Mode"
			     :status *verbose*
			     :action 
			     '(lambda ()
			       (if *verbose*
				   (progn
				     (setf *verbose* nil)
				     (deactivate-display *verbose-disp*))
				 (progn
				   (setf *verbose* *verbose-disp*)
				   (activate-display *verbose-disp*))))))
	
	
	)

					; make sure that default is set
    
;    (print *verbose*)
    (if *verbose*
	(progn (activate-display *verbose-disp*)
	       (setf *verbose* *verbose-disp*))
      (deactivate-display *verbose-disp*))
    (setf *help-button* (make-instance 'help-button
			  :width 180
			  :subject (concatenate 'string "Rules:" (make-title nr))
			  :technical (add-path
				      "demo-desc.tec"
				      *rulespath*)
			  :general (add-path
				    (concatenate 'string
				      "demo" (write-to-string nr) "-desc.gen")
				    *rulespath*) ))
    (setf (font disp) (cw:open-font :courier :italic 20 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)


    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 15))

    (set-button exit-button disp 
		:left (- (width disp) (width exit-button) 15) 
		:bottom 15
		:action `(lambda ()
			   (setf *quit* t)
			   (close-display ,disp)
			   (close-display (technical-window *help-button*))
			   (close-display (general-window *help-button*))
			   (deactivate-display *verbose-disp*)))

    (set-button *help-button* disp :left 15 :bottom 15)
    

    (set-button start-button disp 
		:left (round (+ 15
				(width start-button)
				(/ (- (width disp)
				      30
				      (* 4 (width start-button)))
				   3)))
		:bottom 15
		:action
		#'(lambda ()
					;		    (disable-button exit-button)
		    (auto-handler nr disp start-button cont-button exit-button verb)))
		
    (set-button cont-button disp 
		:left (round (+ 15
				(* 2 (width start-button))
				(* 2 (/ (- (width disp) 
					   30 
					   (* 4 (width start-button)))
					3))))
		:bottom 15
		:action 
		#'(lambda ()
					;		    (disable-button exit-button)
		    (setf *pause* (not *pause*))))
    (disable-button cont-button)

    (set-button verb disp :left (/ (width disp) 4) :bottom 80)

    (setf pail::*stop-demo* nil)
    (software-push start-button)
    (software-push exit-button)
    
    ))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
