;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                     -*-
;;;
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   rpg-triad
;;; Short Desc: triad methods and display for Rep Grid
;;; Version:    1.0b
;;; Status:     Beta testing
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Tue Feb 18 19:15:36 1992
;;; Update Count    : 3
;;; --------------------------------------------------------------------------
;;; Modification History
;;; 19.11.91 --- ThE: Major update, incompatible changes, but works
;;;                   except for GIN-problems (font) Nick promised to work on
;;; ==========================================================================
;;; TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
;;; ==========================================================================
;;;
;;; Include ordinal rating option
;;;
;;; Include an option to direct triad-making (eg. with clashes from ID3)
;;;


;;; ==========================================================================
;;; PACKAGE and EXPORT DECLARATIONS
;;; ==========================================================================

(in-package :rpg)

(eval-when (load compile)
  (export '(triad-select triad-classify)))


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


;;; ==========================================================================
;;; The GIN-Display Interfaces for TRIAD selection and naming
;;; ==========================================================================

(defun triad-select (element-list &key (from-button nil)
				       (from-window nil)
				       (title "RPG:TRIAD Window")
				       (info  "Elements to select:"))
  "Window-based triad elicitation method."
  (declare (special *verbose* *triad-displays* *output-button*))
  (format-display *verbose* "; Triad method initializes")
  (setf *triad-displays* nil)
  (let* ((menu-width (round (width *root-window*) 3.5))		; modifiable (to taste)
	 (disp-height (round (height *root-window*) 2.5))		; modifiable (to taste)
;	 (*default-font* (findfont (width *root-window*) 1140 13))
	 ;; ---------- The next function creates the triad
	 ;; ---------- Maybe change it to accept clashes
	 ;; ---------- or other non-random triads?
	 ;; ---------- Maybe as a pAIL-exercise?
	 (triad (triples :pop-random t)) ; get a random element
	 (triad-disp	     (make-instance 'display 
			      :title title
			      :active t
			      :left 10 
			      :bottom (max 50 (- disp-height 
						 (bottom from-window)))
			      :width (+ 10 menu-width)
			      :height disp-height))
	 (triad-instr        nil)
	 (triad-exit-button  (make-instance 'push-button 
			       :label "Exit"
			       :bottom 5 :width (- (floor menu-width 2) 4)))
	 (triad-classify-button (make-instance 'value-button ;; 'push-button 
				  ;; :label " Classify "
				  :value "Classify" :border t
				  :left 5 :bottom 5 
				  :width (- (floor menu-width 2) 4)))
	 (triad-new-button   (make-instance 'push-button 
			       :label "Make new TRIAD"
			       :left 5 :width menu-width))
	 (triad-choice-menu  
	  (make-instance 'select-button
	    :label info :left 5 :width menu-width
	    :items (list-to-stringlist triad)
	    :action 
	    #'(lambda nil 
		(reset-button triad-classify-button)
		(enable-button triad-classify-button)
		(format-display-fill  triad-instr
				(format nil "Click on the < Classify > Button
                                 to continue with the highlighted
				 choice ~a" (item-label))))
	    :exclusive t ))
	 (triad-class-disp 
	  (make-instance 'display 
	   :title "RPG:Triad Classification Window"
	   :active nil
	   :left   (+ (width triad-disp)(left triad-disp))
	   :bottom (bottom triad-disp)
	   :width (- (width *root-window*) menu-width 10) :height (height triad-disp)))
	 (classify-menu        
	  (make-instance 'menu
	    :items 
	    `(("Binary classification" 
	       (progn
		 ()
		 (let* 
		     ((result nil)
		      (items (items ,triad-choice-menu))
		      (tr (intern-all (mapcar #'(lambda (z)
				      (intern (read-from-string (label z))))
				  items) :dump)))
		   (do ((status items (cdr status))
			(item   tr (cdr item)))
		       ((null status) (reverse result))
		     (when (status (car status))
		       (push (car item) result)))
		   (triad-classify-binary
		    (car result) (remove (car result) tr)
		    ,triad-class-disp ,triad-disp ,triad-instr 
		    ,triad-classify-button ,triad-new-button)
		   (reset-button  ,triad-classify-button)
		   (disable-button ,triad-classify-button)))
	       "Place elements into two distinctive groups.")
	      ("Interval classification" 
	       (progn 
		 ()
		 (let* ((result nil)
			(items (items ,triad-choice-menu))
			(tr (intern-all (mapcar #'(lambda (z)
					(read-from-string (label z)))
				    items) :dump)))
		   (do ((status items (cdr status))
			(item   tr (cdr item)))
		       ((null status) (reverse result))
		     (when (status (car status))
		       (push (car item) result)))
		   (triad-classify-interval
		    (car result) (remove (car result) tr)
		    ,triad-class-disp ,triad-disp ,triad-instr 
		    ,triad-classify-button ,triad-new-button)
		   (reset-button  ,triad-classify-button)
		   (disable-button ,triad-classify-button)))
	       "Place elements on a thermometer scale.") ))) )
    ;; ---------- Collect all master displays (in case of troule)
    (setf *triad-displays* (list triad-class-disp triad-disp))
    ;; ---------- The size of the select-button triad-choice-menu is variably 
    ;; ---------- designed (but for TRIAD there are usually only three items)
    (set-button triad-choice-menu triad-disp 
		:bottom (+ 12 (* 2 (height triad-classify-button))))
    ;; ---------- Now determine size of other displays
    (setf (menu triad-classify-button) classify-menu)
    (set-button triad-classify-button  triad-disp )
    (set-button triad-classify-button triad-disp)
    (disable-button triad-classify-button)
    (set-button triad-exit-button triad-disp  
		:left   (+ (left triad-classify-button) 
			   (width triad-classify-button) 8)
		:action #'(lambda nil 
			    (setf (display 
				   (start-object 
				    (button-value *output-button*))) nil)
			    (close-display triad-class-disp)
			    (close-display triad-disp)
			    ;; ========================================
			    ;; NEXT ACTIONS TO BE SCHEDULED HERE
			    ;; ========================================
			    (when from-button
			      (reset-button from-button))
			    (dolist (d *triad-displays*) ; just to be sure
			      (close-display d))
			    (setf *triad-displays* nil)))
    (set-button triad-new-button triad-disp 
		:bottom (+ (height triad-classify-button) 8)
		:action 
		#'(lambda nil 
		    (cond ((< (triples :length t) 1)
			   (push (display-error "No more triads available"
						:wait t
						:from-button triad-new-button)
				 *triad-displays*))
			  (t 
			   (if (> (status triad-classify-button) -1)
			       (disable-button triad-classify-button))
			   (setf triad (triples :pop-random t))
			   (setf (items triad-choice-menu) 
			     (list-to-stringlist triad))
			   (setf (action triad-choice-menu) 
			     #'(lambda nil 
				 (reset-button  triad-classify-button)
				 (enable-button triad-classify-button)
				 (format-display-fill
				  triad-instr
				  (format nil "Click on the < Classify > Button
                                   to continue with the highlighted
				   choice ~a" (item-label)))))
			   (reset-button triad-new-button) )))
		:active t)
    ;; ---------- The triad-instr displays provides user instructions
    (setf triad-instr 
      (make-instance  'scroll-display
       :title "Instructions:"
       :borders 1
;       :font (findfont menu-width 300 10)
       :parent triad-disp
       :left 5 :width menu-width
       :bottom (+ (height triad-choice-menu)(bottom triad-choice-menu) 4 20)
       :height (abs (- (inner-height triad-disp) 
		       (+ (height triad-choice-menu)
			  (bottom triad-choice-menu) 4 20 20)))  ))
    (push triad-instr *triad-displays*)
    (format-display-fill triad-instr 
		    (format nil "Please select an item from the TRIAD below.
                     Decide on a way that
                     ~R of these elements are similar
                     and in the same way different 
                     from the remaining element.
                     Click on the item which is
                     different from the rest"
		    (1- (length triad))))
    (format-display *verbose* "; Triad method is ready")
    t))

;;; ==========================================================================
;;; Dual (binary) classification
;;; ==========================================================================


(defun triad-classify-binary (selection
			      others
			      triad-class-disp
			      triad-disp 
			      triad-instr 
			      triad-classify-button 
			      triad-new-button)
  "Elicit the names of the two construct-poles 
   and classify all elements into two groups"
  (declare (special *verbose* *small-font-11* *default-font* *output-button*))
  (activate-display triad-class-disp)
  ;; ---------- Button control 
  (disable-button triad-new-button)
  (reset-button triad-classify-button)	 ; Reset from calling function
  (disable-button triad-classify-button) ; But stay disabled
  (format-display triad-instr 
		  "~%~%Now enter descriptive labels~
                   ~%for each of the two classes.")
  (let* ((items (cdr (attributes 
		      (start-object (button-value *output-button*)))))
	 (items-symb			; IT A HACK, I KNOW!!!
	  (intern-all
		  (cdr (attributes 
			(start-object (button-value *output-button*))))
		  :dump))
	 (gap 4)
	 (pole-min-str
	  (string-cleanup
	   (ask 
	    (format 
	     nil 
	     "What is it about ' ~a ' that makes it DIFFERENT~
            ~%from the other elements ' ~{~a ~}' ?~
            ~%~%Please type in a descriptive label (one word/adjective):~%~%" 
	     selection others)
	    :title "RPG:Pole naming" :font (findfont (width triad-disp) 300 13)
	    :left (left triad-disp) :bottom (bottom triad-disp))))
	 (pole-max-str    
	  (string-cleanup
	   (ask 
	    (format 
	     nil 
	     "Please supply a description which expresses the~
            ~%SIMILARITY between the elements ' ~{~a ~}'~
            ~%in contrast to the element ' ~a '.~
            ~%~%Please type in a descriptive label (one word/adjective):~%~%" 
			others selection)
		:title "RPG:Pole naming" :font (findfont (width triad-disp) 300 13)
		:left (left triad-disp) :bottom (bottom triad-disp))))
	 (pole-min (intern (if (equal "" pole-min-str)
		       (read-from-string (format nil "~a" (gentemp 'r-)))
		     (read-from-string pole-min-str)) :dump))
	 (pole-max (intern (if (equal "" pole-max-str)
		       (read-from-string (format nil "~a" (gentemp 'r-)))
		     (read-from-string pole-max-str)) :dump))
	 (s-bottom (+ 12 (* 2 (height triad-classify-button))))
	 (s-height (- (height triad-class-disp) s-bottom 20))
	 (sn-region (cw:make-region
		     :left (- (width triad-class-disp) (* 4 gap) 100) 
		     :bottom s-bottom   :height  s-height 
		     :width (+ 100 (* 2 gap))))
	 (s-left gap)
	 (s-width (floor (/ (- (width triad-class-disp)
			       (cw:region-width sn-region)
			       (* 5 gap)) 2)))
	 (s0-region (cw:make-region
		     :left s-left :bottom s-bottom
		     :height s-height :width s-width))
	 (s1-region (cw:make-region
		     :left (+ s-left s-width gap) :bottom s-bottom
		     :height s-height :width s-width))
	 (done-button 
	  (make-instance 'push-button 
	    :label  " D o n e "
	    :left   s-left
	    :width  (+ (* 2 gap) (* 2 s-width))
	    :bottom 5))
	 (randomize-button 
	  (make-instance 'push-button 
	    :label  " Random "
	    :left   (+ gap (left done-button)(width done-button))
	    :width  100
	    :bottom 5))
	 (construct-name nil)
	 (result nil))
    ;; ---------- NOTE: Don't use DISPLAYs for the elements
    ;; ---------- or the element-displays may disappear (thanks Nick)
    (format-display *verbose* 
		    "; TRIAD-CLASSIFY-BINARY used to classify ~a" items)
    (draw-filled-rectangle 
     triad-class-disp 0 0 (width  triad-class-disp) (height triad-class-disp)
     :color white :operation boole-1)
    (draw-rectangle triad-class-disp		; the "unclassified" bag
		    (cw:region-left   sn-region)
		    (cw:region-bottom sn-region)
		    (cw:region-width  sn-region)
		    (cw:region-height sn-region) )
    (draw-rectangle triad-class-disp		; The (0) bag
		    (cw:region-left   s0-region)
		    (cw:region-bottom s0-region)
		    (cw:region-width  s0-region)
		    (cw:region-height s0-region) )
    (draw-rectangle triad-class-disp		; The (1) bag
		    (cw:region-left   s1-region)
		    (cw:region-bottom s1-region)
		    (cw:region-width  s1-region)
		    (cw:region-height s1-region) )
    ;; ---------- Provide titles for bags
;;    (setf (font triad-class-disp) *small-font-11*)
    (write-display triad-class-disp (format nil " ~a" pole-min)
		   (cw:region-left   s0-region)
		   (+ s-bottom s-height gap))
    (write-display triad-class-disp (format nil " ~a" pole-max)
		   (cw:region-left   s1-region)
		   (+ s-bottom s-height gap))
    (write-display triad-class-disp "Unclassified"
		   (cw:region-left   sn-region)
		   (+ s-bottom s-height gap))
    (setf (font triad-class-disp) *default-font*)
    ;; ---------- Create or update element displays
    (cond ((null (cdr (display 
		       (start-object (button-value *output-button*)))))
	   ;; ---------- Create for every element a window
	   (setf (display (start-object (button-value *output-button*)))
	     (dotimes (i (1+ (length items)) (nreverse result))
	       (push nil result)))
	   (dotimes (count (length items))
	     (setf (nth (1+ count) 
			(display 
			 (start-object (button-value *output-button*))))
	       (make-instance 'display 
		:title (nth count items-symb)
		:active t       :parent  triad-class-disp
		:frame-menu nil :borders 1
		;; position inside the right bag
		:left 
		(progn 
		  ()
		  (cond ((member (nth count items-symb) (list selection))
			 (+ (cw:region-left s0-region) gap))
			((member (nth count items-symb) others)
			 (+ (cw:region-left s1-region) gap))
			(t 
			 (+ (cw:region-left sn-region) gap))))
		;; decrease the position for every element
		:bottom (- (height triad-class-disp) 40 (* count 20))
		:width 100 :height 1))) )
	  (t 
	   ;; Move existing displays to appropriate place
	   (dolist (x (cdr (display 
			    (start-object (button-value *output-button*)))))
	     (setf (left x) 
	       (cond ((member (title x) (list selection))
		      (+ (cw:region-left s0-region) gap))
		     ((member (title x) others)
		      (+ (cw:region-left s1-region) gap))
		     (t 
		      (+ (cw:region-left sn-region) gap))) )) ))
    (set-button done-button triad-class-disp
		:action 
		#'(lambda nil
		    (unless construct-name         ;;; OKKIO scope di unless piu grande
		      (setf construct-name
			(string-cleanup
			 (ask 
			  (format nil 
				  "Please enter a name for this CONSTRUCT~
                ~%with its poles ~a and ~a.~
                ~%Please type in a descriptive label (one word/noun):~%~%"
				  pole-min pole-max)
			  :title "RPG:Construct naming"  :font (findfont (width triad-disp) 300 13)
			  :error-message "Input has to be a word"
			  :left (left triad-class-disp) 
			  :bottom (bottom triad-class-disp))))
		      (setf construct-name  (intern (if (equal "" construct-name)
							(read-from-string (format nil "~a" (gentemp 'c-)))
						      (read-from-string construct-name)) :dump)))
		    (unless (check-binary-ratings items s0-region s1-region)
		      (push (display-error 
			     (format nil
				     "Statistical analysis of your data~
                                     ~&might be affected when you decide~
                                     ~&not to classify ALL elements")
			     :wait nil
			     :button-label "Click here to continue"
			     :title "WARNING:")
			    *triad-displays*))
		    ;; ========================================
		    ;; LOCAL EXIT FROM THE CLASSIFICATION PART
		    ;; ========================================
		    ;; ---------- Update the table
		    (setf (rows 
			   (start-object (button-value *output-button*)))
		      (append 
		       (rows 
			(start-object (button-value *output-button*))) 
		       (make-binary-ratings construct-name items 
					    s0-region s1-region
					    pole-min pole-max)))
		    (enable-button triad-new-button)
		    (reset-button done-button)
		    (setf construct-name nil)))
   ;;; aggiungi protect-display
    (set-button randomize-button triad-class-disp
		:action 
		#'(lambda nil
		    (make-random-binary-placements items s0-region s1-region)
		    (reset-button randomize-button)))
    ;; ---------- Maybe get rid of that later
    (set-button randomize-button triad-class-disp)
    (format-display triad-instr 
		    "~%Now drag each element in the RIGHTMOST~
                     ~%field (entitled 'Unclassified') to the~
                     ~%most appropriate group-field by pointing with~
                     ~%the mouse on the element field and dragging it~
                     ~%while pressing the middle mouse key.~%~
                     ~%When all elements are classified,~
                     ~%click on the Button < D O N E >.")))


(defun make-random-binary-placements (items s1 s2)
  "Places an element randomly in a classification field."
  (declare (special *output-button*))
  (dolist (elem (reverse items))
    (let ((el (get-display elem 
			   (start-object (button-value *output-button*)))))
      (cond ((or (display-within-binary-region-p el s1) ; Already classified?
		 (display-within-binary-region-p el s2)))
	    (t (setf (left el)		; No -> Place randomly
		 (+ 4 (if (zerop (randomize 0 1))
			  (cw:region-left s1)
			(cw:region-left s2)))))))))

(defun check-binary-ratings (items s1 s2)
  "Returns nil when not all elements are classifed (ie. in region s1 or s2)."
  (declare (special *output-button*))
  (let ((result t))
    (dolist (elem (reverse items))
      (let ((el (get-display elem 
			     (start-object (button-value *output-button*)))))
	(cond ((or (display-within-binary-region-p el s1)
		   (display-within-binary-region-p el s2)))
	      (t (setf result nil)))))
    result))


(defun display-within-binary-region-p (display region)
  "Check whether the DISPLAY's midpoint lies within REGION."
  (when (and (displayp display)(cw:region-p region))
	(let ((display-midpoint-x (+ (left display)  
				     (/ (width display) 2)))
	      (display-midpoint-y (+ (bottom display)
				     (/ (+ (height display)
					   (font-character-height 
					    (font display)))
					2) )))
	  ;; ---------- Test
	  (cw:region-contains-point-p 
	   region display-midpoint-x display-midpoint-y))))


(defun make-binary-ratings (label items s1 s2 &optional (p0 0) (p1 1))
  "Make the ratings according to the placement of the element displays."
  (declare (special *output-button* *current-construct* *all-constructs*))
  (let (result ele-min ele-max)
    ;; ---------- Loop through all elements and assign appropriate ratings
    (dolist (elem (reverse items))
      (let ((el (get-display elem (start-object 
				   (button-value *output-button*)))))
	(cond ((display-within-binary-region-p el s1)
	       (push elem ele-min) (push p0 result))
	      ((display-within-binary-region-p el s2)
	       (push elem ele-max) (push p1 result))
	      ;; The rest should get NIL --- use the ID3-type DONTCARE
	      (t (push '* result)))))
    ;; ---------- Creat a construct object
    (setf *current-construct*
      (make-instance 'constructs
	:attributes '(0 1)
	:rows       (list ele-min ele-max)
	;; :title      label
	:scale      'binary
	:names      (list p0 p1)))
    ;; ---------- Add to list of constructs
    (push *current-construct* *all-constructs*)
    ;; ---------- SETF construct name to construct object
    (set (intern label) *current-construct*)
    ;; ---------- Add the name of the construct in front and return the list
    (push label result)
    (list result)))

;;; ==========================================================================
;;; Continous (interval) classification
;;; ==========================================================================


(defun triad-classify-interval (selection 
				others 
				triad-class-disp
				triad-disp 
				triad-instr 
				triad-classify-button 
				triad-new-button)
  "Elicit the names of the two construct-poles 
   and classify all elements onto interval values"
  (declare (special *verbose* *small-font-11* *default-font* *output-button*))
  (if (displayp triad-class-disp)
      (activate-display triad-class-disp)
    (push (display-error (format nil "Classification window not available")
			 :wait nil
			 :button-label "Click here to continue"
			 :title "ERROR:")
	  *triad-displays*))
  ;; Button control now down here
  (disable-button triad-new-button)
  (reset-button triad-classify-button)	; Reset from calling function
  (disable-button triad-classify-button) ; But stay disabled
  (let* ((items (cdr (attributes 
		      (start-object (button-value *output-button*)))))
	 (items-symb 
	  (mapcar #'intern 
		  (cdr (attributes 
			(start-object (button-value *output-button*))))))
	 (gap 4)
	 (pole-min-str
	  (string-cleanup
	   (ask (format nil 
	 "What is it about ' ~a ' that makes it DIFFERENT~
        ~%from the other elements ' ~{~a ~}' ?~
        ~%~%Please type in a descriptive label (one word/adjective):~%~%" 
			selection others)
		:title "RPG:Pole naming" :font (findfont (width triad-disp) 300 13)
		:left (left triad-disp) :bottom (bottom triad-disp))))
	 (pole-max-str    
	  (string-cleanup
	   (ask (format nil 
         "Please supply a description which expresses the~
         ~%SIMILARITY between the elements ' ~{~a ~}'~
         ~%in contrast to the element ' ~a '.~
         ~%~%Please type in a descriptive label (one word/adjective):~%~%" 
			others selection)
		:title "RPG:Pole naming" :font (findfont (width triad-disp) 300 13)
		:left (left triad-disp) :bottom (bottom triad-disp))))
	 (pole-min (intern (if (equal "" pole-min-str)
			       (read-from-string (format nil "~a" (gentemp 'r-)))
			     (read-from-string pole-min-str)) :dump))
	 (pole-max (intern (if (equal "" pole-max-str)
			       (read-from-string (format nil "~a" (gentemp 'r-)))
			     (read-from-string pole-max-str)) :dump))
	 (s-bottom         (+ 12 (* 2 (height triad-classify-button))))
	 (s-height         (- (height triad-class-disp) s-bottom 20))
	 ;; unclassified region
	 (sn-region        
	  (cw:make-region
	   :left    (- (width triad-class-disp) (* 4 gap) 100) 
	   :bottom  s-bottom   :height  s-height 
	   :width   (+ 100 (* 2 gap))))
	 (s-left           gap)
	 (s-width          (- (width triad-class-disp)
			      (cw:region-width sn-region)
			      (* 4 gap)))
	 (s-top (- (+ s-bottom s-height) 2))
	 ;; only one region necessary for check
	 (s0-region        (cw:make-region
			    :left    s-left   :bottom  s-bottom
			    :height  s-height :width   s-width))
	 (done-button      (make-instance 'push-button 
			     :label  " D o n e "
			     :left   gap
			     :width  s-width
			     :bottom 5))
	 (randomize-button 
	  (make-instance 'push-button 
	    :label  " Random "
	    :left   (+ gap (left done-button)(width done-button))
	    :width  100
	    :bottom 5))
	 (construct-name nil)
	 result top-pos bot-pos left-offset)
    (format-display *verbose* 
		    "; TRIAD-CLASSIFY-INTERVAL used to classify ~a" items)
    ;; ---------- NOTE: Don't use DISPLAYs
    ;; ---------- or the element-displays may disappear
    (activate-display triad-class-disp)
    (draw-filled-rectangle triad-class-disp 
			   0 0
			   (width  triad-class-disp) (height triad-class-disp)
			   :color white :operation boole-1)
    (write-display triad-class-disp "Place elements with middle mouse button."
		    10  (+ 5 (bottom done-button) (height done-button)))

    (set-button done-button triad-class-disp
		:action 
		#'(lambda nil
		    (unless construct-name
		      (setf construct-name
			(string-cleanup
			  (ask 
			   (format nil 
		 "Please enter a name for this CONSTRUCT~
                ~%with its poles ~a and ~a.~
                ~%Please type in a descriptive label (one word/noun):~%~%"
			    pole-min pole-max)
			   :title "RPG:Construct naming" :font (findfont (width triad-disp) 300 13)
			   :error-message "Input has to be a word"
			   :left (left triad-class-disp) 
			   :bottom (bottom triad-class-disp))))
		    (setf construct-name (intern (if (equal "" construct-name)
					     (read-from-string (format nil "~a" (gentemp 'c-)))
					   (read-from-string construct-name)) :dump)))
		    (unless (check-interval-ratings items s0-region)
		      (push (display-error 
			     (format nil
				     "Statistical analysis of your data~
                                    ~&might be affected when you decide~
                                    ~&not to classify ALL elements")
			     :button-label "Click here to continue"
			     :title "WARNING:")
			    *triad-displays*))
		    ;; ========================================
		    ;; LOCAL EXIT FROM THE CLASSIFICATION PART
		    ;; ========================================
		    ;; ---------- Update the table
		    (setf (rows 
			   (start-object (button-value *output-button*)))
		      (append (rows 
			       (start-object (button-value *output-button*))) 
			      (make-interval-ratings construct-name items 
						     s0-region pole-min 
						     pole-max)))
		    (enable-button triad-new-button)
		    (reset-button done-button)
		    (setf construct-name nil)))
    (set-button randomize-button triad-class-disp
		:action 
		#'(lambda nil
		    (make-random-interval-placements items s0-region)
		    (reset-button randomize-button)))
    ;; ---------- Maybe get rid of that later
    (set-button randomize-button triad-class-disp)
    ;; ---------- Draw bags
    (draw-rectangle triad-class-disp	; the "unclassified" bag
		    (cw:region-left   sn-region)
		    (cw:region-bottom sn-region)
		    (cw:region-width  sn-region)
		    (cw:region-height sn-region) )
    (draw-rectangle triad-class-disp	; the "unclassified" bag
		    (cw:region-left   s0-region)
		    (cw:region-bottom s0-region)
		    (cw:region-width  s0-region)
		    (cw:region-height s0-region) )
    ;; ---------- Provide titles for bags
    (setf (font triad-class-disp) *small-font-11*)
    (write-display triad-class-disp " Unclassified"
		   (cw:region-left   sn-region)
		   (+ s-bottom s-height gap) :operation boole-1)
    (setf (font triad-class-disp) *default-font*)
    ;; ----- draw some grid lines 
    (dotimes (i 11)
      (let ((y  (+ 1 (cw:region-bottom s0-region)
		   (* i (/ (cw:region-height s0-region) 10))))
	    (x1 (cw:region-left s0-region))
	    (x2 (+ (cw:region-left s0-region)(cw:region-width s0-region))))
	(write-display triad-class-disp 
		       (format nil "~3D" (* 10 i)) x1 (+ y gap) )
	(draw-line triad-class-disp x1 y x2 y)))
    (write-display triad-class-disp (format nil "(~a)" pole-min)
		   (+ 30 (cw:region-left  s0-region))
		   (+ s-bottom s-height gap) :operation boole-1)
    (write-display triad-class-disp (format nil "(~a)" pole-max)
		   (+ 30 (cw:region-left   s0-region))
		   (+ s-bottom gap)
		   :operation boole-1)
    ;; ---------- Create or update element displays
    (setf top-pos (- s-top 7))
    (setf bot-pos (- s-bottom 7))
    (setf left-offset (+ 10 (* 15 (font-character-width *default-font*))))
    (cond ((null (cdr (display 
		       (start-object (button-value *output-button*)))))
	   ;; ---------- Create for every element a window
	   (setf (display (start-object (button-value *output-button*)))
	     (dotimes (i (1+ (length items)) (nreverse result))
	       (push nil result)))
	   (dotimes (count (length items))
	       (setf (nth (1+ count) 
			  (display 
			   (start-object (button-value *output-button*))))
		 (make-instance 'display 
		  :title (nth count items-symb)
		  :active t
		  :parent triad-class-disp
		  :frame-menu nil
		  :borders 1
		  ;; ----- position inside the correct bag
		  :bottom (cond ((member (nth count items-symb) 
					 (list selection))
				 top-pos)
				((member (nth count items-symb) others)
				 bot-pos)
				(t 
				 (- (height triad-class-disp) 
				    40 (* count 20))))
		  ;; ----- decrease the position for every element
		  :left (cond ((member (nth count items-symb) 
				       (list selection))
			       (+ left-offset s-left))
			      ((member (nth count items-symb) others)
			       (+ left-offset
				  (* (position (nth count items-symb) others) 
				     105)))
			      (t 
			       (+ (cw:region-left sn-region) gap)))
		  :width 100 :height 1))))
	  (t 
	   ;; Move existing displays to appropriate place
	   (setf result 0)		; temp variable
	   (dolist (x (cdr (display 
			    (start-object (button-value *output-button*)))))
	     (setf (left x)
	       (cond ((member (title x) (list selection))
		      (+ left-offset s-left))
		     ((member (title x) others)
		      (+ left-offset
			 (* (position (nth result items-symb) others) 
			    105)))
		     (t 
		      (+ (cw:region-left sn-region) gap))))
	     (setf (bottom x) 
	       (cond ((member (title x) (list selection))
		      top-pos)
		     ((member (title x) others)
		      bot-pos)
		     (t 
		      (- (height triad-class-disp) 40 (* result 20)) )) )
	     (incf result)) ))
    (format-display triad-instr 
		    "~%Now drag each element in the RIGHTMOST~
                     ~%field (entitled 'Unclassified') to the~
                     ~%most appropriate position along the scale by~
                     ~%pointing with the mouse on the element field~
                     ~%and dragging it while pressing the~
                     ~%middle mouse key.~%~
                     ~%When all elements are classified,~
                     ~%click on the Button < D O N E >.")))


(defun make-random-interval-placements (items s1)
  "Places all unclassified items randomly 
   in the interval classification field s1"
  (declare (special *output-button*))
  (dolist (elem (reverse items))
    (let ((el (get-display elem 
			   (start-object (button-value *output-button*)))))
      (cond ((display-within-interval-region-p el s1))
	    (t 
	     (setf (left el)   
	       (randomize 100 (- (cw:region-width s1) 5 (width el))))
	     (setf (bottom el) 
	       (randomize (- (cw:region-bottom s1) 7) 
			  (- (+ (cw:region-bottom s1)
				(cw:region-height s1)) 7)))) ))))


(defun check-interval-ratings (items s1)
  "Returns nil when not all elements are classifed."
  (declare (special *output-button*))
  (let ((result t))
    (dolist (elem (reverse items))
      (let ((el (get-display 
		 elem (start-object (button-value *output-button*)))))
	(cond ((display-within-interval-region-p el s1))
	      (t (setf result nil)))))
    result))


(defun display-within-interval-region-p (display region)
  "Check whether the DISPLAY's midpoint lies within REGION"
  (when (and (displayp display)(cw:region-p region))
    (let ((display-midpoint-x (+ (left display)  
				 (/ (width display) 2)))
	  (display-midpoint-y (+ (bottom display)
				 (/ (+ (height display)
				       (font-character-height (font display)))
				    2) )))
      ;; ---------- Adjust height if necessary
	  
      (if (> display-midpoint-y 
	     (+ (cw:region-bottom region)(cw:region-height region)))
	  (setf (bottom display) 
	    (- (+ (cw:region-bottom region)(cw:region-height region)) 7)))
      (if (< display-midpoint-y (cw:region-bottom region))
	  (setf (bottom display) (- (cw:region-bottom region) 7)))
      ;; ---------- Test 
      (> (+ (cw:region-left region)(cw:region-width region)) 
	 display-midpoint-x))))


(defun make-interval-ratings (label items s1 &optional (p0 0) (p1 99))
  "Make the ratings according to the placement 
   (height) of the element displays."
  (declare (special *output-button* *current-construct* *all-constructs*))
  (let (result ele-min ele-max)
    ;; ---------- Loop through all elements and assign appropriate ratings
    (dolist (elem (reverse items))
      (let* ((el (get-display elem (start-object 
				   (button-value *output-button*))))
	     (mid (+ (bottom el)
		     (/ (+ (height el)
			   (font-character-height (font el)))
			2))))
	(cond ((display-within-interval-region-p el s1)
	       ;; ---------- Convert midpoint to value within [0.0,100.0]
	       (push  (float (floor (/ (* 100 (- mid (cw:region-bottom s1)))
				(cw:region-height s1))))
		      result) )
	      (t 
	       ;; The rest should get NIL --- use the ID3-type DONTCARE
	       (push '* result)))))
    ;; ---------- Create a construct object --- for later use
    (setf *current-construct*		; an object
      (make-instance 'constructs
	:attributes '(0 1)
	:rows       (list ele-min ele-max)
	:title      label
	:scale      'interval
	:names      (list p0 p1)))
    ;; ---------- Add to list of constructs
    (push *current-construct* *all-constructs*)  ; a list of objects
    ;; ---------- Add the name of the construct in front
    (push label result)		
    (list result)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
