(defclass rpg-triad-window (display)
  ((instruction-window    :initarg :instruction-window
			  :accessor instruction-window
			  :initform nil)
   (elements-button       :initarg :elements-button
			  :accessor elements-button
			  :initform nil)
   (triad-button          :initarg :triad-button
			  :accessor triad-button
			  :initform nil)
   (classify-button       :initarg :classify-button
			  :accessor classify-button
			  :initform nil)
   (exit-button           :initarg :exit-button
			  :accessor exit-button
			  :initform nil)
   (classify-menu         :initarg :classify-menu
			  :accessor classify-menu
			  :initform nil)
   (display-width         :initarg :display-width
			  :accessor display-width
			  :initform nil)
   (display-height        :initarg :display-height
			  :accessor display-height
			  :initform nil)
   ))

(defclass triad-classification-window (display)
  ((done-button           :initarg :done-button
			  :accessor done-button
			  :initform nil)
   (randomize-button      :initarg :randomize-button
			  :accessor randomize-button
			  :initform nil)
   (classification-needs-saving-p
                          :initarg :classification-needs-saving-p
			  :accessor classification-needs-saving-p
			  :initform t)))

(defmethod initialize-instance ((tcw triad-classification-window)  &rest whatever)
  (call-next-method)
  (setq gin::*default-display-border* 1)
  (setf (done-button tcw)
    (make-instance 'push-button 
      :label  " D o n e "
      :left   s-left
      :width  (+ 8 (* 2 s-width))
      :bottom 5))
  (setf (randomize-button tcw)
    (make-instance 'push-button 
	    :label  " Random "
	    :left   (+ 4 (left (done-button tcw)) (width (done-button tcw)))
	    :width  100
	    :bottom 5))
  (set-buttons tcw))

(defmethod set-buttons ((tcw triad-classification-window))



(defmethod initialize-instance ((tcw triad-classification-window)  &rest whatever)
  (setf (title tcw) "RPG:Triad Classification Window")

   (make-instance 'display 
		  :title "RPG:Triad Classification Window"
		  :active nil
		  :left   (+ (width triad-disp)(left triad-disp))
		  :bottom (bottom triad-disp)
		  :width (- (width *root-window*) menu-width 10) :height (height triad-disp)))
 

(defmethod get-construct-name ((tcw triad-classification-window)
			       (pole-min pole-max))
  (string-cleanup
   (ask 
    (format nil 
	    "Please enter a name for this CONSTRUCT~
~%with its poles ~a and ~a.~
~%Please type in a descriptive label (one word/noun):~%~%"
	    pole-min pole-max)
    :title "RPG:Construct naming"
    :font (findfont (width triad-disp) 300 13)
			  :error-message "Input has to be a word"
			  :left (left triad-class-disp) 
			  :bottom (bottom triad-class-disp))))







(defmethod supply-description ((rtw rpg-triad-window) others selection)
  (string-cleanup
   (ask 
    (format 
     nil 
     "Please supply a description which expresses the~
~%SIMILARITY between the elements ' ~{~a ~}'~
~%in contrast to the element ' ~a '.~
~%~%Please type in a descriptive label (one word/adjective):~%~%" 
     others selection)
    :title "RPG:Pole naming"
    :font (findfont (width rtw) 300 13)
    :left (left rtw) :bottom (bottom rtw))))

(defmethod supply-difference ((rtw rpg-triad-window) others selection)
  (string-cleanup
   (ask 
    (format 
     nil 
     "What is it about ' ~a ' that makes it DIFFERENT~
~%from the other elements ' ~{~a ~}' ?~
~%~%Please type in a descriptive label (one word/adjective):~%~%" 
     selection others)
    :title "RPG:Pole naming"
    :font (findfont (width rtw) 300 13)
    :left (left rtw)
    :bottom (bottom rtw))))
