;;; -*- Mode: LISP; Package: common-lisp-user; Syntax: Common-lisp;      -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rpg-make
;;; Short Desc: Compile & load code & documentation
;;; Version:    1.0b
;;; Status:     Beta testing
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Thu Feb 20 00:59:32 1992
;;; Update Count    : 4
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================

(in-package :rpg)

(defvar *verbose* nil "Boolean flag to enable/disable verbose mode")
(setf *verbose* *verbose-default*)	; Set to user's default

(eval-when (eval load compile)
  (export '(*rpgpath*)))


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================

(defparameter *rpgpath* (add-subdir *pail-path* "rpg"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))


;;; ==========================================================================
;;; FILE LOADING SEQUENCE
;;; ==========================================================================

;;; Load in auxiliary PAIL-LIB files
(ensure-loaded (add-path "tables"    *libpath*))
(ensure-loaded (add-path "table-ed"  *libpath*)) ; requires TABLES
(ensure-loaded (add-path "trees"     *libpath*))
(ensure-loaded (add-path "browser"   *libpath*)) ; requires TREES

;;; Load in the module-specific files
;;; (ensure-loaded (add-path "ut-rand"          *rpgpath*))
(ensure-loaded (add-path "rpg-lib"          *rpgpath*))
(ensure-loaded (add-path "rpg-input"        *rpgpath*))
(ensure-loaded (add-path "rpg-cluster"      *rpgpath*))
(ensure-loaded (add-path "rpg-ascii-dialog" *rpgpath*))
(ensure-loaded (add-path "rpg-da1"          *rpgpath*))


;;; ==========================================================================
;;; ADDITIONAL FILES AND VARIABLES FOR THE GRAPHICAL INTERFACE
;;; ==========================================================================

(if *gin-p* 
    (progn
      (ensure-loaded (add-path "rpg-browser" *rpgpath*))
      (ensure-loaded (add-path "rpg-dialog"  *rpgpath*))
      (ensure-loaded (add-path "rpg-triad"   *rpgpath*))
      (defparameter *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "rpg-ex~a" i) 
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "rpg-ex~a" i) 
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *rpgpath*))) (1- i))
	    (ensure-loaded (add-path name *rpgpath*)))))
  )


(eval-when (eval load)
  (if pail::*gin-p*
    (pail::documentation-print "RepGrid 1.0b routines successfully loaded.

  Click on the < Tool > Button to continue
  or   use the < Help > Button to get more information.~%")
    (format t "~%RPG routines loaded.~%")))


;;; In case of troubles:
;;; (gin::reset-button pail::rpg-button)
;;; (close pail::*prompt-window*)
;;; (setf lisp:*load-verbose* nil)
;;; (setf lisp:*compile-verbose* nil)
;;; (setf lisp:*load-verbose* t)

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
