;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rpg-ex1
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   07.06.91 - ro
;;; Author:     Thomas Rothenfluh
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;; Use the functions below to make a demo run in the Lisp Listener


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rpg)

(eval-when (load eval compile)
  (export  '(*ex1-elements* *ex1-ratings* *ex1-subtable*
	     dialog-1 do-all-triads-1 construct)))


;;; Local globals (what a concept!)
(defvar *ex1-elements*   nil)
(defvar *ex1-ratings*    nil)
(defvar *ex1-subtable*   nil)
(defvar *verbose*        nil)

;;; ==========================================================================
;;; DEMO FUNCTIONS
;;; ==========================================================================


;;; Separate function in order to allow later re-entrance
;;; (i.e., continuation of construct elicitation)
(defun do-all-triads-1 (&optional (comment-disp t) (data-disp t) (verbose-disp t))
  "Loop through all triples until USER aborts."
  (let (poles labels) 
    (cond ((< (triples :length t) 1)
	   (format-display verbose-disp
			   "~%~%No more triads to do.~%"))
	  ((y-or-n-query "Do you want to continue with eliciting triads? "
			      :title "Please click on appropriate button ")
	   (setf poles
	     (extract-element (triples :pop-random t) verbose-disp) )
	   (setf labels (name-construct-poles poles nil verbose-disp))
	   (setf *ex1-ratings* (define-construct 
			    labels *ex1-elements* verbose-disp))
	   (check-ratings *ex1-elements* *ex1-ratings* verbose-disp)
	   (when *verbose* *ex1-elements*)
	   (setf *ex1-subtable*
	     (get-table (cdr (attributes *ex1-elements*)) *ex1-elements*))
	   (do-all-triads-1 comment-disp data-disp verbose-disp))
	  (t
	   (format-display verbose-disp
			   "~%~%Ok, you can resume with (do-all-triads-1) ~
                    ~%or with (cluster-it (table-to-array *ex1-subtable*) t) ~
                      to cluster your data.") ))))


(defun dialog-1 (&optional (comment-disp t)
			   (data-disp t)
			   (verbose-disp t))
  "Demo run of Repertory Grid on the Listener."
  (declare (special *gin-p* *verbose*
		    *ex1-elements* *ex1-ratings*))
  (let ()
    (when (and (displayp comment-disp)
	       (displayp verbose-disp))
      (renew-scroll comment-disp)
      (renew-scroll verbose-disp))
    (cond ((and (boundp *gin-p*) (not *gin-p*) (not *verbose*))
	   (setf *verbose* (y-or-n-query "Do you want a verbose run? "))))
    (cond ((and (boundp *gin-p*) (not *gin-p*) *verbose*)
	   (setf verbose-disp t))
	  ((and (boundp *gin-p*) (not *gin-p*))
	   (setf verbose-disp nil)))
    ;; Initialize all important data structures
    (setf *ex1-elements* nil)
    (setf *ex1-ratings*  nil)
    (format-display comment-disp "~%~%Welcome to the Rep Grid Module.")
    ;; Let the user enter all ELEMENTS
    (setf *ex1-elements* 
      (input-elements nil comment-disp verbose-disp))
    ;; Generate all TRIADs
    (triples :init (attributes *ex1-elements*))
    ;; Expand Table with CONSTRUCT attribute
    (push 'construct (attributes *ex1-elements*))
    ;; Step through all triads
    (do-all-triads-1 comment-disp data-disp verbose-disp) 
    (cluster-it (table-to-array *ex1-subtable*) *verbose*)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
