;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:RPG; Base:10; -*-
;;;
;;; ***************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH 
;;;
;;; ***************************************************************************
;;;
;;; Filename:   rpg-ascii-dialog
;;; Short Desc: Demo function to run Rep Grid stuff
;;; Version:    1.0b
;;; Status:     Review
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; --------------------------------------------------------------------------
;;; Last Modified By: Thomas E. Rothenfluh
;;; Last Modified On: Tue Feb 18 19:01:34 1992
;;; Update Count    : 2
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;; Use the functions below to make a demo run


;;; ---------------------------------------------------------------------------
;;; Export functions and variables
;;; ---------------------------------------------------------------------------

(in-package :rpg)

(eval-when (load eval compile)
  (export  '(*ad-elements* *ad-ratings* *ad-subtable* 
	     start-ascii-grid do-all-triads  rpg-demo)))


;;; ---------------------------------------------------------------------------
;;; TEST SCRIPT
;;; ---------------------------------------------------------------------------

(defvar *ad-elements*   nil)
(defvar *ad-ratings*    nil)
(defvar *ad-subtable*   nil)
(defvar *verbose*       nil)

(defun start-ascii-rpg ()
  "Runs a session with the Repertory Grid Program."
  ;; Initialize streams
  (let ((*user-out-stream*  t)
	(*user-in-stream*   t))
    (setf *ad-elements*         nil)
    (setf *ad-ratings*          nil)
    (setf *ad-subtable*       nil)
    (format *user-out-stream* "~%~%Welcome to the Rep Grid Module.~%~%")
    ;; Let the user enter all ELEMENTS to be used
    (setf *ad-elements* 
      (input-elements nil *user-out-stream* *user-in-stream*))
    ;; Generate all TRIADs
    (triples :init (attributes *ad-elements*))
    ;; Expand Table with CONSTRUCT attribute
    (push 'construct (attributes *ad-elements*))
    ;; Step through all triads
    (do-all-triads *user-out-stream* *user-in-stream*)))


(defun do-all-triads (&optional (out-stream t)(in-stream t))
  "Loop through all triples until USER aborts."
  (let (poles labels) 
    (cond ((< (triples :length t) 1)
	   (format out-stream
		   "~%~%No more triads to do.~%"))
	  ((y-or-n-p "~&Do you want to continue with eliciting triads? ")
	   (setf poles
	       (extract-element (triples :pop-random t) out-stream) )
	   (setf labels (name-construct-poles poles nil out-stream in-stream))
	   (setf *ad-ratings* (define-construct 
			    labels *ad-elements* out-stream in-stream))
	   (check-ratings *ad-elements* *ad-ratings* out-stream)
	   (when *verbose* *ad-elements*)
	   (setf *ad-subtable*
	     (get-table (cdr (attributes *ad-elements*)) *ad-elements*))
	   (do-all-triads) 		; continue?
	   )
	  (t
	   (format out-stream
		   "~%~%Ok, you can resume with (do-all-triads). ~
                    ~%or with (cluster-it (table-to-array *ad-subtable*) t) ~
                      to cluster your data.") ))))


(defun rpg-ascii-demo ()
  "Run a demo for the Repertory Grid system."
  (when (and (not *verbose*)
	     (y-or-n-p "Do you want a verbose run? "))
    (setf *verbose* t))
  (start-ascii-rpg)
  (cluster-it  (table-to-array *ad-subtable*) *verbose*))

;;; EXAMPLE usage:
;;; (rpg-ascii-demo)


;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================

