;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   wrong-trains-ex.cl
;;; Short Desc: Simple example to show that temporal features 
;;;             are not straightforward using TMS.
;;;             (Please refer to right-trains-ex.cl)
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   10.02.91 - Fatma FEKIH-AHMED
;;; Author:     Fatma FEKIH-AHMED
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; -------------------------------------------------------
;;; RCS $Log: wrong-trains-ex.cl,v $
;;; Revision 1.1  1992/02/20  16:35:10  fekih
;;; Initial revision
;;;
;;; -------------------------------------------------------


;;; =======================================================================
;;; PACKAGE DECLARATIONS
;;; =======================================================================

(in-package common-lisp-user)
(EVAL-WHEN (COMPILE LOAD EVAL)
	   (DATABASE:MAKESYMS '.%%symbol-label%%. 0 4 "common-lisp-user"))

(setq database:*db-input* 
  (setq .%%symbol-label%%.3 
    (make-instance 'pail-lib::poolfile 
      :real-contents (list 
		      (setq .%%symbol-label%%.4 
			(make-instance 'pail-lib:pool-item 
			  :from-button nil 
			  :start-object 
			  (setq .%%symbol-label%%.5 
			    (make-instance 'pail-lib:tre-example 
			      :contradiction '((gtre::contradiction 'contradiction-found))
			      :assertions '(
					   (gtre::assert! '(passage 1 12))
					   (gtre::assert! '(passage 1 14))

					   (gtre::assert! '(passage 2 12))
					   (gtre::assert! '(passage 2 13))

					   (gtre::assert! '(passage 3 12))

					   (gtre::assert! '(voie-libre 1 12))
					   (gtre::assert! '(voie-libre 1 13))
					   (gtre::assert! '(voie-libre 1 14))
			   
					   (gtre::assert! '(voie-libre 2 12))
					   (gtre::assert! '(voie-libre 2 13))
					   (gtre::assert! '(voie-libre 2 14))
					   )
			      :rule-set '( 	
					 (gtre::rule ((:in (passage ?t ?h) :var ?J1)
						      (:in (voie-libre ?v ?h) :var ?J2))
					  (gtre::rassert! (arrivee ?t ?v ?h)
							  (justif (:in ?J1) (:in ?J2))))

					 (gtre::rule ((:in (arrivee ?t ?v ?h) :var ?J1)
						      (:in (voie-libre ?v ?h) :var ?J2))
					  (gtre::rassert! contradiction-found
					   (justif (:in ?J1) (:in ?J2)))))
			      :name-part nil)) 
			    :name-part "wrong-trains"))) 
		      :contents 
		      (list (setq .%%symbol-label%%.6 
			      (make-instance 'pail-lib::filentry 
				:classname "tre-example" 
				:poolname "trains"))) 
		      :filename "trains-ex.cl")))

(defun neq (x1 x2)
  (not (eq x1 x2)))


;;; =======================================================================
;;; END OF FILE
;;; ======================================================================= 
