;;; -*- Mode: LISP; Package: GTRE-EXAMPLE; Syntax: Common-lisp; -*-
;;;
;;; *******************************************************
;;;
;;; PORTABLE AI LAB - EPFL
;;;
;;; *******************************************************
;;;
;;; Filename:   cliche-ex.cl
;;; Short Desc: CLICHE: a CLInical CHemist Expert system
;;;             developped using NMJTMS/NMJTRE
;;; Version:    1.1
;;; Status:     experimental
;;; Last Mod:   05.02.92 - F. FEKIH-AHMED
;;; Authors:    Francois Bachmann & Fatma FEKIH-AHMED
;;;
;;; -------------------------------------------------------
;;; RCS $Log: cliche-ex.cl,v $
;;; Revision 1.1  1992/02/20  16:35:10  fekih
;;; Initial revision
;;;
;;; Revision 1.1  1992/02/20  16:35:10  fekih
;;; Initial revision
;;;
;;; -------------------------------------------------------
(in-package gtre-example)
(import '(pail-lib::tre-example
	  gtre::rule
	  gtre::assert!
	  gtre::rassert!
	  gtre::retract!
	  gtre::rretract!
	  gtre::contradiction ))


(EVAL-WHEN (COMPILE LOAD EVAL)
                       (DATABASE:MAKESYMS '.%%symbol-label%%. 0 4 "common-lisp-user"))


;;;=========================================================
;;; USEFUL FUNCTION
;;;=========================================================

(defun neq (x y)
  (not (eql x y)))
 
;;;=========================================================
;;;CLICHE Version 1.0
;;;=========================================================

(setq database:*db-input* 
  (setq .%%symbol-label%%.1 
    (make-instance 'pail-lib::poolfile 
      :real-contents 
      (list (setq .%%symbol-label%%.2 
	      (make-instance 'pail-lib:pool-item 
		:from-button nil 
		:start-object 
		(setq .%%symbol-label%%.3 
		  (make-instance 'pail-lib:tre-example 
		    :contradiction '((contradiction 'Contradiction-found))
		    :assertions '(
				  ; values are all mmol/mol creatinine
				  ; EXCEPT for P-ARG and P-NH3 which are in umol/l

				  (assert! '(max-p-nh3 50) 'gtre::GOD)
				  (assert! '(max-p-nh3-newb 150) 'gtre::GOD)
				    
				  (assert! '(min-p-arg 30) 'gtre::GOD)
				  (assert! '(max-p-arg 150) 'gtre::GOD)
				  (assert! '(min-p-citr 5) 'gtre::GOD)
				  (assert! '(max-p-citr 50) 'gtre::GOD)
				  
				  (assert! '(max-p-prop 4) 'gtre::GOD)
				  
				  (assert! '(max-u-3ohprop 20) 'gtre::GOD)
				  (assert! '(max-u-hiva 40) 'gtre::GOD)
				  (assert! '(max-u-lact 200) 'gtre::GOD)
				  (assert! '(max-u-meth-citr 12) 'gtre::GOD)
				  (assert! '(max-u-mma 10) 'gtre::GOD)
				  
				  (assert! '(max-u-orot 5) 'gtre::GOD)
				  
				  (assert! '(max-u-asa 20) 'gtre::GOD)
				  (assert! '(max-u-homocyst 2) 'gtre::GOD)
				  
				 ; default value for each parameter is NORM
				 ; remember: no justification is equivalent to 
				 ;(just 'GTRE::USER)
				 ;therefore these are assumptions, overriden by
				 ;any given parameter value. 

				  (assert! '(NORM p-nh3))
				  (assert! '(NORM p-arg))
				  (assert! '(NORM p-citr))
				  (assert! '(NORM p-prop))
				  (assert! '(NORM u-3-hy-prop))
				  (assert! '(NORM u-3-hy-isov))
				  (assert! '(NORM u-lact))
				  (assert! '(NORM u-meth-citr))
				  (assert! '(NORM u-meth-mal))
				  (assert! '(NORM u-orot))
				  (assert! '(NORM u-asa))
				  (assert! '(NORM u-hom-cyst)))
				  				  
		    :rule-set 
		    '(
		       ; rules for detecting HIGH or LOW parameter 
		       ; values
				  
		      (rule ((:in (max-p-nh3 ?val1) :var ?max)
			     (:in (p-nh3 ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH p-nh3)
			(just (:in ?max) (:in ?lab-data1))))
				
		      (rule ((:in (min-p-nh3 ?val1) :var ?min)
			     (:in (p-nh3 ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW p-nh3)
			(just (:in ?min) (:in ?lab-data1))))

		      (rule ((:in (max-p-arg ?val1) :var ?max)
			     (:in (p-arg ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH p-arg)
			(just (:in ?max)(:in ?lab-data1))))
				  
		      (rule ((:in (min-p-arg ?val1) :var ?min)
			     (:in (p-arg ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW p-arg)
			(just (:in ?min)(:in ?lab-data1))))
				  
		      (rule ((:in (max-p-citr ?val1) :var ?max)
			     (:in (p-citr ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH p-citr)
			(just (:in ?max)(:in ?lab-data1))))
				  
		      (rule ((:in (min-p-citr ?val1) :var ?min)
			     (:in (p-citr ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW p-citr)
			(just (:in ?min)(:in ?lab-data1))))
				  
		      (rule ((:in (max-p-prop ?val1) :var ?max)
			     (:in (p-prop ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH p-prop)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-p-prop ?val1) :var ?min)
			     (:in (p-prop ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW p-prop)
			(just (:in ?min)(:in ?lab-data1))))
				  
		      (rule ((:in (max-u-3ohprop ?val1) :var ?max)
			     (:in (u-3-hy-prop ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-3-hy-prop)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-u-3ohprop ?val1) :var ?min)
			     (:in (u-3-hy-prop ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-3-hy-prop)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-hiva ?val1) :var ?max)
			     (:in (u-hiva ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-3-hy-isov)
			(just (:in ?max)(:in ?lab-data1))))
		      
		      (rule ((:in (min-u-hiva ?val1) :var ?min)
			     (:in (u-hiva ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-3-hy-isov)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-lact ?val1) :var ?max)
			     (:in (u-lact ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-lact)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-u-lact ?val1) :var ?min)
			     (:in (u-lact ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-lact)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-meth-citr ?val1) :var ?max)
			     (:in (u-meth-citr ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-meth-citr)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-u-meth-citr ?val1) :var ?min)
			     (:in (u-meth-citr ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-meth-citr)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-mma ?val1) :var ?max)
			     (:in (u-mma ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-meth-mal)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-u-mma ?val1) :var ?min)
			     (:in (u-meth-mal ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-meth-mal)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-orot ?val1) :var ?max)
			     (:in (u-orot ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-orot)
			(just (:in ?max)(:in ?lab-data1))))
			   
		      (rule ((:in (min-u-orot ?val1) :var ?min)
			     (:in (u-orot ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-orot)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-asa ?val1) :var ?max)
			     (:in (u-asa ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-asa)
			(just (:in ?max)(:in ?lab-data1))))
		      
		      (rule ((:in (min-u-asa ?val1) :var ?min)
			     (:in (u-asa ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-asa)
			(just (:in ?min)(:in ?lab-data1))))

		      (rule ((:in (max-u-homocyst ?val1) :var ?max)
			     (:in (u-homocyst ?val2) :var ?lab-data1
			      :test (> ?val2 ?val1)))
		       (rassert! (HIGH u-hom-cyst)
			(just (:in ?max)(:in ?lab-data1))))

		      (rule ((:in (min-u-homocyst ?val1) :var ?min)
			     (:in (u-homocyst ?val2) :var ?lab-data1
			      :test (< ?val2 ?val1)))
		       (rassert! (LOW u-hom-cyst)
			(just (:in ?min)(:in ?lab-data1))))

			; rules for inconsistencies worst case first 
			; (should never occur, but the user may
	      		;  assert such a thing which is clearly 
       			;  contradictory...)

		      (rule ((:in (LOW ?param) :var ?dilemma-lo)
			     (:in (HIGH ?param) :var ?dilemma-hi))
		       (rassert! Contradiction-Found
			(just ?dilemma-lo ?dilemma-hi )))

		        ; if there is evidence for LOW 
			; (and if there weren't, we wouldn't get LOW)
		        ; then retract NORM directly 
			; this saves the user much interactive work

		      (rule ((:in (LOW ?param) :var ?override)
			     (:in (NORM ?param) :var ?default))
		       (rretract! ?default ))

					; same thing for HIGH
		      (rule ((:in (NORM ?param) :var ?default)
			     (:in (HIGH ?param) :var ?override))
		       (rretract! ?default ))
			     
			   		    
					; Abductions that can be made of a special 
					; value of p-nh3	


		      (rule ((:in (HIGH p-nh3) :var ?trigger-1)
			     (:in (DISEASE citrullinemia) :var ?trigger-2))
		       (rassert! (CAUSE-OF (HIGH p-nh3) citrullinemia )
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))


		      (rule ((:in (HIGH p-nh3) :var ?trigger-1)
			     (:out (HIGH u-orot) :var ?trigger-2))

		       (rassert! (DISEASE cps-nags)
			(just (:in ?trigger-1)
			 (:out ?trigger-2)))
		       (rassert! (CAUSE-OF (HIGH p-nh3) cps-nags)
			(just (:in ?trigger-1)
			 (:out ?trigger-2)
			 (:in (DISEASE cps-nags)))))

		      (rule ((:in (HIGH p-nh3) :var ?trigger-1))
		       (rassert! (DISEASE otc-deficiency ))
		       (rassert! (DISEASE pyc-deficiency ))
		       (rassert! (DISEASE argininemia ))
		       (rassert! (DISEASE al-deficiency ))
		       (rassert! (DISEASE prop-deficiency ))
		       (rassert! (DISEASE biot-deficiency ))
		       (rassert! (DISEASE mm-aciduria ))
		       (rassert! (DISEASE bact-overgrowth )))

					; Abductions that can be made of a special 
					; value of p-arg (high)

		      (rule ((:in (HIGH p-arg) :var ?trigger-1)
			     (:in (DISEASE argininemia) :var ?trigger-2))
		       (rassert! (CAUSE-OF (HIGH p-arg) argininemia)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH p-arg) :var ?trigger-1))
		       (rassert! (DISEASE al-deficiency))
		       (rassert! (DISEASE argininemia)))

		      (rule ((:in (HIGH p-arg) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency citrullinemia 
						 prop-deficiency biot-deficiency 
						 mm-aciduria cps-nags al-deficiency))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special 
					; value of p-arg (low)

		      (rule ((:in (LOW p-arg) :var ?trigger-1))
		       (rassert! (DISEASE al-deficiency))
		       (rassert! (DISEASE cps-nags)))
					
		      (rule ((:in (LOW p-arg) :var ?trigger-1)
			     (:in (DISEASE al-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF LOW VALUE FOR p-arginine IS al-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (LOW p-arg) :var ?trigger-1)
			     (:in (DISEASE cps-nags) :var ?trigger-2))
		       (rassert! (CAUSE-OF LOW VALUE FOR p-arg IS cps-nags)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (LOW p-arg) :var ?trigger-1))
		       (rassert! (DISEASE otc-deficiency))
		       (rassert! (DISEASE citrullinemia))
		       (rassert! (DISEASE pyc-deficiency))
		       (rassert! (DISEASE prop-deficiency)))
					  
		      (rule ((:in (LOW p-arg) :var ?trigger-1)
			     (:in (DISEASE argininemia) :var ?trigger-2))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special
					; value of citrullin (low)

		      (rule ((:in (LOW p-citr) :var ?trigger-1))
		       (rassert! (DISEASE otc-deficiency))
		       (rassert! (DISEASE argininemia))
		       (rassert! (DISEASE cps-nags)))

		      (rule ((:in (LOW p-citr) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(citrullinemia al-deficiency))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special
					; value of citrullin (high)

		      (rule ((:in (HIGH p-citr) :var ?trigger-1)
			     (:in (HIGH u-orot) :var ?trigger-2))
		       (rassert! (DISEASE citrullinemia)))

					; we need a combination of citrullin and 
					; orotic acid to be sure about citrullinemia	

		      (rule ((:in (HIGH p-citr) :var ?trigger-1)
			     (:in (HIGH u-orot) :var ?trigger-2)
			     (:in (DISEASE citrullinemia) :var ?trigger-3))

		       (rassert! (CAUSE-OF HIGH VALUE OF p-citr IS citrullinemia)
			(just (:in ?trigger-1)
			 (:in ?trigger-3)))
		       (rassert! (CAUSE-OF HIGH VALUE OF u-orot IS citrullinemia)
			(just (:in ?trigger-2)
			 (:in ?trigger-3))))

		      (rule ((:in (HIGH p-citr) :var ?trigger-1))
		       (rassert! (DISEASE pyc-deficiency))
		       (rassert! (DISEASE argininemia))
		       (rassert! (DISEASE al-deficiency)))

		      (rule ((:in (HIGH p-citr) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency cps-nags))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special     
					; value ofpropionic acid 

		      (rule ((:in (HIGH p-prop) :var ?trigger-1))
		       (rassert! (DISEASE prop-deficiency))
		       (rassert! (DISEASE mm-aciduria)))

		      (rule ((:in (HIGH p-prop) :var ?trigger-1)
			     (:in (DISEASE prop-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR p-prop IS prop-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH p-prop) :var ?trigger-1)
			     (:in (DISEASE mm-aciduria) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR p-prop IS mm-aciduria)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH p-prop) :var ?trigger-1))
		       (rassert! (DISEASE biot-deficiency))
		       (rassert! (DISEASE cbl-deficiency))
		       (rassert! (DISEASE bact-overgrowth)))

		      (rule ((:in (HIGH p-prop) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency citrullinemia 
						 pyc-deficiency ))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special 
					; value of 3-oh-propionic acid

		      (rule ((:in (HIGH u-3-hy-prop) :var ?trigger-1))
		       (rassert! (DISEASE prop-deficiency))
		       (rassert! (DISEASE mm-aciduria)))

		      (rule ((:in (HIGH u-3-hy-prop) :var ?trigger-1)
			     (:in (DISEASE prop-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-3-hy-prop IS prop-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-3-hy-prop) :var ?trigger-1)
			     (:in (DISEASE mm-aciduria) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-3-hy-prop IS mm-aciduria)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))
	

		      (rule ((:in (HIGH u-3-hy-prop) :var ?trigger-1))
		       (rassert! (DISEASE biot-deficiency))
		       (rassert! (DISEASE cbl-deficiency))
		       (rassert! (DISEASE bact-overgrowth)))
					  
					; Abductions that can be made of a special 
					; value of hydroxyisovalerate

		      (rule ((:in (HIGH u-3-hy-isov) :var ?trigger-1)
			     (:in (HIGH u-lact) :var ?trigger-2)
			     (:in (HIGH u-meth-mal) :var ?trigger-3))
		       (rassert! (DISEASE biot-deficiency)))
	
		      (rule ((:in (HIGH u-3-hy-isov) :var ?trigger-1)
			     (:in (DISEASE biot-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-3-hy-isov IS biot-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-3-hy-isov) :var ?trigger-1))
		       (rassert! (DISEASE mm-aciduria))
		       (rassert! (DISEASE bact-overgrowth)))
	
					; Abductions that can be made of a special 
					; value of lactate
		      (rule ((:in (HIGH u-lact) :var ?trigger-1))
		       (rassert! (DISEASE pyc-deficiency))
		       (rassert! (DISEASE biot-deficiency)))

		      (rule ((:in (HIGH u-lact) :var ?trigger-1)
			     (:in (HIGH u-3-hy-isov) :var ?trigger-2)
			     (:in (HIGH u-3-meth-citr) :var ?trigger-3)
			     (:in (DISEASE biot-deficiency) :var ?trigger-4))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-lact IS biot-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2)
			 (:in ?trigger-3)
			 (:in ?trigger-4))))

		      (rule ((:in (HIGH u-lact) :var ?trigger-1)
			     (:in (DISEASE pyc-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-lact IS pyc-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-lact) :var ?trigger-1))
		       (rassert! (DISEASE otc-deficiency))
		       (rassert! (DISEASE prop-deficiency))
		       (rassert! (DISEASE mm-aciduria))
		       (rassert! (DISEASE bact-overgrowth)))
					  
					; Abductions that can be made of a special 
					; value of methyl citrate

		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:out (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(prop-deficiency biot-deficiency 
						 mm-aciduria cbl-deficiency))))
		       (rassert! ?trigger-2))
				
		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:in (HIGH u-lact) :var ?trigger-2)
			     (:in (HIGH u-3-hy-isov) :var ?trigger-3)
			     (:in (DISEASE biot-deficiency) :var ?trigger-4))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-citr IS biot-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2)
			 (:in ?trigger-3)
			 (:in ?trigger-4))))

		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:out (HIGH u-meth-mal) :var ?trigger-2) 
			     (:in (DISEASE prop-deficiency) :var ?trigger-3))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-citr IS prop-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2)
			 (:in ?trigger-3))))

		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:in (DISEASE cbl-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-citr IS cbl-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:in (DISEASE mm-aciduria) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-citr IS mm-aciduria)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-meth-citr) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency citrullinemia 
						 pyc-deficiency argininemia
						 al-deficiency bact-overgrowth 
						 cps-nags))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; rules for methyl malonate

		      (rule ((:in (HIGH u-meth-mal) :var ?trigger-1))
		       (rassert! (:in (DISEASE mm-aciduria)))
		       (rassert! (:in (DISEASE cbl-deficiency))))

		      (rule ((:in (HIGH u-meth-mal) :var ?trigger-1)
			     (:in (DISEASE mm-aciduria) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-mal IS mm-aciduria)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-meth-mal) :var ?trigger-1)
			     (:in (DISEASE cbl-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-meth-mal IS cbl-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))


		      (rule ((:in (HIGH u-meth-mal) :var ?trigger-1))
		       (rassert! (DISEASE bact-overgrowth)))

		      (rule ((:in (HIGH u-meth-mal) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(pyc-deficiency biot-deficiency 
						 cps-nags))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (LOW u-meth-mal) :var ?trigger-1)
			     (:in (DISEASE prop-deficiency) :var ?trigger-2)
			     (:in (HIGH u-meth-citr) :var ?trigger-3))
		       (rassert! ?trigger-2 
			(just (:out ?trigger-1)
			 (:in ?trigger-2)
			 (:in ?trigger-3))))

		      (rule ((:in (NORM u-meth-mal) :var ?trigger-1)
			     (:in (DISEASE prop-deficiency) :var ?trigger-2)
			     (:in (HIGH u-meth-citr) :var ?trigger-3))
		       (rassert! ?trigger-2 
			(just (:in ?trigger-1)
			 (:in ?trigger-2)
			 (:in ?trigger-3))))

					; Abductions that can be made of a special 
					; value of orotic acid
		      (rule ((:in (HIGH u-orot) :var ?trigger-1)
			     (:in (HIGH p-citr) :var ?trigger-2))
		       (rassert! (DISEASE citrullinemia)))

		      (rule ((:in (HIGH u-orot)))
		       (rassert! (DISEASE otc-deficiency)))

		      (rule ((:in (HIGH u-orot) :var ?trigger-1)
			     (:in (DISEASE otc-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-orot IS otc-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-orot) :var ?trigger-1)
			     (:in (DISEASE citrullinemia) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-orot IS citrullinemia)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-orot) :var ?trigger-1))
		       (rassert! (DISEASE argininemia))
		       (rassert! (DISEASE al-deficiency)))

		      (rule ((:in (HIGH u-orot) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(pyc-deficiency prop-deficiency 
						 biot-deficiency mm-aciduria 
						 cbl-deficiency bact-overgrowth 
						 cps-nags))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Abductions that can be made of a special 
					; value of asa
		      (rule ((:in (HIGH u-asa) :var ?trigger-1))
		       (rassert! (DISEASE al-deficiency)))

		      (rule ((:in (HIGH u-asa) :var ?trigger-1)
			     (:in (DISEASE al-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-asa IS al-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-asa) :var ?trigger-1))				
		       (rassert! (DISEASE argininemia)))

		      (rule ((:in (HIGH u-asa) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency citrullinemia 
						 pyc-deficiency  prop-deficiency 
						 biot-deficiency mm-aciduria 
						 bact-overgrowth cps-nags 
						 cbl-deficiency))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; rules for homocystine

		      (rule ((:in (HIGH u-hom-cyst) :var ?trigger-1))
		       (rassert! (DISEASE cbl-deficiency)))

		      (rule ((:in (HIGH u-hom-cyst) :var ?trigger-1)
			     (:in (DISEASE cbl-deficiency) :var ?trigger-2))
		       (rassert! (CAUSE-OF HIGH VALUE FOR u-hom-cyst IS cbl-deficiency)
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

		      (rule ((:in (HIGH u-hom-cyst) :var ?trigger-1)
			     (:in (DISEASE ?d) :var ?trigger-2
			      :test (member ?d '(otc-deficiency citrullinemia
						 ppyc-deficiency prop-deficiency
						 biot-deficiency mm-aciduria 
						 bact-overgrowth al-deficiency
						 argininemia cps-nags))))
		       (rassert! Contradiction-Found
			(just (:in ?trigger-1)
			 (:in ?trigger-2))))

					; Thumb's rule: if a disease is found
					; as a cause of two abnormal parameters, it is 
					; considered to be a good diagnosis

		      (rule ((:in (CAUSE-OF ?hi-or-lo  ?val ?for ?param-1 ?is ?d) 
			      :var ?cause-1)
			     (:in (CAUSE-OF ?hi-or-lo2 ?val ?for ?param-2 ?is ?d) 
			      :var ?cause-2
			      :test (neq ?param-1 ?param-2)))
		       (rassert! (DIAGNOSTIC ?d)
			(just (:in ?cause-1)
			 (:in ?cause-2)))))

		    :name-part nil)) 
		:name-part "CLICHE 1.1"))) 
      :contents (list (setq .%%symbol-label%%.4 
			(make-instance 'pail-lib::filentry 
			  :classname "tre-example" 
			  :poolname "CLICHE 1.1"))) 
      :filename "cliche-1.cl")))

;;;=========================================================
;;; END OF FILE
;;;=========================================================
