;;; -*- Mode: LISP; Package: SNLP; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   snlp-pail.cl
;;; Short Desc: Minimal addition to snlp to make it work in PAIL environment.
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   12.5.92 DTA
;;; Author:     Wan
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
; Minimal addition to snlp to make it work in PAIL environment.
; Should really re-do the unifier.  But UofW has a newer version (as
; of 8/1991) of the unifier.
; See also code commented out by #+not-PAIL
; -Hank

(in-package :snlp)

; same as is-int-var
(defun variable? (v)
  (and (symbolp v)
       (eq (aref (symbol-name v) 0) #\?)))

(defmacro variable-id (v)
  v)

(defun instantiate-term (term num)
  (cond ((variable? term)
	 (intern (make-symbol (format nil "~a~d"
				      (planning::strip-number term) num))))
	((listp term)
	 (mapcar-la #'instantiate-term term num))
	(t term)))

(defparameter *tweak-planner*
    (planning::make-planner
     :next-states-fn 'plan-refinements
     :goal-p-fn 'plan-test
     :plan-init-fn 'init-tweak-plan
     :rank-fns '(rank rank1 rank2 rank3)
     :default-search-fn search:*best-first-search*
     :default-rank-fn 'rank
     :graph-fn 'planning::draw-snlp-plan))

(defun init-tweak-plan (initial-state goals)
  (reset-snlp-vars)		; superfluous for PAIL
  (setf *print-plan-fn* #'print-snlp)
  (make-snlp-plan
   :steps (list
	   (make-snlp-step :id '0
		      :add initial-state)
	   (make-snlp-step :id :goal
		      :precond goals))
   :open (mapcar #'(lambda (x) (cons x '(goal))) goals)
   :bindings (make-hash-table :test #'equal)
   :high-step 0))
