;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   planner.cl
;;; Short Desc: definition of data types for both planners
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   14.1.92 DTA
;;; Author:     Wan
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

(in-package :planning)

(export '(*current-planner* planner planner-default-rank-fn planner-default-search-fn
	  planner-rank-fns))

(defparameter *current-search-fn* nil)
(defparameter *current-rank-fn* nil)
(defparameter *limit* 400)

;;;; Planners

(defstruct planner
  next-states-fn
  goal-p-fn
  plan-init-fn
  rank-fns
  default-search-fn
  default-rank-fn
  graph-fn)

(defparameter *current-planner* nil)

(defun use-planner (planner)
  (setf *current-planner* planner)
  (when (planner-default-search-fn *current-planner*)
    (use-searcher (planner-default-search-fn *current-planner*)))
  (when (planner-default-rank-fn *current-planner*)
    (use-ranker (planner-default-rank-fn *current-planner*)))
  t)

(defun use-searcher (searcher)
  (setf *current-search-fn* searcher)
  t)

(defun use-ranker (rank-fn)
  (setf *current-rank-fn* rank-fn)
  t)


(defun use-world (world)
  (setf *world* world))

;; making an instance of an operator

(defvar *subs*)

(defmethod dup-op ((oo op))
  (let ((*subs* nil))
    (make-instance 'op
     :opname (rename-list (opname oo))
     :filter (rename-list (filter oo))
     :subgoals (rename-list (subgoals oo))
     :add-list (rename-list (add-list oo))
     :del-list (rename-list (del-list oo))
     :not-same (rename-list (not-same oo)))))

(defun rename-list (l)
  (cond ((atom l) (rename-var l))
	((consp l) (recons (rename-list (car l))
			   (rename-list (cdr l))
			   l))
	(t (error "rename-list: unknown thing"))))

(defun recons (x y c)
  (if (and (eq (car c) x)
	   (eq (cdr c) y))
      c
    (cons x y)))

(defun rename-var (v)
  (if (is-int-var v)
      (let ((lookup (assoc v *subs*)))
	(if lookup (cdr lookup)
	  (let ((nv (intern (gensym (strip-number v)))))
	    (push (cons v nv) *subs*)
	    nv)))
    v))

(defun strip-number (v)
  (string-right-trim "0123456789" (symbol-name v)))

;;;; Interface

(defun solve (initial-state goals)
  (funcall *current-search-fn*
	   (funcall (planner-plan-init-fn *current-planner*)
		    initial-state goals)
	   (planner-next-states-fn *current-planner*)
	   (planner-goal-p-fn *current-planner*)
	   *current-rank-fn*
	   *limit*))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
