;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   trees.cl  
;;; Short Desc: class definition for trees
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   5.2.91 TW
;;; Author:     DTA SK TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;; Moved from trees.cl because the class rule-set need not always be
;;; loaded  before the trees file.
;;; --------------------------------------------------------------------------



(in-package :pail-lib)

(export '(change-type))

;;; Given a decision tree, produces a rule set with the same behavior.

(defmethod change-type ((dtree decision-tree) (rset rule-set))
  (make-instance 'rule-set
    :name-part "Rule-set"
    :rule-set-part
    (mapcar #'make-rule-from-path
	    (intern-all (get-paths dtree) :dump))))


(defun make-rule-from-path (path)
  (make-instance 'rule
    :name-part "ID3-Rule"
    :if-part (do* ((l path (cddr l))
		   (result nil (cons (list (second l)
					   (first l))
				     result)))
		 ((null (cddr l)) result))
    :then-part (list (second path) (first path))))

(defmethod change-type ((table working-table) (wm working-memory))
  ;; Most working memories are just lists of object-attribute-value
  ;; triples or attribute-value pairs.  These can be represented and
  ;; edited easily as tables.   
  (let ((answer nil))
    (cond  ((equalp 1 (length (rows table))) ; If there is only one
					; item, then we do
					; attribute/value pairs. 
	    (dolist (row (rows table))
	      (do ((attribute (intern-all (attributes table) :rules) (cdr attribute))
		   (item row (cdr item))
		   )
		  ((null attribute) nil)
		(when (not (is-question (car item))) (push (list
							    (intern-all (car attribute) :rules)
							    (intern-all (car item) :rules))  answer))))) 
	   (t (dolist (row (rows table)) ; otherwise we do
					; object/attribute/value
					; triples. 
		(let ((name (car row)))
		  (do ((attribute (cdr (attributes table)) (cdr attribute))
		       (item (cdr row) (cdr item))
		       )
		      ((null attribute) nil)
		    (when (not (is-question (car item))) (push (list
								(intern-all name :rules)
								(intern-all (car attribute) :rules)
								(intern-all (car item) :rules))  answer)))))))
    (make-instance 'working-memory
      :name-part "from table"
      :assertions (reverse answer)
      :trace-info (trace-info table))
    ))

; (defun intern-all  (list package)
; 
;    (cond ((null list) nil)
; 	((numberp list) list)
; 	((stringp list) list)
; 	((atom list) (intern (symbol-name list) package))
; 	(t (let ((result nil))
; 	     (loop for item in list collect (intern-all item package))
; 	     )))
;    )


(defun is-question (item)
  (cond ((stringp item) (equal "?" item))
	((symbolp item) (equal (symbol-name item) "?"))
	(t nil)))



(defmethod change-type ((wm working-memory) (table working-table)) 
  (let* ((wma (intern-all (assertions wm) :rules))
	 (ans (if (equal 2 (length (car wma)))
		  (make-instance  'working-table
		    :attributes (delete-duplicates (mapcar 'car wma))
		    :rows (list (loop for i in (delete-duplicates (mapcar 'car wma)) collect 'rules::?))
		    :trace-info (trace-info wm))
		(make-instance  'working-table
		  :attributes (cons 'rules::object (delete-duplicates (mapcar 'cadr wma)))
		  :rows (loop for obj in (delete-duplicates (mapcar 'car wma)) collect
			  (cons obj (loop for i in (delete-duplicates (mapcar 'cadr wma)) collect 'rules::?)))
		  :trace-info (trace-info wm))))
	 )
    
    (if (equal 2 (length (car wma)))
	 (loop for fact in wma do 
	  (set-nth-value  (car fact) 0 ans (cadr fact))) 
      (loop for fact in wma do 
	(set-value 'rules::object (car fact) (cadr fact) ans (caddr fact))))

    ans)
  )


(defmethod rules::rules-table-edit ((wm working-memory) &rest args)
  (eval `(rules::rules-table-edit (change-type ,wm (make-instance 'working-table)) ,@args)))

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
