;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   table-ed.cl
;;; Short Desc: tiny editor for rules
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   29.8.91 - DTA
;;; Author:     Dean Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail-lib)

(export '(rule-edit))

(defclass table-rule ()
	  ((name-part  :accessor name-part
		       :initarg :name-part
		       :initform nil
		       :type symbol)
	   (if-table   :initarg :if-table
		       :initform nil
		       :accessor if-table
		       :type table)
	   (then-table :initarg :then-table
		       :initform nil
		       :accessor then-table
		       :type table)))


(defmethod rule-edit ((rule rule))
  (make-instance 'table-rule
    :name-part (name-part rule)
    :if-table (table-edit (change-type (make-instance 'working-memory
					 :assertions (if-part rule)
					 :name-part (name-part rule))
				       (make-instance 'working-table)))
    :then-table (table-edit (change-type (make-instance 'working-memory
					   :assertions (list (then-part rule))
					   :name-part (name-part rule))
					 (make-instance 'working-table)))))    
    

(defmethod change-type ((table-rule table-rule) (rule rule))
  (make-instance 'rule
    :name-part (name-part table-rule)
    :if-part (assertions (change-type (if-table table-rule)
				      (make-instance 'working-memory)))
    :then-part (assertions (change-type (then-table table-rule)
				      (make-instance 'working-memory)))
    ))


(defmethod change-type ((rule rule) (table-rule table-rule))
  (make-instance 'table-rule
    :name-part (name-part rule)
    :if-table (change-type (make-instance 'working-memory
			     :assertions (if-part rule)
			     :name-part (name-part rule))
			   (make-instance 'working-table))
    :then-table (change-type (make-instance 'working-memory
			       :assertions (then-part rule)
			       :name-part (name-part rule))
			     (make-instance 'working-table))))


(defmethod change-type ((a rule) (b rule)) a)


(defmethod edit-rule-set ((rule-set rule-set))
  (let* ((disp (make-instance 'display
		:left 200
		:bottom 150
		:height (+ (font-character-height *default-font*) 155)
		:title (format nil "Rule set ~a" (name-part rule-set)))
	       )
	 (done-button (make-instance 'push-button :label "Exit" :width 90))
	 (selection (make-instance 'select-button
			  :label "Available rules: "
			  :height 150
			  :items (mapcar #'(lambda (item) (symbol-name (name-part item)))
					 (rule-set-part rule-set))
			  :action #'(lambda nil (setf (car (find-rule (item-label) rule-set))
						  (rule-edit (car (find-rule (item-label) rule-set)))))
			  ))
	 )
    (set-button done-button disp
		    :left 260
		    :bottom 5
		    :action #'(lambda nil
				(setf (rule-set-part rule-set)
				  (loop for rule in (rule-set-part rule-set)
				    collect (change-type rule (make-instance 'rule))))
				
				
				(write-display disp "Rules edited." 250 70)
				
				(close-display disp)))
    (set-button selection disp)))
    

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
