;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-
;;;
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   pail-lib
;;; Short Desc: General library stuff
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   22.4.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;;
;;; Modification history
;;; 10.11.91   intern-all added to this file  -dta
;;;



(in-package :pail-lib)

(eval-when (compile load eval)
  (export '(add-path
	    add-subdir
	    all-symbol-names
	    clear-loaded
	    ensure-loaded 
	    intern-all
	    load-obj
	    log2
	    *readable*
	    remove-nth
	    save-obj
	    findfont
	    )))


(defun intern-all (list package)
  (cond ((null list) nil)
	((numberp list) list)
	((stringp list) (write-to-string (read-from-string list)))
	((atom list) (intern (symbol-name (read-from-string (write-to-string list))) package))
	(t (cons (intern-all (car list) package) (intern-all (cdr list) package)))))


(defun all-symbol-names (list) (string-right-trim '(#\Space) (Rall-symbol-names list)))


(defun Rall-symbol-names (list)
  (concatenate 'string
    (cond ((null list) nil)
	((numberp list) (write-to-string list))
	((stringp list) list)
	((atom list) (symbol-name list))
	(t (let ((result nil))
	     (eval `(concatenate 'string
		     "("
		     ,@ (dolist (c list
				  (reverse (cons
					    (string-right-trim '(#\Space) (car result))
					    (cdr result))))
		       (push (Rall-symbol-names c) result))
		     ")"))
	     )))
    " "))






(defvar *loaded* (make-hash-table))


(defun add-path (file-name path)
  (merge-pathnames file-name path))


(defun add-subdir (path &rest subdir)
  "Adds one ore several subdirectories to path"
  (make-pathname 
   :name (file-namestring path)
   :directory (append (pathname-directory path) subdir)))


(defun ensure-fasl (string &optional (force-compile nil))
  (let ((source (merge-pathnames
		 (make-pathname :type *sourcefile-type*)
		 string))
	(fasl (merge-pathnames
	       (make-pathname :type *faslfile-type*)
	       string)))
    (when (or (not (probe-file fasl))
	      (< (file-write-date fasl) (file-write-date source))
	      force-compile)
      (compile-file source)
      t)))


(defun ensure-loaded (string &key (source nil) (force nil) (force-compile nil))
  (let* ((not-found (gensym))
	 (name-sym (intern (pathname-name string) :pail-lib))
	 (loaded-p (gethash name-sym *loaded* not-found)))
    (when (not *runtime*)
(if source
	(if force
	    (progn
	      (load (merge-pathnames 
		     (make-pathname :type *sourcefile-type*) 
		     string))
	      (setf (gethash name-sym *loaded*) t))
	  (if (member loaded-p (list nil not-found))
	      (progn
		(load (merge-pathnames 
		       (make-pathname :type *sourcefile-type*) 
		       string))
		(setf (gethash name-sym *loaded*) t))))
      (let ((new-fasl (ensure-fasl string force-compile)))
	(if force
	    (progn
	      (load (merge-pathnames 
		     (make-pathname :type *faslfile-type*) 
		     string))
	      (setf (gethash name-sym *loaded*) t))
	  (if (or (member loaded-p (list nil not-found))
		  new-fasl)
	      (progn
		(load (merge-pathnames 
		       (make-pathname :type *faslfile-type*) 
		       string))
		(setf (gethash name-sym *loaded*) t)))))))))


(defun clear-loaded ()
  (clrhash *loaded*))


;;; --------------------------------------------------------------------------
;;; OBJECT FUNCTIONS
;;; --------------------------------------------------------------------------


(defvar *readable* nil "Controls whether objects are printed readably")


;;; Saving and loading objects;  save is done with print
(defun save-obj (object &key (file-name "dump.cld"))
  (with-open-file (output file-name 
		   :direction :output 
		   :if-exists :supersede)
    (print object output)))


(defun load-obj (&key (file-name "dump.cld"))
  (with-open-file (input file-name :direction :input)
    (read input)))


;;; --------------------------------------------------------------------------
;;; MATH FUNCTIONS
;;; --------------------------------------------------------------------------


(defun log2 (n)                         ; log 0 seems implementation
  (if (= n 0) -100000000 (log n 2)))	; dependent indefinite or an error


;;; Given a non-negative integer n and a list, returns the list
;;; without its nth item (start counting at 0)
(defun remove-nth (n seq)
  (cond ((null seq) nil)
	((= n 0) (cdr seq))
        (t (cons (car seq) (remove-nth (- n 1) (cdr seq))))))



;;; misc =======

(in-package :gin)

(eval-when (compile load eval)
  (export '(format-display)))
	    

(defmethod format-display (wherever fmt-string &rest args)
  (apply #'format (append (list wherever fmt-string) args)))

(in-package :pail-lib)


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
