;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   np-tables.cl
;;; Short Desc: dialog handling for np
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   26.6.92 - DTA
;;; Author:     Thomas Wehrle & Nick Almassy
;;;

;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;


(in-package :pail-lib)

(export '(training-data-class input-patterns target-patterns))


(defclass training-data-class ()
  ((input-patterns   :initform (make-table :attributes nil :rows nil)
		     :initarg :input-patterns
		     :accessor input-patterns
		     :type pail-lib:table)
   (target-patterns  :initform (make-table :attributes nil :rows nil)
		     :initarg :target-patterns
		     :accessor target-patterns
		     :type pail-lib:table))
  (:documentation "Collection of two tables (input-patterns and target-patterns)"))

(defmethod change-type ((a training-data-class) (b training-data-class)) a)

(defmethod change-type ((a training-data-class) (b table))
  (make-instance 'table
    :attributes (append (attributes (target-patterns a)) (attributes (input-patterns a)))
    :rows (loop for rowi in (rows (input-patterns a))
	      for rowt in (rows (target-patterns a))
	      collect (append rowt rowi))
    ))

(defmethod change-type ((a table) (b training-data-class))
  (documentation-print "Choose which attributes will correspond to the output nodes ~% of the network")
  (let* ((choices (make-instance 'menu
		    :items (cons '(done done)
				 (loop for att in (attributes a)
				     collect (list att att)))
		    :query "Target attribute(s):"))
	 (selections (remove-duplicates
		      (loop for choice = (accept-items choices)
			  until (eq choice 'done) collect choice)))
	 (targetdesc (loop for attr in selections
			as pvals = (get-possible-values attr a)
			as vals = (get-values attr a)
			append (cond ((loop for p in pvals always (numberp p))
				      (cons attr vals))
				     ((<= (length pvals) 2)
				      (list (cons attr (loop for v in vals collect
							     (if (eq v (car pvals)) 1.0 0.0)))))
				     (t (loop for p in pvals
					    collect
					      (cons (intern (format nil "~a-~a" attr p) :dump)
						    (loop for v  in vals collect
							  (if (eq v p) 1.0 0.0))))))))
	 (inputdesc (loop for attr in (set-difference (attributes a) selections)
			as pvals = (get-possible-values attr a)
			as vals = (get-values attr a)
			append (cond ((loop for p in pvals always (numberp p))
				      (cons attr vals))
				     ((<= (length pvals) 2)
				      (list (cons attr (loop for v in vals collect
							     (if (eq v (car pvals)) 1.0 0.0)))))
				     (t (loop for p in pvals
					    collect
					      (cons (intern (format nil "~a-~a" attr p) :dump)
						    (loop for v  in vals collect
							  (if (eq v p) 1.0 0.0)))))))))
    (make-instance 'training-data-class
      :target-patterns (make-instance 'table
			 :attributes (loop for col in targetdesc collect (car col))
			 :rows (loop for i from 1 to (- (length (car targetdesc)) 1)
				 collect (loop for col in targetdesc collect (nth i col))))
					  
      :input-patterns (make-instance 'table
			 :attributes (loop for col in inputdesc collect (car col))
			 :rows (loop for i from 1 to (- (length (car inputdesc)) 1)
				 collect (loop for col in inputdesc collect (nth i col)))))))
    
    
    


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
