;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:PAIL-LIB; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   help-button.cl
;;; Short Desc: Specialized push-button for PAIL help
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   28.6.91
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;; 
;;;	
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;;
;;;

(in-package :pail-lib)

(eval-when (compile load)
	   (ensure-loaded (add-path "global" *pail-lib-dir*))  
	   (export '(help-button technical-window general-window format-display-fill)))



(defclass help-button (push-button)
 ((technical :initarg :technical
	     :initform nil
	     :accessor technical
	     :type pathname)
	     
  (technical-window
  	     :initform nil
             :accessor technical-window
	     :type pathname)
  (general
	     :initarg :general
             :initform nil
	     :accessor general
	     :type pathname)
	     
  (general-window :initform nil
	     :accessor general-window
	     :type pathname)
	     
  (action    :initform nil
	     :accessor action)
	     
  (menu      :initform
              (make-instance 'menu
		:items '(("general" general
			 "Gives general help about PAIL subject matter.")
			 ("technical" technical
			 "Shows help about how to use a PAIL window.")))
		:accessor menu
		:type menu)
   (subject  :initform "Pail"	; What is help about?  Appears in title line.
	     :accessor subject
             :initarg :subject
	     :type string)
   (label    :initform "Help"
             :accessor label
	     :type string)
   (width :initform 70
		  :accessor width
		  :type integer))
  )

(defmethod initialize-instance :after ((help help-button) &rest keys)
  (declare (ignore keys))
  (setf (action help)
    `(lambda ()


      (progn
       (case (accept-items ,(menu help))
	((technical)
	 (gin::expose (make-technical-window ,help (technical ,help))))
	((general)
	 (gin::expose (make-general-window ,help (general ,help)))))
       (reset-button ,help)))))



(defmethod make-technical-window ((b help-button) starting-path)
  (if 
   (or (not (technical-window b)) (not (status (technical-window b))))
   (let ((print-button (make-instance 'push-button :label "Print")))
    (setf (technical-window b)
	  (make-instance 'help-display
	    :width 520
	    :left 20
	    :button-region t
	    :title (format nil "Technical help on ~a" (subject b))
	    :filename starting-path))
	(set-button print-button (technical-window b)
		    :active t
		    :bottom 5
		    :left 5
		    :action `(lambda () (user::run-shell-command
					 (format nil "~a ~a" ,*print-command* ,starting-path)
					 :wait nil)
				     (reset-button ,print-button)))
	))
    
  (technical-window b))


(defmethod make-general-window ((b help-button) starting-path)
  (if (or (not (general-window b)) (not (status (general-window b))))
      (let ((print-button (make-instance 'push-button :label "Print")))
	(setf (general-window b)
	  (make-instance 'help-display  :width 520 :left (- (width *root-window*) 520) :button-region t
			:title (format nil "General help on ~a" (subject b)) :filename starting-path))
	(set-button print-button (general-window b)
		    :active t
		    :bottom 5
		    :left 5
		    :action `(lambda () (user::run-shell-command
					 (format nil "~a ~a" ,*print-command* ,starting-path)
					 :wait nil)
				     (reset-button ,print-button)))
	))
  (general-window b))


(defun findfont (width expected-width expected-font)
  ;; For a window of width width, which was designed to be with
  ;; expected-width, which originally had a font size expected-font
  ;; (integer), this returns a more or less appropriately sized font.  
  (let ((size (/ (* expected-font width) expected-width)))
    (cond
     ((< size 8.5) *small-font-9*)
;     ((< size 9.5) *small-font-9*)
     ((< size 10.5) *small-font*)
     ((< size 11.5) *small-font-11*)
     ((< size 13.5) *bold-font*)
     (t *bold-font*))))


(defun word-string (string)
  (let* ((s (string-left-trim '(#\Tab #\Space #\Newline) string))
	 (ws (position-if #'(lambda (x) (member x '(#\Tab #\Space #\Newline)))
			  s))
	 (we (if (null ws) (length s) ws))
	 )
    (if (zerop we)
	(values
	 ""
	 "")
      (values
       (subseq s we)
       (subseq s 0 we)))))
    

(defmethod format-display-fill ((d scroll-display) string)
  (let ((font (cw::window-stream-font (scroll-region d)))
	
	(someoldstring ""))
    (do ((thing (values string "")
		(multiple-value-bind (r w) (word-string thing)
		  (if (or
		       (> (+ (font-string-width font w)
			     (font-string-width font someoldstring))
			  (- (width d) 35))
		       )
		      (progn (format-display d "~a" someoldstring)
			     (setf someoldstring (concatenate 'string w " ")))
		    (setf someoldstring (concatenate 'string someoldstring w " "))
		    )
		  (values r w))))
	((equal "" (string-left-trim '(#\Tab #\Space #\Newline) thing))
	 (format-display d "~a" someoldstring)))))



(defun place-help-button (file win lx by)
  (set-button
   (make-instance 'help-button
     :technical	(add-path
	 	 (concatenate 'string file ".tec") *helpdir*)
     :general	(add-path
	 	 (concatenate 'string file ".gen") *helpdir*))
    win
    :left lx 
    :bottom by))
			  
;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================
