;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:GIN; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   scroll-window.cl
;;; Short Desc: extended functionality with gin/cw
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Jun 15 1991
;;; Author:     na

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :gin)
(use-package :cwex)

(export '(scroll-display scroll-region))

(defclass scroll-display (display)
	  ((button-region :initform nil
			  :initarg :button-region
			  :accessor button-region)
	   (scroll-region :initform nil
			  :initarg :scroll-region
			  :accessor scroll-region)
	   (exit-button :accessor exit-button)
	   (from-button :initform nil
			 :initarg :from-button
			 :accessor from-button))
  (:documentation "A Display with a close button and a scrollable region."))

(defmethod initialize-instance :after ((d scroll-display) &key
				       (width (width d))
				       (height (height d))
				       left bottom
				       (inner-width (inner-width d))
				       (inner-height (inner-height d))
				       button-region (font *small-font*)
				       (scroll-region (scroll-region d))
				       exit-button from-button)
  
  (if *debug* (format t "~%initialize-instance :after (d scroll-display) ~A" d))
  (setf (exit-button d) (make-instance 'push-button :label "Close"))
  (let ((but-reg-off (+ 11 (height (exit-button d)))))
    (setf (scroll-region d) (cw:make-window-stream :title nil
						   :borders 1 :font font
						   :inner-width (- inner-width *static-scroll-bar-width*)
						   :inner-height (- inner-height (if button-region but-reg-off 0))
						   :left (1- *static-scroll-bar-width*)
						   :bottom (if button-region but-reg-off -1)
						   :activate-p t
						   :parent (window d)))
    (cw:modify-window-stream-method (window d) :reshape-notify
				    :after (function (lambda (&rest internal-data)
						       (declare (ignore internal-data ))
						       (setf (cw:window-stream-width (scroll-region d))
							 (max (+ (cw:window-stream-border (window d))
								 (+ 1 (- (width d) *static-scroll-bar-width*)))
							      (cw:window-stream-width (scroll-region d))))
						       (setf (cw:window-stream-height (scroll-region d))
							 (+ (cw:window-stream-border (window d))
							    (cw:window-stream-height (window d))
							    (- (if (button-region d) (1+ but-reg-off) 0))))
						       (reattach-static-scroll-bar (scroll-region d)))))
    (setf (cw:window-stream-extent-height (scroll-region d)) (- height (if button-region but-reg-off 0))))
  (cw:modify-window-stream-method (scroll-region d) :repaint :before 'text-repaint)
  (make-static-scroll-bar (scroll-region d))
  (if *use-new-version*
      (set-button (exit-button d) d
		  :left (- (width d) (width (exit-button d)) 5)
		  :bottom 5
		  :action `(lambda nil
			     (close-display ,d)
			     (if (from-button ,d)
				 (reset-button (from-button ,d)))))
    )
  )

(defmethod format-display ((d scroll-display) fmt-string &rest args)
  (show-list-of-strings (scroll-region d)
			    (make-string-list-from-text (apply #'format (append (list nil fmt-string) args)))
			    :append-p t
			    :wrap-p t
			    :scroll-p t
			    :print-ahead-p nil))
    


(defmethod clear-scroll ((d scroll-display))
  (declare (ignore left bottom width height))
  (setf (cw:window-stream-get (scroll-region d) :text) nil)
  (setf (cw:window-stream-extent-height (scroll-region d)) (cw:window-stream-inner-height (scroll-region d))) 
  (text-repaint (scroll-region d))
  (cw:repaint (scroll-region d)))

(defmethod clear-scroll (something-else)
  (declare (ignore something-else)))

(defmethod (setf font) (newfont (d cw:window-stream))
  (setf (cw:window-stream-font d) newfont))

(defmethod status ((d scroll-display))
  (and (equal (cw:window-stream-status (window d)) :active)
       (equal (cw:window-stream-status (scroll-region d)) :active)))
