;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   select-button.cl
;;; Short Desc: example file of the usage of select-buttons
;;; Author:	NA
;;; INTERNAL
;;; ==========================================================================

(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display :title "select-buttons"))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 260 :bottom 5
	    :action `(lambda nil (close-display ,disp)))


(setf *big-font* (open-font :courier :roman 24 :weight :medium))
		
(setf sb (make-instance 'select-button
	   :label "Please select a widget:"
	   :height 150
	;  :width 50
	   :items '("Something" "-unknown-" "Nomic"
		    "Sarah" "Rain" "Riegel" "love" "100" "CRASH" "wet")
	;  :exclusive t
	;  :font *big-font*
	   :action '(lambda nil (format t "~%You selected ~A" (item-label)))
	   ))
(set-button sb disp)

#|

;;; That's the way to find out what the user selected already:

(documentation-print (format nil "~A" (mapcar #'status (items sb))))

;;; This is the way to setf an action to a item in the list of the
;;; button:

(dolist (i (items sb) t)
  (setf (action i) `(lambda nil
		      (documentation-print (format nil "The item~%~a~%was chosen" ,i))
		      )))

;;; You can as well initialize the slot `action' at make-instance of
;;; the select-button for all items at once. But unfortunately you can
;;; only get the label of the item but not the state. The label of the
;;; select item is returned by the function item-label.

;;; ====

;;; You can disable some items in the list, but (unlike the
;;; push-buttons) once you call enable-button, the select-item is
;;; enabled again no matter how many times you disabled this item.

(disable-button (cadr (items sb)))
(enable-button  (cadr (items sb)))

;;; You can also enable/disable the whole button with the methods
;;; enable-button/disable-button respectively. Call unset-button to
;;; remove a button from the display.

 ;;; ====

;;; Warning: never do the following when the select-button is made
;;; with the option :exclusive T! The exit-button will never become
;;; enabled again (since you can't clear a select-item with a
;;; mouse-click).

(dolist (i (items sb) t)
  (setf (inhibit-buttons i) (list exit-button)))


|#
