;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   push-button.cl
;;; Short Desc: example file of the usage of push-buttons
;;; Author:	NA
;;; INTERNAL
;;; ==========================================================================

(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display :title "push-buttons"
			 :left 600 :height 260))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 345 :bottom 5
	    :action `(lambda nil (close-display ,disp)))


(defun nothing () (reset-button big-button))
(setf big-button (make-instance 'push-button :label "BIG"
				:width 100 :height 50))
(set-button big-button disp :left 5 :bottom 5
	    :action 'nothing)

;;; The width of a push-button is set by the method
;;; initialize-instance to the (default) minimum size:
;;; (width == (max (+ 8 (if (label big-button) (font-string-width (font disp) (label big-button)) 0))
;;;		   (if (slot-boundp big-button 'bitmap)
;;;		       (+ 5 (width (bitmap big-button)))
;;;		     0)))
;;; (height == (max (+ 6 (font-character-height (font disp)))
;;;		    (if (label big-button) 19 0)
;;;		    (if (slot-boundp big-button 'bitmap)
;;;			(+ 5 (height (bitmap big-button)))
;;;		      0)))
;;; but you can set the size of the button to any desired size with the
;;; :width and :height keyword arguments (Do not make the button too
;;; small!). When you set the button in the display, you might want to
;;; specify a function that is called by the button: This is done with
;;; the :action keyword. (see examples)



(setf med-button (make-instance 'push-button :label "Medium"
				:width 70 :height 30))
(set-button med-button disp :left 115 :bottom 15)

;;; When you click into the push-button the button becomes black and
;;; the label will become gray. Then the button remains disabled until
;;; the next call of the method (reset-button med-button).
;;; IMPORTANT: If you disable the button while the current state of the
;;; button is "pushed", then after the next call of (reset-button
;;; med-button) the button will be still disabled but will become
;;; white/gray. If you disable a push-button more the once, then you
;;; have to enable the button the same number of times.


(setf sml-button (make-instance 'push-button :label "small"
				:inhibit-buttons (list exit-button)))
(set-button sml-button disp :left 195 :bottom 20
	    :action `(lambda nil
		       (sub ,sml-button)
		       (reset-button ,sml-button)))

;;; The "sml-button" takes the :inhibit-buttons keyword argument that
;;; disables every button in the list whenever the button sml-button is
;;; pushed. The buttons in this list will be enabled again whenever the
;;; (in this case "sml-button") button is either set, enabled or reset
;;; with the methods set-button, enable-button and reset-button
;;; respectively. You don't need to use :inhibit-buttons with a
;;; value-button to disable a button inside the same display: the
;;; value-button disables all the other buttons in the same display
;;; anyway... 


(defun sub (called-by-button)
  (let ((subdisp (make-display :title "I was called by a Button"
			       :width 200 :height 100))
	(exit-button (make-instance 'push-button :label "Exit")))
    (write-display subdisp "Type something!" 5 50)
    (set-button exit-button subdisp :left 143 :bottom 5
		:action `(lambda nil (close-display ,subdisp)))
    (read-display subdisp 5 5)))

(draw-line disp 0 65 400 65)

;;; ==========================================================================

(setf val-button (make-instance 'value-button :name "I am a value-button:"
				:value nil))
(set-button val-button disp :left 280 :bottom 75
	    :action `(lambda nil (format t "My new value is: ~A" (button-value ,val-button))))


;;; A value-button is a subclass of an push-button, if you click into
;;; this button, the button disapears, and the user is prompted for a
;;; new value. If you type just RETURN, the value remains unchanged. A
;;; value-button has also a slot for a name. While the value-button is
;;; clicked and the process is reading from the keyboard, all other
;;; buttons/active-regions are disabled (but you can't see it).
;;; Furthermore the title of the display is temporarily set to "Enter
;;; new Value". After you hit return, the button is re-set and the new
;;; value is used as a label. 



;(read-display disp 10 110 :default "Nick" :flush-input nil)


(setf borderless-button (make-instance 'push-button :label "This is a borderless button"))
(set-button borderless-button disp :left 15 :bottom 110 :border nil
	    :action `(lambda nil
		       (unset-button borderless-button)
		       (write-display ,disp "Only If you move the Pointer in," 15 125)
		       (write-display ,disp "the frame apears..." 15 110)))

;;; You can also define push-buttons without a border - with the
;;; keyword argument :border. These keyword arguments are available
;;; for push-buttons with the following methods:
;;; make-instance:
;;;		:width	- the width of the button (the default width
;;;			is set according to the font and the length of
;;;			the label)
;;;		:height	- the height of the button (the default height
;;;			is set according to the font)
;;;		:label	- the label that appears in the center of the
;;;			button (the default label is "click here")
;;;		:bitmap - common-windows bitmaps that can be read in
;;;			with (read-bitmap "my-bitmap.bm"). These
;;;			bitmaps are centered inside the border of the
;;;			button. (But they are left/bottom aligned
;;;			inside pop-up-buttons) (No default)
;;;		:action	- a symbol that evaluates to a function that
;;;			must not accept any arguments. You can also
;;;			use lambda functions that are quoted with a
;;;			back-quote to select some arguments with the
;;;			"," to be avaluated. (default is nil - no
;;;			function will be called upon button press)
;;;		:inhibit-buttons - a list of buttons that are disabled
;;;			whenever this button is clicked (the default
;;;			is nil)
;;;		:font	- the font of the Label of the button (the
;;;			default is the font gi:*default-font*). The
;;;			type of the font also modifies the size of the
;;;			button, that is generated.
;;;
;;; set-button:
;;;		:left	- the distance between the left side of the
;;;			button and the left border of the display
;;;			(default is 0)
;;;		:bottom	- the distance between the bottom side of the
;;;			button and the bottom border of the display
;;;			(default is 0) 
;;;		:active	- a flag wether the button will be enabled
;;;			after the set-button. If called with nil the
;;;			button must later be enabled with the method
;;;			enable-button. (default is T)
;;;		:action	- a symbol that evaluates to a function that
;;;			must not accept any arguments. You can also
;;;			use lambda functions that are quoted with a
;;;			back-quote to select some arguments with the
;;;			"," to be avaluated. (default is nil - no
;;;			function will be called upon button press
;;;			unless a value was specified at make-instance
;;;			of the button) The previous value of the slot
;;;			action that was assigned with the method
;;;			make-instance is discarded.
;;;		:border	- a flag wether the button will be surounded
;;;			by a border - the button will still be
;;;			animated if you move the mouse in. (default is
;;;			T)


;;; More possibilities:

;(disable-button big-button)
;(enable-button big-button)
;(unset-button big-button)
;(set-button big-button disp)


(defvar we 1)
(defvar must 2)
(defvar be  3)
(defvar over 4)
(defvar the 5)
(defvar rainbow 6)
(defvar mark 7)

(setf mm (make-instance 'menu
	   :items '(("We" we)
		    ("must" must)
		    ("be" be)
		    ("over" over)
		    ("the" the)
		    ("rainbow" rainbow)
		    ("!" mark))))

(setf val-button (make-instance 'value-button
		   :label #| "a Menu-fied value-button:" |# "Try this ThE -->"
		   :menu mm
		   :width 100
		   :before-action #'(lambda ()
			       (format t "Hello")
			       (setf (menu val-button) (make-instance 'menu
							 :items '(("the" the)
								  ("rainbow" rainbow)
								  ("!" mark)))))
		   :action #'(lambda ()
			       (format t "Holla"))))

(set-button val-button disp :left 250 :bottom 150)