;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   make-display.cl
;;; Short Desc: example file of the usage of displays
;;; Author:	NA
;;; INTERNAL only
;;; ==========================================================================

(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display))

;;; Before you create a window you have to initialize common windows.
;;; this is done with the function init-window-system. this method
;;; takes the following arguments:
;;;		:host	- the X-display host where the windows will
;;;			open up. the default is taken from the
;;;			environment variable DISPLAY".
;;;		:prompt-window - a flag whether a prompt window should
;;;			be created. the default is T. help messages
;;;			are written in this display whenever the user
;;;			is holding the mouse over an option of a
;;;			pop-up-menu.


(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 200 :bottom 5
	    :action `(lambda nil (close-display ,disp)))


;;; When you create a display with the method make-display you can
;;; specify the following keyword arguments:
;;;		:left	- the distance between the left side of the
;;;			display and the left of the screen (default is
;;;			*default-display-left*) 
;;;		:bottom	- the distance between the bottom side of the
;;;			display and the bottom of the screen (default
;;;			is *default-display-bottom*) 
;;;		:width	- the (inner-) width of the display (X-window)
;;;			excluding the borders (generated by
;;;			common-windows) the default is
;;;			*default-display-width*
;;;		:height	- the (inner-) height of the display
;;;			(X-window) excluding the borders (generated by
;;;			common-windows) the default is
;;;			*default-display-height*) 
;;;		:inner-width - the inner-width of the display that may
;;;			be used for writing/drawing and setting of
;;;			buttons. This inner-extent can be scrolled
;;;			with the scrollbar and will be refreshed like
;;;			any other region of the display. The
;;;			inner-width can not be set to a value smaller
;;;			than the width of the display.
;;;		:inner-height - the inner-height of the display that
;;;			may be used for writing/drawing and setting of
;;;			buttons. This inner-extent can be scrolled
;;;			with the scrollbar and will be refreshed like
;;;			any other region of the display. The
;;;			inner-height can not be set to a value smaller
;;;			than the height of the display.
;;;		:borders - the border-width of the display. The
;;;			default is *default-display-border*. This
;;;			Variable should be zero because most
;;;			window-managers (e.g. twm) decorate their
;;;			clients with a border. If you use a display
;;;			inside a display (with the option :parent) you
;;;			should supply a non-zero value for :borders or
;;;			setf the variable *default-display-border* to
;;;			an appropriate value.
;;;		:title	- the title of the display that will appear
;;;			both on the title-bar and on the icon (the
;;;			default is *default-display-title*)
;;;		:active	- the status of the display, the default is t.
;;;			When called with nil the display can be
;;;			activated with the method activate-display.
;;;		:x-scrollbar - a flag that controls the appearance or
;;;			the scrollbars on the lower part of the
;;;			window that scroll the inner extent
;;;			horizontally.
;;;		:y-scrollbar - a flag that controls the appearance or
;;;			the scrollbars on the left part of the
;;;			window that scroll the inner extent
;;;			vertically. The scrollbars can be
;;;			enabled/disabled with the method
;;;			enable-scrollbar and the keywords :vertical,
;;;			:horizontal.
;;;		:parent	- the parent window of the display. The
;;;			default is *root-window* - the entire screen.
;;;			The display can not be moved off the parent
;;;			window. 
;;;		:font	- the font for the display that is used for
;;;			buttons and text. The default is
;;;			*default-font* (Courier bold 13).
;;;		:reshape-method	- a function that is called when a
;;;			display is reshaped (either by the twm or the
;;;			"reshape - redraw - flush" menu supplied by
;;;			common-windows.
;;;		:flush-method - a function that is called when a
;;;			display is flushed by the "reshape - redraw -
;;;			flush" menu supplied by common-windows.

(setf subdisp (make-display :parent disp :title "I can't be moved off" :width 150 :height 100
			    :borders 1))

;;; You may change the values of the following slots with setf:
;;; 	title		- string
;;;	borders		- fixnum
;;;	parent		- display (or *root-window*)
;;;	font		- Font
;;;	left		- fixnum
;;;	bottom		- fixnum
;;;	width		- fixnum
;;;	height		- fixnum
;;;	inner-width	- fixnum
;;;	inner-height	- fixnum
;;;	x-scrollbar	- boolean,
;;;	y-scrollbar	- boolean,
;;;	icon		- bitmap,

;;; NOTE: is you setf the parent of a display that is currently
;;; located in the *root-window* (i.e. a seperate X-window) to a
;;; display, then you should setf the left/bottom of that display as
;;; well. If you don't It might happen that the window does not appear
;;; in the display because the left/bottom offset exceeds the
;;; width/height of the display is was set into.

;;; The function file-does-not-exist uses the pathname as first
;;; argument and should be used to inform the user of file-opening
;;; errors. See file help-button.cl for a detailed description.
